/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.QualifierReceiver;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/ClassQualifierReceiver;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/QualifierReceiver;", "explicitReceiver", "Lksp/org/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "classSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "originalSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "useSiteSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getOriginalSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "callableScope", "Lksp/org/jetbrains/kotlin/fir/scopes/FirScope;", "classifierScope", "resolve"})
public final class ClassQualifierReceiver
extends QualifierReceiver {
    @NotNull
    private final FirRegularClassSymbol classSymbol;
    @NotNull
    private final FirClassLikeSymbol<?> originalSymbol;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final ScopeSession scopeSession;

    public ClassQualifierReceiver(@NotNull FirResolvedQualifier explicitReceiver, @NotNull FirRegularClassSymbol classSymbol2, @NotNull FirClassLikeSymbol<?> originalSymbol, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)explicitReceiver, (String)"explicitReceiver");
        Intrinsics.checkNotNullParameter((Object)classSymbol2, (String)"classSymbol");
        Intrinsics.checkNotNullParameter(originalSymbol, (String)"originalSymbol");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(explicitReceiver);
        this.classSymbol = classSymbol2;
        this.originalSymbol = originalSymbol;
        this.useSiteSession = useSiteSession;
        this.scopeSession = scopeSession;
    }

    @NotNull
    public final FirRegularClassSymbol getClassSymbol() {
        return this.classSymbol;
    }

    @NotNull
    public final FirClassLikeSymbol<?> getOriginalSymbol() {
        return this.originalSymbol;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @Nullable
    public FirScope callableScope() {
        FirRegularClass klass = (FirRegularClass)this.classSymbol.getFir();
        FirScopeProvider provider2 = klass.getScopeProvider();
        return provider2.getStaticMemberScopeForCallables(klass, this.useSiteSession, this.scopeSession);
    }

    @Override
    @Nullable
    public FirScope classifierScope() {
        FirRegularClass klass = (FirRegularClass)this.classSymbol.getFir();
        return klass.getScopeProvider().getNestedClassifierScope(klass, this.useSiteSession, this.scopeSession);
    }
}

