/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.FirJvmNamesChecker;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmInvalidAndDangerousCharactersChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmInvalidAndDangerousCharactersChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmInvalidAndDangerousCharactersChecker INSTANCE = new FirJvmInvalidAndDangerousCharactersChecker();

    private FirJvmInvalidAndDangerousCharactersChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement source = declaration2.getSource();
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirRegularClass)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirSimpleFunction)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeParameter) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirTypeParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirProperty) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirProperty)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeAlias) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirTypeAlias)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirValueParameter) {
            FirJvmNamesChecker.INSTANCE.checkNameAndReport(((FirValueParameter)declaration2).getName(), source, context2, reporter);
        } else {
            return;
        }
    }
}

