/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/codegen/optimization/boxing/BoxingFrame;", "Lksp/org/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lksp/org/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "(II)V", "merge", "", "frame", "interpreter", "Lksp/org/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "backend"})
public final class BoxingFrame
extends Frame<BasicValue> {
    public BoxingFrame(int nLocals, int nStack) {
        super(nLocals, nStack);
    }

    @Override
    public boolean merge(@NotNull Frame<? extends BasicValue> frame, @NotNull Interpreter<BasicValue> interpreter2) {
        BasicValue merged;
        int i;
        Intrinsics.checkNotNullParameter(frame, (String)"frame");
        Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
        if (this.getStackSize() != frame.getStackSize()) {
            throw new AnalyzerException(null, "Incompatible stack heights");
        }
        BoxingInterpreter boxingInterpreter = (BoxingInterpreter)interpreter2;
        boolean changed = false;
        int n = this.getLocals();
        for (i = 0; i < n; ++i) {
            BasicValue local = (BasicValue)this.getLocal(i);
            Intrinsics.checkNotNull((Object)local);
            BasicValue basicValue = frame.getLocal(i);
            Intrinsics.checkNotNullExpressionValue((Object)basicValue, (String)"getLocal(...)");
            merged = boxingInterpreter.mergeLocalVariableValues(local, basicValue);
            if (Intrinsics.areEqual((Object)local, (Object)merged)) continue;
            this.setLocal(i, (Value)merged);
            changed = true;
        }
        n = this.getStackSize();
        for (i = 0; i < n; ++i) {
            BasicValue onStack = (BasicValue)this.getStack(i);
            Intrinsics.checkNotNull((Object)onStack);
            BasicValue basicValue = frame.getStack(i);
            Intrinsics.checkNotNullExpressionValue((Object)basicValue, (String)"getStack(...)");
            merged = boxingInterpreter.mergeStackValues(onStack, basicValue);
            if (Intrinsics.areEqual((Object)onStack, (Object)merged)) continue;
            this.setStack(i, (Value)merged);
            changed = true;
        }
        return changed;
    }
}

