/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.util.io.FileAccessorCache;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystem;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarVirtualFile;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipImplementationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u0005J$\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0018\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001f*\u00020\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;", "", "fileSystem", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "path", "", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;Ljava/lang/String;)V", "cachedManifest", "", "file", "Ljava/io/File;", "getFile$cli_base", "()Ljava/io/File;", "getFileSystem", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "myRoot", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "contentsToByteArray", "zipEntryDescription", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;", "createFile", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile;", "entry", "directories", "", "findFileByPath", "pathInJar", "getOrCreateDirectory", "entryName", "", "splitPath", "Lkotlin/Pair;", "cli-base"})
@SourceDebugExtension(value={"SMAP\nFastJarHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastJarHandler.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,117:1\n669#2,11:118\n1#3:129\n381#4,7:130\n*S KotlinDebug\n*F\n+ 1 FastJarHandler.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler\n*L\n36#1:118,11\n82#1:130,7\n*E\n"})
public final class FastJarHandler {
    @NotNull
    private final FastJarFileSystem fileSystem;
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    private final File file;
    @Nullable
    private final byte[] cachedManifest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public FastJarHandler(@NotNull FastJarFileSystem fileSystem, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.fileSystem = fileSystem;
        this.file = new File(path);
        List entries = null;
        Closeable closeable = new RandomAccessFile(this.file, "r");
        Iterator iterator2 = null;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)closeable;
            boolean bl = false;
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
            try {
                byte[] byArray;
                Object object;
                Object $this$singleOrNull$iv;
                Object single$iv;
                FastJarHandler fastJarHandler;
                Object object2;
                block17: {
                    try {
                        Intrinsics.checkNotNull((Object)mappedByteBuffer);
                        object2 = ZipImplementationKt.parseCentralDirectory(mappedByteBuffer);
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).warn("Error while reading zip file: " + this.file.getPath() + ": " + e, e);
                        object2 = CollectionsKt.emptyList();
                    }
                    entries = object2;
                    Iterable e = entries;
                    fastJarHandler = this;
                    boolean $i$f$singleOrNull = false;
                    single$iv = null;
                    boolean found$iv = false;
                    Iterator iterator3 = $this$singleOrNull$iv.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv = iterator3.next();
                        ZipEntryDescription it = (ZipEntryDescription)element$iv;
                        boolean bl2 = false;
                        if (!StringUtil.equals("META-INF/MANIFEST.MF", it.getRelativePath())) continue;
                        if (found$iv) {
                            object = null;
                            break block17;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    object = !found$iv ? null : single$iv;
                }
                FastJarHandler fastJarHandler2 = fastJarHandler;
                object2 = (ZipEntryDescription)object;
                if (object2 != null) {
                    void p0;
                    $this$singleOrNull$iv = object2;
                    Intrinsics.checkNotNull((Object)mappedByteBuffer);
                    MappedByteBuffer $i$f$singleOrNull = mappedByteBuffer;
                    single$iv = $this$singleOrNull$iv;
                    fastJarHandler = fastJarHandler2;
                    boolean bl3 = false;
                    byArray = ZipImplementationKt.contentsToByteArray($i$f$singleOrNull, (ZipEntryDescription)p0);
                    fastJarHandler2 = fastJarHandler;
                } else {
                    byArray = null;
                }
                fastJarHandler2.cachedManifest = byArray;
            }
            finally {
                FastJarFileSystem $this$lambda_u242_u24lambda_u241 = this.fileSystem;
                boolean bl4 = false;
                Function1<MappedByteBuffer, Unit> function1 = $this$lambda_u242_u24lambda_u241.getUnmapBuffer$cli_base();
                Intrinsics.checkNotNull((Object)mappedByteBuffer);
                function1.invoke((Object)mappedByteBuffer);
            }
            randomAccessFile = Unit.INSTANCE;
        }
        catch (Throwable randomAccessFile) {
            iterator2 = randomAccessFile;
            throw randomAccessFile;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)((Object)iterator2));
        }
        this.myRoot = new FastJarVirtualFile(this, "", -1, null, null);
        HashMap filesByRelativePath = new HashMap(entries.size());
        ((Map)filesByRelativePath).put("", this.myRoot);
        for (ZipEntryDescription entryDescription : entries) {
            if (!entryDescription.isDirectory()) {
                this.createFile(entryDescription, filesByRelativePath);
                continue;
            }
            this.getOrCreateDirectory(entryDescription.getRelativePath(), filesByRelativePath);
        }
        for (FastJarVirtualFile node : filesByRelativePath.values()) {
            node.initChildrenArrayFromList();
        }
    }

    @NotNull
    public final FastJarFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final File getFile$cli_base() {
        return this.file;
    }

    private final FastJarVirtualFile createFile(ZipEntryDescription entry, Map<String, FastJarVirtualFile> directories2) {
        Pair<CharSequence, CharSequence> pair = this.splitPath(entry.getRelativePath());
        CharSequence parentName = (CharSequence)pair.component1();
        CharSequence shortName2 = (CharSequence)pair.component2();
        FastJarVirtualFile parentFile = this.getOrCreateDirectory(parentName, directories2);
        if (Intrinsics.areEqual((Object)".", (Object)shortName2)) {
            return parentFile;
        }
        return new FastJarVirtualFile(this, shortName2, entry.isDirectory() ? -1 : entry.getUncompressedSize(), parentFile, entry);
    }

    /*
     * WARNING - void declaration
     */
    private final FastJarVirtualFile getOrCreateDirectory(CharSequence entryName, Map<String, FastJarVirtualFile> directories2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, FastJarVirtualFile> map = directories2;
        String key$iv = ((Object)entryName).toString();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Pair<CharSequence, CharSequence> pair = this.splitPath(entryName);
            CharSequence parentPath = (CharSequence)pair.component1();
            CharSequence shortName2 = (CharSequence)pair.component2();
            FastJarVirtualFile parentFile = this.getOrCreateDirectory(parentPath, directories2);
            FastJarVirtualFile answer$iv = new FastJarVirtualFile(this, shortName2, -1, parentFile, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FastJarVirtualFile)object;
    }

    private final Pair<CharSequence, CharSequence> splitPath(CharSequence $this$splitPath) {
        int slashIndex;
        for (slashIndex = $this$splitPath.length() - 1; slashIndex >= 0 && $this$splitPath.charAt(slashIndex) != '/'; --slashIndex) {
        }
        if (slashIndex == -1) {
            return new Pair((Object)"", (Object)$this$splitPath);
        }
        return new Pair((Object)$this$splitPath.subSequence(0, slashIndex), (Object)$this$splitPath.subSequence(slashIndex + 1, $this$splitPath.length()));
    }

    @Nullable
    public final VirtualFile findFileByPath(@NotNull String pathInJar) {
        Intrinsics.checkNotNullParameter((Object)pathInJar, (String)"pathInJar");
        VirtualFile virtualFile2 = this.myRoot;
        return virtualFile2 != null ? virtualFile2.findFileByRelativePath(pathInJar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] contentsToByteArray(@NotNull ZipEntryDescription zipEntryDescription) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)zipEntryDescription, (String)"zipEntryDescription");
        CharSequence relativePath = zipEntryDescription.getRelativePath();
        if (StringUtil.equals(relativePath, "META-INF/MANIFEST.MF")) {
            if (this.cachedManifest == null) {
                throw new FileNotFoundException(this.file + "!/" + relativePath);
            }
            return this.cachedManifest;
        }
        Closeable closeable = this.fileSystem.getCachedOpenFileHandles$cli_base().get(this.file);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            FileAccessorCache.Handle it = (FileAccessorCache.Handle)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            FileAccessorCache.Handle handle2 = it;
            synchronized (handle2) {
                boolean bl2 = false;
                byArray2 = ZipImplementationKt.contentsToByteArray((MappedByteBuffer)((Pair)it.get()).getSecond(), zipEntryDescription);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }
}

