/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.caches.CleanableSoftValueCache;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirDanglingFileSession;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModuleKt;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import ksp.org.jetbrains.kotlin.platform.JsPlatform;
import ksp.org.jetbrains.kotlin.platform.SimplePlatform;
import ksp.org.jetbrains.kotlin.platform.TargetPlatform;
import ksp.org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import ksp.org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0016JK\u0010\u0019\u001a\u00020\b\"\b\b\u0000\u0010\u001a*\u00020\u00072\u0006\u0010\u0016\u001a\u0002H\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\b0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020\u000eJ\u0015\u0010#\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b$J\u0019\u0010%\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0007H\u0082\u0010J\u0006\u0010'\u001a\u00020\u0012J5\u0010(\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u001dH\u0082\bJ\u0006\u0010*\u001a\u00020\u0012J \u0010+\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J\u000e\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u000eJ \u0010.\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J\u000e\u0010/\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0007J\u000e\u00100\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007J(\u00101\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00072\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J\u0006\u00102\u001a\u00020\u0012R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00064"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "Lksp/com/intellij/openapi/Disposable;", "project", "Lksp/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "binaryCache", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtModule;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "danglingFileSessionCache", "sourceCache", "unstableDanglingFileSessionCache", "supportsIsolatedSessionCreation", "", "getSupportsIsolatedSessionCreation", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Z", "checkSessionValidity", "", "session", "createPlatformAwareSessionFactory", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "module", "createSession", "dispose", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "getDanglingFileCachedSession", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtDanglingFileModule;", "getSession", "preferBinary", "getSessionNoCaching", "getSessionNoCaching$low_level_api_fir", "hasContextModule", "contextModule", "removeAllDanglingFileSessions", "removeAllMatchingSessionsFrom", "shouldBeRemoved", "removeAllScriptSessions", "removeAllScriptSessionsFrom", "removeAllSessions", "includeLibraryModules", "removeAllSessionsFrom", "removeContextualDanglingFileSessions", "removeSession", "removeSessionFrom", "removeUnstableDanglingFileSessions", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n199#1:276\n200#1,4:278\n204#1:283\n199#1:284\n200#1,4:286\n204#1:291\n199#1:292\n200#1,4:294\n204#1:299\n199#1:300\n200#1,4:302\n204#1:307\n37#2,2:271\n37#2,2:273\n1#3:275\n1863#4:277\n1864#4:282\n1863#4:285\n1864#4:290\n1863#4:293\n1864#4:298\n1863#4:301\n1864#4:306\n1863#4,2:308\n1734#4,3:310\n1734#4,3:313\n1734#4,3:316\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n146#1:276\n146#1:278,4\n146#1:283\n160#1:284\n160#1:286,4\n160#1:291\n163#1:292\n163#1:294,4\n163#1:299\n189#1:300\n189#1:302,4\n189#1:307\n76#1:271,2\n93#1:273,2\n146#1:277\n146#1:282\n160#1:285\n160#1:290\n163#1:293\n163#1:298\n189#1:301\n189#1:306\n199#1:308,2\n233#1:310,3\n234#1:313,3\n235#1:316,3\n*E\n"})
public final class LLFirSessionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> sourceCache;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> binaryCache;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> danglingFileSessionCache;
    @NotNull
    private final CleanableSoftValueCache<KtModule, LLFirSession> unstableDanglingFileSessionCache;

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceCache = new CleanableSoftValueCache(sourceCache.1.INSTANCE);
        this.binaryCache = new CleanableSoftValueCache(binaryCache.1.INSTANCE);
        this.danglingFileSessionCache = new CleanableSoftValueCache(danglingFileSessionCache.1.INSTANCE);
        this.unstableDanglingFileSessionCache = new CleanableSoftValueCache(unstableDanglingFileSessionCache.1.INSTANCE);
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KtModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (module2 instanceof KtBinaryModule && (preferBinary || module2 instanceof KtSdkModule)) {
            return this.getCachedSession(module2, this.binaryCache, (Function1)new Function1<KtBinaryModule, LLFirSession>(this, module2){
                final /* synthetic */ LLFirSessionCache this$0;
                final /* synthetic */ KtModule $module;
                {
                    this.this$0 = $receiver;
                    this.$module = $module;
                    super(1);
                }

                public final LLFirSession invoke(KtBinaryModule it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return LLFirSessionCache.access$createPlatformAwareSessionFactory(this.this$0, this.$module).createBinaryLibrarySession((KtBinaryModule)this.$module);
                }
            });
        }
        if (module2 instanceof KtDanglingFileModule) {
            return this.getDanglingFileCachedSession((KtDanglingFileModule)module2);
        }
        return this.getCachedSession(module2, this.sourceCache, (Function1)new Function1<KtModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KtModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }

            public final String getSignature() {
                return "createSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
            }

            public final String getName() {
                return "createSession";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KtModule ktModule2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(ktModule2, bl);
    }

    @NotNull
    public final LLFirSession getSessionNoCaching$low_level_api_fir(@NotNull KtModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.createSession(module2);
    }

    private final LLFirSession getDanglingFileCachedSession(KtDanglingFileModule module2) {
        if (KtModuleKt.isStable(module2)) {
            return this.getCachedSession((KtModule)module2, this.danglingFileSessionCache, (Function1)new Function1<KtModule, LLFirSession>((Object)this){

                public final LLFirSession invoke(KtModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
                }

                public final String getSignature() {
                    return "createSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
                }

                public final String getName() {
                    return "createSession";
                }

                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
                }
            });
        }
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session2 = this.unstableDanglingFileSessionCache.compute(module2, (Function2<KtModule, LLFirSession, LLFirSession>)((Function2)new Function2<KtModule, LLFirSession, LLFirSession>(module2, this){
            final /* synthetic */ KtDanglingFileModule $module;
            final /* synthetic */ LLFirSessionCache this$0;
            {
                this.$module = $module;
                this.this$0 = $receiver;
                super(2);
            }

            public final LLFirSession invoke(KtModule ktModule2, LLFirSession existingSession) {
                Intrinsics.checkNotNullParameter((Object)ktModule2, (String)"<anonymous parameter 0>");
                return existingSession instanceof LLFirDanglingFileSession && ((LLFirDanglingFileSession)existingSession).getModificationStamp() == this.$module.getFile().getModificationStamp() ? existingSession : LLFirSessionCache.access$createSession(this.this$0, this.$module);
            }
        }));
        if (session2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.checkSessionValidity(session2);
        return session2;
    }

    private final <T extends KtModule> LLFirSession getCachedSession(T module2, CleanableSoftValueCache<KtModule, LLFirSession> storage2, Function1<? super T, ? extends LLFirSession> factory2) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        if (this.getSupportsIsolatedSessionCreation(module2)) {
            lLFirSession = storage2.computeIfAbsent(module2, (Function1<KtModule, LLFirSession>)((Function1)new Function1<KtModule, LLFirSession>(factory2, module2){
                final /* synthetic */ Function1<T, LLFirSession> $factory;
                final /* synthetic */ T $module;
                {
                    this.$factory = $factory;
                    this.$module = $module;
                    super(1);
                }

                public final LLFirSession invoke(KtModule it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (LLFirSession)this.$factory.invoke(this.$module);
                }
            }));
        } else {
            lLFirSession = storage2.get(module2);
            if (lLFirSession == null) {
                LLFirSessionCache $this$getCachedSession_u24lambda_u240 = this;
                boolean bl = false;
                LLFirSession danglingSession = (LLFirSession)factory2.invoke(module2);
                lLFirSession = storage2.computeIfAbsent(module2, (Function1<KtModule, LLFirSession>)((Function1)new Function1<KtModule, LLFirSession>(danglingSession){
                    final /* synthetic */ LLFirSession $danglingSession;
                    {
                        this.$danglingSession = $danglingSession;
                        super(1);
                    }

                    public final LLFirSession invoke(KtModule it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$danglingSession;
                    }
                }));
            }
        }
        LLFirSession session2 = lLFirSession;
        this.checkSessionValidity(session2);
        return session2;
    }

    private final void checkSessionValidity(LLFirSession session2) {
        if (!session2.isValid()) {
            boolean bl = false;
            String string2 = "A session acquired via `getSession` should always be valid. Module: " + session2.getKtModule();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final boolean removeSession(@NotNull KtModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSourceSessionExist = this.removeSessionFrom(module2, this.sourceCache);
        boolean didBinarySessionExist = module2 instanceof KtBinaryModule && this.removeSessionFrom(module2, this.binaryCache);
        boolean didDanglingFileSessionExist = module2 instanceof KtDanglingFileModule && this.removeSessionFrom(module2, this.danglingFileSessionCache);
        boolean didUnstableDanglingFileSessionExist = module2 instanceof KtDanglingFileModule && this.removeSessionFrom(module2, this.unstableDanglingFileSessionCache);
        return didSourceSessionExist || didBinarySessionExist || didDanglingFileSessionExist || didUnstableDanglingFileSessionExist;
    }

    private final boolean removeSessionFrom(KtModule module2, CleanableSoftValueCache<KtModule, LLFirSession> storage2) {
        return storage2.remove(module2) != null;
    }

    public final void removeAllSessions(boolean includeLibraryModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (includeLibraryModules) {
            this.removeAllSessionsFrom(this.sourceCache);
            this.removeAllSessionsFrom(this.binaryCache);
        } else {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableSoftValueCache<KtModule, LLFirSession> storage$iv = this.sourceCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KtModule module$iv = (KtModule)element$iv$iv;
                boolean bl = false;
                KtModule it = module$iv;
                boolean bl2 = false;
                if (!(!(it instanceof KtBinaryModule) && !(it instanceof KtLibrarySourceModule))) continue;
                storage$iv.remove(module$iv);
            }
        }
        this.removeAllDanglingFileSessions();
    }

    public final void removeUnstableDanglingFileSessions() {
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeContextualDanglingFileSessions(@NotNull KtModule contextModule) {
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        this.removeUnstableDanglingFileSessions();
        if (contextModule instanceof KtDanglingFileModule) {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableSoftValueCache<KtModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KtModule module$iv = (KtModule)element$iv$iv;
                boolean bl = false;
                KtModule it = module$iv;
                boolean bl2 = false;
                if (!(it instanceof KtDanglingFileModule && this.hasContextModule((KtDanglingFileModule)it, contextModule))) continue;
                storage$iv.remove(module$iv);
            }
        } else {
            LLFirSessionCache this_$iv = this;
            CleanableSoftValueCache<KtModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KtModule module$iv = (KtModule)element$iv$iv;
                boolean bl = false;
                KtModule it = module$iv;
                boolean bl3 = false;
                if (!(it instanceof KtDanglingFileModule && ((KtDanglingFileModule)it).isCodeFragment())) continue;
                storage$iv.remove(module$iv);
            }
        }
    }

    private final boolean hasContextModule(KtDanglingFileModule module2, KtModule contextModule) {
        boolean bl;
        block2: {
            while (true) {
                KtModule candidate2;
                if (Intrinsics.areEqual((Object)(candidate2 = module2.getContextModule()), (Object)contextModule)) {
                    bl = true;
                    break block2;
                }
                if (!(candidate2 instanceof KtDanglingFileModule)) break;
                LLFirSessionCache lLFirSessionCache = this_;
                KtDanglingFileModule ktDanglingFileModule = (KtDanglingFileModule)candidate2;
                KtModule ktModule2 = contextModule;
                LLFirSessionCache this_ = lLFirSessionCache;
                module2 = ktDanglingFileModule;
                contextModule = ktModule2;
            }
            bl = false;
        }
        return bl;
    }

    public final void removeAllDanglingFileSessions() {
        this.removeAllSessionsFrom(this.danglingFileSessionCache);
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeAllScriptSessions() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeAllScriptSessionsFrom(this.sourceCache);
        this.removeAllScriptSessionsFrom(this.binaryCache);
    }

    private final void removeAllScriptSessionsFrom(CleanableSoftValueCache<KtModule, LLFirSession> storage2) {
        LLFirSessionCache this_$iv = this;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv$iv = storage2.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KtModule module$iv = (KtModule)element$iv$iv;
            boolean bl = false;
            KtModule it = module$iv;
            boolean bl2 = false;
            if (!(it instanceof KtScriptModule || it instanceof KtScriptDependencyModule)) continue;
            storage2.remove(module$iv);
        }
    }

    private final void removeAllSessionsFrom(CleanableSoftValueCache<KtModule, LLFirSession> storage2) {
        storage2.clear();
    }

    private final void removeAllMatchingSessionsFrom(CleanableSoftValueCache<KtModule, LLFirSession> storage2, Function1<? super KtModule, Boolean> shouldBeRemoved) {
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv = storage2.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModule module2 = (KtModule)element$iv;
            boolean bl = false;
            if (!((Boolean)shouldBeRemoved.invoke((Object)module2)).booleanValue()) continue;
            storage2.remove(module2);
        }
    }

    private final boolean getSupportsIsolatedSessionCreation(KtModule $this$supportsIsolatedSessionCreation) {
        return !($this$supportsIsolatedSessionCreation instanceof KtDanglingFileModule);
    }

    private final LLFirSession createSession(KtModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KtModule ktModule2 = module2;
        if (ktModule2 instanceof KtSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KtSourceModule)module2);
        } else if (ktModule2 instanceof KtLibraryModule ? true : ktModule2 instanceof KtLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (ktModule2 instanceof KtSdkModule) {
            lLFirSession = sessionFactory.createBinaryLibrarySession((KtBinaryModule)module2);
        } else if (ktModule2 instanceof KtScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KtScriptModule)module2);
        } else if (ktModule2 instanceof KtDanglingFileModule) {
            LLFirSession contextSession = this.getSession(((KtDanglingFileModule)module2).getContextModule(), false);
            lLFirSession = sessionFactory.createDanglingFileSession((KtDanglingFileModule)module2, contextSession);
        } else if (ktModule2 instanceof KtNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KtNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KtModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block13: {
            targetPlatform = module2.getPlatform();
            $this$all$iv = targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block14: {
                $this$all$iv = targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block14;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block15: {
                    $this$all$iv = targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof NativePlatform) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                lLFirAbstractSessionFactory = bl5 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
            }
        }
        return lLFirAbstractSessionFactory;
    }

    @Override
    public void dispose() {
    }

    public static final /* synthetic */ LLFirAbstractSessionFactory access$createPlatformAwareSessionFactory(LLFirSessionCache $this, KtModule module2) {
        return $this.createPlatformAwareSessionFactory(module2);
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KtModule module2) {
        return $this.createSession(module2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "()V", "getInstance", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lksp/com/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LLFirSessionCache lLFirSessionCache = project.getService(LLFirSessionCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)lLFirSessionCache, (String)"getService(...)");
            return lLFirSessionCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

