/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import ksp.com.intellij.openapi.util.JDOMUtil;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jdom.Attribute;
import ksp.org.jdom.AttributeList;
import ksp.org.jdom.AttributeType;
import ksp.org.jdom.Comment;
import ksp.org.jdom.Content;
import ksp.org.jdom.ContentList;
import ksp.org.jdom.Element;
import ksp.org.jdom.ImmutableAttribute;
import ksp.org.jdom.ImmutableSameTypeAttributeList;
import ksp.org.jdom.JDOMInterner;
import ksp.org.jdom.Namespace;
import ksp.org.jdom.Parent;
import ksp.org.jdom.Text;
import ksp.org.jdom.filter.ElementFilter;
import ksp.org.jdom.filter.Filter;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

final class ImmutableElement
extends Element {
    private static final List<Attribute> EMPTY_LIST = new ImmutableSameTypeAttributeList(ArrayUtilRt.EMPTY_STRING_ARRAY, null, Namespace.NO_NAMESPACE);
    private final Content[] myContent;
    private static final Content[] EMPTY_CONTENT = new Content[0];
    private final List<Attribute> myAttributes;

    ImmutableElement(@NotNull Element origin2, @NotNull JDOMInterner interner) {
        if (origin2 == null) {
            ImmutableElement.$$$reportNull$$$0(0);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(1);
        }
        this.content = null;
        this.name = interner.internString(origin2.getName());
        this.myAttributes = ImmutableElement.internAttributes(origin2, interner);
        List<Content> origContent = origin2.getContent();
        if (origContent.isEmpty()) {
            this.myContent = EMPTY_CONTENT;
        } else {
            Content[] newContent = new Content[origContent.size()];
            int index2 = 0;
            for (Content o : origContent) {
                if (o instanceof Element) {
                    Element newElement = interner.internElement((Element)o);
                    newContent[index2++] = newElement;
                    continue;
                }
                if (o instanceof Text) {
                    Text newText = interner.internText((Text)o);
                    newContent[index2++] = newText;
                    continue;
                }
                if (o instanceof Comment) continue;
                throw new RuntimeException(o.toString());
            }
            this.myContent = index2 == newContent.length ? newContent : Arrays.copyOf(newContent, index2);
        }
        this.namespace = origin2.getNamespace();
        for (Namespace addns : origin2.getAdditionalNamespaces()) {
            super.addNamespaceDeclaration(addns);
        }
    }

    @NotNull
    private static List<Attribute> internAttributes(@NotNull Element origin2, @NotNull JDOMInterner interner) {
        List<Attribute> originAttributes;
        if (origin2 == null) {
            ImmutableElement.$$$reportNull$$$0(2);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(3);
        }
        if ((originAttributes = JDOMUtil.getAttributes(origin2)).isEmpty()) {
            List<Attribute> list2 = EMPTY_LIST;
            if (list2 == null) {
                ImmutableElement.$$$reportNull$$$0(4);
            }
            return list2;
        }
        AttributeType type2 = null;
        String[] nameValues = new String[originAttributes.size() * 2];
        Namespace namespace = null;
        for (int i = 0; i < originAttributes.size(); ++i) {
            Attribute origAttribute = originAttributes.get(i);
            if (type2 == null) {
                type2 = origAttribute.getAttributeType();
                namespace = origAttribute.getNamespace();
            } else if (type2 != origAttribute.getAttributeType() || !origAttribute.getNamespace().equals(namespace)) {
                type2 = null;
                break;
            }
            String name2 = interner.internString(origAttribute.getName());
            String value2 = interner.internString(origAttribute.getValue());
            nameValues[i * 2] = name2;
            nameValues[i * 2 + 1] = value2;
        }
        if (type2 == null) {
            List<Attribute> list3 = Collections.unmodifiableList(ContainerUtil.map(originAttributes, attribute -> new ImmutableAttribute(interner.internString(attribute.getName()), interner.internString(attribute.getValue()), attribute.getAttributeType(), attribute.getNamespace())));
            if (list3 == null) {
                ImmutableElement.$$$reportNull$$$0(5);
            }
            return list3;
        }
        return new ImmutableSameTypeAttributeList(nameValues, type2, namespace);
    }

    @Override
    public int getContentSize() {
        return this.myContent.length;
    }

    @Override
    @NotNull
    public List<Content> getContent() {
        List<Content> list2 = Arrays.asList(this.myContent);
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public <T extends Content> List<T> getContent(@NotNull Filter<T> filter2) {
        if (filter2 == null) {
            ImmutableElement.$$$reportNull$$$0(7);
        }
        return ContainerUtil.filter(this.myContent, filter2::matches);
    }

    @Override
    public Content getContent(int index2) {
        return this.myContent[index2];
    }

    @Override
    public Iterator<Content> getDescendants() {
        throw ImmutableElement.immutableError(this);
    }

    public <T extends Content> Iterator<T> getDescendants(Filter<T> filter2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public List<Element> getChildren() {
        List<Element> list2 = this.getContent(new ElementFilter());
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Element> getChildren(String name2, Namespace ns) {
        List<Element> list2 = this.getContent(new ElementFilter(name2, ns));
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public Element getChild(String name2, Namespace ns) {
        List<Element> children2 = this.getChildren(name2, ns);
        return children2.isEmpty() ? null : children2.get(0);
    }

    @Override
    public String getText() {
        if (this.myContent.length == 0) {
            return "";
        }
        if (this.myContent.length == 1) {
            Content obj = this.myContent[0];
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content content2 : this.myContent) {
            if (!(content2 instanceof Text)) continue;
            textContent.append(((Text)content2).getText());
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    @Override
    public int indexOf(Content child) {
        return ArrayUtil.indexOf(this.myContent, child);
    }

    @Override
    public Namespace getNamespace(String prefix) {
        Namespace ns = super.getNamespace(prefix);
        if (ns == null) {
            for (Attribute a : this.myAttributes) {
                if (!prefix.equals(a.getNamespacePrefix())) continue;
                return a.getNamespace();
            }
        }
        return ns;
    }

    @Override
    public boolean hasAttributes() {
        return !this.myAttributes.isEmpty();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.myAttributes;
    }

    public int getAttributesSize() {
        return this.myAttributes.size();
    }

    @Override
    public Attribute getAttribute(String name2, Namespace ns) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).get(name2, ns);
        }
        String uri = this.namespace.getURI();
        for (Attribute a : this.myAttributes) {
            String oldURI = a.getNamespaceURI();
            String oldName = a.getName();
            if (!oldURI.equals(uri) || !oldName.equals(name2)) continue;
            return a;
        }
        return null;
    }

    @Override
    @Nullable
    public String getAttributeValue(String attname) {
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE);
    }

    @Override
    public String getAttributeValue(String attname, String def) {
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE, def);
    }

    @Override
    public String getAttributeValue(String attname, Namespace ns) {
        return this.getAttributeValue(attname, ns, null);
    }

    @Override
    public String getAttributeValue(String name2, Namespace ns, String def) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).getValue(name2, ns, def);
        }
        Attribute attribute = this.getAttribute(name2, ns);
        return attribute == null ? def : attribute.getValue();
    }

    @Override
    public Element clone() {
        Element element2 = new Element();
        element2.content = new ContentList(element2);
        element2.attributes = new AttributeList(element2);
        element2.name = this.getName();
        element2.namespace = this.getNamespace();
        List<Attribute> attributes2 = this.getAttributes();
        if (attributes2 != null) {
            for (Attribute attribute : attributes2) {
                element2.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element2.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        List<Content> content2 = this.getContent();
        for (Content c : content2) {
            element2.content.add(c.clone());
        }
        return element2;
    }

    @Override
    public Element getParent() {
        throw ImmutableElement.immutableError(this);
    }

    public boolean attributesEqual(Element element2) {
        List<Attribute> attrs = element2.getAttributes();
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return this.myAttributes.equals(attrs);
        }
        if (this.myAttributes.size() != attrs.size()) {
            return false;
        }
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute oAttr;
            Attribute attribute = this.myAttributes.get(i);
            if (ImmutableElement.attributesEqual(attribute, oAttr = attrs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributesEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && Objects.equals(a1.getValue(), a2.getValue()) && a1.getAttributeType() == a2.getAttributeType() && a1.getNamespace().equals(a2.getNamespace());
    }

    @NotNull
    static IncorrectOperationException immutableError(Object element2) {
        return new IncorrectOperationException("Can't change immutable element: " + element2.getClass() + ". To obtain mutable Element call .clone()");
    }

    @Override
    public Element detach() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setName(String name2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setNamespace(Namespace namespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void removeNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setText(String text) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public List<Content> removeContent() {
        throw ImmutableElement.immutableError(this);
    }

    public <T extends Content> List<T> removeContent(Filter<T> filter2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setContent(int index2, Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Parent setContent(int index2, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(String str) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Element child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(int index2, Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(int index2, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Content removeContent(int index2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    public Element setAttributes(Collection newAttributes) {
        throw ImmutableElement.immutableError(this);
    }

    public Element setAttributes(List newAttributes) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull String name2, @NotNull String value2) {
        if (name2 == null) {
            ImmutableElement.$$$reportNull$$$0(10);
        }
        if (value2 == null) {
            ImmutableElement.$$$reportNull$$$0(11);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull String name2, @NotNull String value2, Namespace ns) {
        if (name2 == null) {
            ImmutableElement.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            ImmutableElement.$$$reportNull$$$0(13);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull Attribute attribute) {
        if (attribute == null) {
            ImmutableElement.$$$reportNull$$$0(14);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(String name2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(String name2, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(Attribute attribute) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChild(String name2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChild(String name2, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChildren(String name2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChildren(String name2, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    protected Content setParent(Parent parent2) {
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jdom/ImmutableElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jdom/ImmutableElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "internAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "internAttributes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

