/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import ksp.com.intellij.openapi.util.SystemInfoRt;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.com.intellij.util.ConcurrencyUtil;

final class DirectByteBufferAllocator {
    private static final ExecutorService ourAllocator = SystemInfoRt.isLinux && Boolean.parseBoolean(System.getProperty("idea.limit.paged.storage.allocators", "true")) ? ConcurrencyUtil.newSingleThreadExecutor("DirectBufferWrapper allocation thread") : null;

    DirectByteBufferAllocator() {
    }

    static ByteBuffer allocate(ThrowableComputable<? extends ByteBuffer, ? extends IOException> computable) throws IOException {
        if (ourAllocator != null) {
            try {
                return ourAllocator.submit(computable::compute).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                throw new RuntimeException(e);
            }
        }
        return computable.compute();
    }
}

