/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.RecursionManager;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.impl.InheritanceImplUtil;
import ksp.com.intellij.psi.impl.JavaClassSupersImpl;
import ksp.com.intellij.psi.impl.PsiClassImplUtil;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.search.PsiSearchScopeUtil;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiModificationTracker;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.PairProcessor;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.com.intellij.util.containers.ConcurrentFactoryMap;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.HashingStrategy;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

class ScopedClassHierarchy {
    private static final HashingStrategy<PsiClass> CLASS_HASHING_STRATEGY = new HashingStrategy<PsiClass>(){

        @Override
        public int hashCode(PsiClass object) {
            return object == null ? 0 : Strings.notNullize(object.getQualifiedName()).hashCode();
        }

        @Override
        public boolean equals(PsiClass o1, PsiClass o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            String qname1 = o1.getQualifiedName();
            if (qname1 != null) {
                return qname1.equals(o2.getQualifiedName());
            }
            return o1.getManager().areElementsEquivalent(o1, o2);
        }
    };
    private final PsiClass myPlaceClass;
    private final GlobalSearchScope myResolveScope;
    private volatile Map<PsiClass, PsiClassType.ClassResolveResult> mySupersWithSubstitutors;
    private volatile List<PsiClassType.ClassResolveResult> myImmediateSupersWithCapturing;
    private final Map<LanguageLevel, Map<PsiClass, PsiSubstitutor>> myAllSupersWithCapturing = ConcurrentFactoryMap.createMap(this::calcAllMemberSupers);

    ScopedClassHierarchy(PsiClass psiClass, GlobalSearchScope resolveScope2) {
        this.myPlaceClass = psiClass;
        this.myResolveScope = resolveScope2;
    }

    void visitType(@NotNull PsiClassType type2, Map<PsiClass, PsiClassType.ClassResolveResult> map) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (type2 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(0);
        }
        if ((psiClass = (resolveResult = type2.resolveGenerics()).getElement()) == null || InheritanceImplUtil.hasObjectQualifiedName(psiClass) || map.containsKey(psiClass)) {
            return;
        }
        map.put(psiClass, resolveResult);
        for (PsiType superType2 : ScopedClassHierarchy.getSuperTypes(psiClass)) {
            PsiType psiType2 = superType2 = type2.isRaw() && superType2 instanceof PsiClassType ? ((PsiClassType)superType2).rawType() : resolveResult.getSubstitutor().substitute(superType2);
            if (!((superType2 = PsiClassImplUtil.correctType(superType2, this.myResolveScope)) instanceof PsiClassType)) continue;
            this.visitType((PsiClassType)superType2, map);
        }
    }

    @NotNull
    private static List<PsiType> getSuperTypes(PsiClass psiClass) {
        ArrayList<PsiType> superTypes2 = new ArrayList<PsiType>();
        if (psiClass instanceof PsiAnonymousClass) {
            ContainerUtil.addIfNotNull(superTypes2, ((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        Collections.addAll(superTypes2, psiClass.getExtendsListTypes());
        Collections.addAll(superTypes2, psiClass.getImplementsListTypes());
        ArrayList<PsiType> arrayList = superTypes2;
        if (arrayList == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    static ScopedClassHierarchy getHierarchy(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope2) {
        if (psiClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(2);
        }
        if (resolveScope2 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(3);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return new ScopedClassHierarchy(psiClass, resolveScope2);
        }
        ScopedClassHierarchy scopedClassHierarchy = (ScopedClassHierarchy)((Map)CachedValuesManager.getCachedValue(psiClass, () -> {
            ConcurrentMap<GlobalSearchScope, ScopedClassHierarchy> result2 = ConcurrentFactoryMap.createMap(resolveScope1 -> new ScopedClassHierarchy(psiClass, (GlobalSearchScope)resolveScope1));
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.MODIFICATION_COUNT);
        })).get(resolveScope2);
        if (scopedClassHierarchy == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(4);
        }
        return scopedClassHierarchy;
    }

    @Nullable
    static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiClass superClass) {
        PsiClassType.ClassResolveResult resolveResult;
        if (derivedClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(6);
        }
        if (superClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(7);
        }
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(derivedClass, scope);
        Map<PsiClass, PsiClassType.ClassResolveResult> map = hierarchy.mySupersWithSubstitutors;
        if (map == null) {
            map = CollectionFactory.createCustomHashingStrategyMap(CLASS_HASHING_STRATEGY);
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            hierarchy.visitType(JavaPsiFacade.getElementFactory(derivedClass.getProject()).createType(derivedClass, PsiSubstitutor.EMPTY), map);
            if (stamp.mayCacheNow()) {
                hierarchy.mySupersWithSubstitutors = map;
            }
        }
        if ((resolveResult = map.get(superClass)) == null) {
            return null;
        }
        PsiClass cachedClass = Objects.requireNonNull(resolveResult.getElement());
        PsiSubstitutor cachedSubstitutor = resolveResult.getSubstitutor();
        return cachedClass == superClass ? cachedSubstitutor : ScopedClassHierarchy.mirrorSubstitutor(superClass, cachedClass, cachedSubstitutor);
    }

    @NotNull
    private static PsiSubstitutor mirrorSubstitutor(@NotNull PsiClass from2, @NotNull PsiClass to, @NotNull PsiSubstitutor substitutor2) {
        if (from2 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(8);
        }
        if (to == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(9);
        }
        if (substitutor2 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(10);
        }
        Iterator<PsiTypeParameter> baseParams = PsiUtil.typeParametersIterator(to);
        Iterator<PsiTypeParameter> candidateParams = PsiUtil.typeParametersIterator(from2);
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        while (baseParams.hasNext()) {
            if (!candidateParams.hasNext()) {
                PsiSubstitutor psiSubstitutor = JavaClassSupersImpl.createRawSubstitutor(to);
                if (psiSubstitutor == null) {
                    ScopedClassHierarchy.$$$reportNull$$$0(11);
                }
                return psiSubstitutor;
            }
            answer = answer.put(baseParams.next(), substitutor2.substitute(candidateParams.next()));
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(12);
        }
        return psiSubstitutor;
    }

    @NotNull
    List<PsiClassType.ClassResolveResult> getImmediateSupersWithCapturing() {
        List list2 = this.myImmediateSupersWithCapturing;
        if (list2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            list2 = RecursionManager.doPreventingRecursion(this, true, () -> this.calcImmediateSupersWithCapturing());
            if (list2 == null) {
                List<PsiClassType.ClassResolveResult> list3 = Collections.emptyList();
                if (list3 == null) {
                    ScopedClassHierarchy.$$$reportNull$$$0(13);
                }
                return list3;
            }
            if (stamp.mayCacheNow()) {
                this.myImmediateSupersWithCapturing = list2;
            }
        }
        List list4 = list2;
        if (list4 == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(14);
        }
        return list4;
    }

    @NotNull
    private List<PsiClassType.ClassResolveResult> calcImmediateSupersWithCapturing() {
        PsiClassType.ClassResolveResult objectResult;
        PsiUtilCore.ensureValid(this.myPlaceClass);
        ArrayList<PsiClassType.ClassResolveResult> list2 = new ArrayList<PsiClassType.ClassResolveResult>();
        for (PsiClassType type2 : this.myPlaceClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult result2;
            PsiClass superClass;
            PsiUtil.ensureValidType((PsiType)type2, this.myPlaceClass);
            PsiClassType corrected = PsiClassImplUtil.correctType(type2, this.myResolveScope);
            if (corrected == null || (superClass = (result2 = ((PsiClassType)PsiUtil.captureToplevelWildcards(corrected, this.myPlaceClass)).resolveGenerics()).getElement()) == null || !PsiSearchScopeUtil.isInScope(this.myResolveScope, (PsiElement)superClass)) continue;
            list2.add(result2);
        }
        if (list2.isEmpty() && this.myPlaceClass.getExtendsListTypes().length > 0 && (objectResult = PsiType.getJavaLangObject(this.myPlaceClass.getManager(), this.myResolveScope).resolveGenerics()).getElement() != null) {
            list2.add(objectResult);
        }
        ArrayList<PsiClassType.ClassResolveResult> arrayList = list2;
        if (arrayList == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private Map<PsiClass, PsiSubstitutor> calcAllMemberSupers(final LanguageLevel level) {
        final HashMap<PsiClass, PsiSubstitutor> map = new HashMap<PsiClass, PsiSubstitutor>();
        final PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.myPlaceClass.getProject());
        new PairProcessor<PsiClass, PsiSubstitutor>(){

            @Override
            public boolean process(PsiClass eachClass, PsiSubstitutor eachSubstitutor) {
                if (!map.containsKey(eachClass)) {
                    map.put(eachClass, eachSubstitutor);
                    PsiClassImplUtil.processSuperTypes(eachClass, eachSubstitutor, factory2, level, ScopedClassHierarchy.this.myResolveScope, this);
                }
                return true;
            }
        }.process(this.myPlaceClass, PsiSubstitutor.EMPTY);
        HashMap<PsiClass, PsiSubstitutor> hashMap = map;
        if (hashMap == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @Nullable
    PsiSubstitutor getSuperMembersSubstitutor(@NotNull PsiClass superClass, @NotNull LanguageLevel level) {
        if (superClass == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(17);
        }
        if (level == null) {
            ScopedClassHierarchy.$$$reportNull$$$0(18);
        }
        return this.myAllSupersWithCapturing.get((Object)level).get(superClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/ScopedClassHierarchy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/ScopedClassHierarchy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mirrorSubstitutor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateSupersWithCapturing";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImmediateSupersWithCapturing";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAllMemberSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitType";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mirrorSubstitutor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMembersSubstitutor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

