/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import javax.swing.Icon;
import ksp.com.intellij.codeInsight.TestFrameworks;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.icons.AllIcons;
import ksp.com.intellij.ide.IconLayerProvider;
import ksp.com.intellij.openapi.project.DumbService;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.psi.PsiModifierListOwner;
import ksp.com.intellij.psi.util.CachedValue;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.InheritanceUtil;
import ksp.com.intellij.psi.util.PsiClassUtil;
import ksp.com.intellij.psi.util.PsiMethodUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.ui.IconManager;
import ksp.com.intellij.ui.icons.RowIcon;
import ksp.com.intellij.util.BitUtil;
import ksp.com.intellij.util.PlatformIcons;
import ksp.com.intellij.util.VisibilityIcons;
import ksp.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import ksp.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class ElementPresentationUtil
implements PlatformIcons {
    private static final int CLASS_KIND_INTERFACE = 10;
    private static final int CLASS_KIND_ANNOTATION = 20;
    public static final int CLASS_KIND_CLASS = 30;
    private static final int CLASS_KIND_ANONYMOUS = 40;
    private static final int CLASS_KIND_ENUM = 50;
    private static final int CLASS_KIND_ASPECT = 60;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    private static final int CLASS_KIND_JUNIT_TEST = 90;
    private static final int CLASS_KIND_RUNNABLE = 100;
    private static final int CLASS_KIND_RECORD = 110;
    private static final int FLAGS_ABSTRACT = 256;
    private static final int FLAGS_STATIC = 512;
    private static final int FLAGS_FINAL = 1024;
    private static final int FLAGS_JUNIT_TEST = 8192;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND_KEY");
    private static final Int2ObjectMap<Icon> BASE_ICON = new Int2ObjectOpenHashMap<Icon>(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element2, boolean isLocked) {
        boolean isEnum = element2 instanceof PsiClass && ((PsiClass)element2).isEnum();
        int flags = (element2.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element2.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element2 instanceof PsiClass) {
            int kind;
            PsiClass aClass = (PsiClass)element2;
            if (element2.hasModifierProperty("abstract") && !((PsiClass)element2).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    public static int getBasicClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isRecord()) {
            return 110;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            aClass.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue<Integer> value2 = aClass.getUserData(CLASS_KIND_KEY);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager(aClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency(ElementPresentationUtil.getClassKindImpl(aClass), aClass), false);
            aClass.putUserData(CLASS_KIND_KEY, value2);
        }
        return value2.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isRecord()) {
            return 110;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance(aClass.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf(aClass, javaLangTrowable, true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass(aClass, false) && PsiMethodUtil.findMainMethod(aClass) != null) {
                return 100;
            }
        }
        return 30;
    }

    public static Icon getClassIconOfKind(PsiClass aClass, int classKind2) {
        boolean isAbstract2 = aClass.hasModifierProperty("abstract");
        return (Icon)BASE_ICON.get(classKind2 | (isAbstract2 ? 256 : 0));
    }

    public static String getDescription(PsiModifierListOwner member2) {
        String noun;
        if (member2 instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member2);
        } else if (member2 instanceof PsiMethod) {
            noun = JavaPsiBundle.message("node.method.tooltip", new Object[0]);
        } else if (member2 instanceof PsiField) {
            noun = JavaPsiBundle.message("node.field.tooltip", new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member2);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass);
        switch (kind) {
            case 20: {
                noun = JavaPsiBundle.message("node.annotation.tooltip", new Object[0]);
                break;
            }
            case 40: {
                noun = JavaPsiBundle.message("node.anonymous.class.tooltip", new Object[0]);
                break;
            }
            case 50: {
                noun = JavaPsiBundle.message("node.enum.tooltip", new Object[0]);
                break;
            }
            case 110: {
                noun = JavaPsiBundle.message("node.record.tooltip", new Object[0]);
                break;
            }
            case 80: {
                noun = JavaPsiBundle.message("node.exception.tooltip", new Object[0]);
                break;
            }
            case 10: {
                noun = JavaPsiBundle.message("node.interface.tooltip", new Object[0]);
                break;
            }
            case 90: {
                noun = JavaPsiBundle.message("node.junit.test.tooltip", new Object[0]);
                break;
            }
            case 100: {
                noun = JavaPsiBundle.message("node.runnable.class.tooltip", new Object[0]);
                break;
            }
            default: {
                noun = JavaPsiBundle.message("node.class.tooltip", new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass) {
        int level;
        PsiModifierList list2;
        int flags = ElementPresentationUtil.getFlags(aClass, false);
        StringBuilder adj = new StringBuilder();
        for (IconLayerProvider provider2 : IconLayerProvider.EP_NAME.getExtensionList()) {
            if (provider2.getLayerIcon(aClass, false) == null) continue;
            adj.append(" ").append(provider2.getLayerDescription());
        }
        if (BitUtil.isSet(flags, 256)) {
            adj.append(" ").append(JavaPsiBundle.message("node.abstract.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 1024)) {
            adj.append(" ").append(JavaPsiBundle.message("node.final.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 512)) {
            adj.append(" ").append(JavaPsiBundle.message("node.static.flag.tooltip", new Object[0]));
        }
        if ((list2 = aClass.getModifierList()) != null && (level = PsiUtil.getAccessLevel(list2)) != 4) {
            adj.append(" ").append(Strings.capitalize(JavaPsiBundle.visibilityPresentation(PsiUtil.getAccessModifier(level))));
        }
        return adj.toString();
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element2, int flags, RowIcon baseIcon) {
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(element2.getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    static {
        BASE_ICON.put(30, IconManager.getInstance().tooltipOnlyIfComposite(CLASS_ICON));
        BASE_ICON.put(286, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(20, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(276, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(40, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(296, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(60, ASPECT_ICON);
        BASE_ICON.put(316, ASPECT_ICON);
        BASE_ICON.put(50, ENUM_ICON);
        BASE_ICON.put(306, ENUM_ICON);
        BASE_ICON.put(80, EXCEPTION_CLASS_ICON);
        BASE_ICON.put(336, AllIcons.Nodes.AbstractException);
        BASE_ICON.put(10, IconManager.getInstance().tooltipOnlyIfComposite(INTERFACE_ICON));
        BASE_ICON.put(266, IconManager.getInstance().tooltipOnlyIfComposite(INTERFACE_ICON));
        BASE_ICON.put(90, IconManager.getInstance().tooltipOnlyIfComposite(CLASS_ICON));
        BASE_ICON.put(346, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(110, RECORD_ICON);
        BASE_ICON.put(100, CLASS_ICON);
        IconManager iconManager = IconManager.getInstance();
        iconManager.registerIconLayer(512, AllIcons.Nodes.StaticMark);
        iconManager.registerIconLayer(1024, AllIcons.Nodes.FinalMark);
        iconManager.registerIconLayer(8192, AllIcons.Nodes.JunitTestMark);
        iconManager.registerIconLayer(16384, AllIcons.Nodes.RunnableMark);
    }
}

