/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.filters;

import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.util.ReflectionUtil;

public class ClassFilter
implements ElementFilter {
    private final Class myFilter;
    private final boolean myAcceptableFlag;

    public ClassFilter(Class filter2) {
        this(filter2, true);
    }

    public ClassFilter(Class filter2, boolean acceptableFlag) {
        this.myFilter = filter2;
        this.myAcceptableFlag = acceptableFlag;
    }

    @Override
    public boolean isClassAcceptable(Class hintClass) {
        return this.myAcceptableFlag == this.filterMatches(hintClass);
    }

    @Override
    public boolean isAcceptable(Object element2, PsiElement context2) {
        return element2 != null && this.myAcceptableFlag == this.filterMatches(element2.getClass());
    }

    private boolean filterMatches(Class hintClass) {
        return ReflectionUtil.isAssignable(this.myFilter, hintClass);
    }

    @Override
    public String toString() {
        return "class(" + this.myFilter.getName() + ")";
    }
}

