/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.diagnostic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.PathUtilRt;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class Attachment {
    private static final Logger LOG = Logger.getInstance(Attachment.class);
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final String myDisplayText;
    private final byte @Nullable [] myBytes;
    @Nullable
    private final Path myTemporaryFile;
    private boolean myIncluded;

    public Attachment(@NotNull @NonNls String name2, @NotNull Throwable throwable) {
        if (name2 == null) {
            Attachment.$$$reportNull$$$0(0);
        }
        if (throwable == null) {
            Attachment.$$$reportNull$$$0(1);
        }
        this(name2 + ".trace", ExceptionUtil.getThrowableText(throwable));
        this.myIncluded = true;
    }

    public Attachment(@NotNull @NonNls String path, @NotNull @NonNls String content2) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            Attachment.$$$reportNull$$$0(3);
        }
        this(path, content2, content2.getBytes(StandardCharsets.UTF_8), null);
    }

    public Attachment(@NotNull @NonNls String path, byte @NotNull [] bytes, @NotNull @NonNls String displayText) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(4);
        }
        if (displayText == null) {
            Attachment.$$$reportNull$$$0(5);
        }
        if (bytes == null) {
            Attachment.$$$reportNull$$$0(6);
        }
        this(path, displayText, bytes, null);
    }

    public Attachment(@NotNull @NonNls String path, @NotNull File temporaryFile, @NotNull @NonNls String displayText) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(7);
        }
        if (temporaryFile == null) {
            Attachment.$$$reportNull$$$0(8);
        }
        if (displayText == null) {
            Attachment.$$$reportNull$$$0(9);
        }
        this(path, displayText, null, temporaryFile);
    }

    private Attachment(String path, String displayText, byte @Nullable [] bytes, @Nullable File temporaryFile) {
        assert (bytes != null || temporaryFile != null);
        this.myPath = path;
        this.myDisplayText = displayText;
        this.myBytes = bytes;
        this.myTemporaryFile = temporaryFile == null ? null : temporaryFile.toPath();
    }

    @NotNull
    public String getDisplayText() {
        String string2 = this.myDisplayText;
        if (string2 == null) {
            Attachment.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String getPath() {
        String string2 = this.myPath;
        if (string2 == null) {
            Attachment.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string2 = PathUtilRt.getFileName(this.myPath);
        if (string2 == null) {
            Attachment.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    public String getEncodedBytes() {
        String string2 = Base64.getEncoder().encodeToString(this.getBytes());
        if (string2 == null) {
            Attachment.$$$reportNull$$$0(13);
        }
        return string2;
    }

    public byte @NotNull [] getBytes() {
        if (this.myBytes != null) {
            if (this.myBytes == null) {
                Attachment.$$$reportNull$$$0(14);
            }
            return this.myBytes;
        }
        if (this.myTemporaryFile != null) {
            byte[] byArray;
            try {
                byArray = Files.readAllBytes(this.myTemporaryFile);
            }
            catch (IOException e) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e);
            }
            if (byArray == null) {
                Attachment.$$$reportNull$$$0(15);
            }
            return byArray;
        }
        if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
            Attachment.$$$reportNull$$$0(16);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    public InputStream openContentStream() {
        if (this.myBytes != null) {
            return new ByteArrayInputStream(this.myBytes);
        }
        if (this.myTemporaryFile != null) {
            InputStream inputStream;
            try {
                inputStream = Files.newInputStream(this.myTemporaryFile, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e);
            }
            if (inputStream == null) {
                Attachment.$$$reportNull$$$0(17);
            }
            return inputStream;
        }
        return new ByteArrayInputStream(ArrayUtilRt.EMPTY_BYTE_ARRAY);
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/diagnostic/Attachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/diagnostic/Attachment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedBytes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "openContentStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

