/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.org.objectweb.asm.commons;

import java.util.List;
import ksp.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import ksp.org.jetbrains.org.objectweb.asm.Attribute;
import ksp.org.jetbrains.org.objectweb.asm.ClassVisitor;
import ksp.org.jetbrains.org.objectweb.asm.FieldVisitor;
import ksp.org.jetbrains.org.objectweb.asm.MethodVisitor;
import ksp.org.jetbrains.org.objectweb.asm.ModuleVisitor;
import ksp.org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import ksp.org.jetbrains.org.objectweb.asm.TypePath;
import ksp.org.jetbrains.org.objectweb.asm.commons.AnnotationRemapper;
import ksp.org.jetbrains.org.objectweb.asm.commons.FieldRemapper;
import ksp.org.jetbrains.org.objectweb.asm.commons.MethodRemapper;
import ksp.org.jetbrains.org.objectweb.asm.commons.ModuleHashesAttribute;
import ksp.org.jetbrains.org.objectweb.asm.commons.ModuleRemapper;
import ksp.org.jetbrains.org.objectweb.asm.commons.RecordComponentRemapper;
import ksp.org.jetbrains.org.objectweb.asm.commons.Remapper;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor2, Remapper remapper2) {
        this(589824, classVisitor2, remapper2);
    }

    protected ClassRemapper(int api, ClassVisitor classVisitor2, Remapper remapper2) {
        super(api, classVisitor2);
        this.remapper = remapper2;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        this.className = name2;
        super.visit(version, access, this.remapper.mapType(name2), this.remapper.mapSignature(signature, false), this.remapper.mapType(superName), interfaces == null ? null : this.remapper.mapTypes(interfaces));
    }

    public ModuleVisitor visitModule(String name2, int flags, String version) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(name2), flags, version);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            List<String> modules = moduleHashesAttribute.modules;
            for (int i = 0; i < modules.size(); ++i) {
                modules.set(i, this.remapper.mapModuleName(modules.get(i)));
            }
        }
        super.visitAttribute(attribute);
    }

    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor, String signature) {
        RecordComponentVisitor recordComponentVisitor = super.visitRecordComponent(this.remapper.mapRecordComponentName(this.className, name2, descriptor), this.remapper.mapDesc(descriptor), this.remapper.mapSignature(signature, true));
        return recordComponentVisitor == null ? null : this.createRecordComponentRemapper(recordComponentVisitor);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        FieldVisitor fieldVisitor = super.visitField(access, this.remapper.mapFieldName(this.className, name2, descriptor), this.remapper.mapDesc(descriptor), this.remapper.mapSignature(signature, true), value2 == null ? null : this.remapper.mapValue(value2));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        String remappedDescriptor = this.remapper.mapMethodDesc(descriptor);
        MethodVisitor methodVisitor = super.visitMethod(access, this.remapper.mapMethodName(this.className, name2, descriptor), remappedDescriptor, this.remapper.mapSignature(signature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        super.visitInnerClass(this.remapper.mapType(name2), outerName == null ? null : this.remapper.mapType(outerName), innerName == null ? null : this.remapper.mapInnerClassName(name2, outerName, innerName), access);
    }

    public void visitOuterClass(String owner, String name2, String descriptor) {
        super.visitOuterClass(this.remapper.mapType(owner), name2 == null ? null : this.remapper.mapMethodName(owner, name2, descriptor), descriptor == null ? null : this.remapper.mapMethodDesc(descriptor));
    }

    public void visitNestHost(String nestHost) {
        super.visitNestHost(this.remapper.mapType(nestHost));
    }

    public void visitNestMember(String nestMember) {
        super.visitNestMember(this.remapper.mapType(nestMember));
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        super.visitPermittedSubclass(this.remapper.mapType(permittedSubclass));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }

    protected RecordComponentVisitor createRecordComponentRemapper(RecordComponentVisitor recordComponentVisitor) {
        return new RecordComponentRemapper(this.api, recordComponentVisitor, this.remapper);
    }
}

