/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.JvmAnalysisFlags;
import ksp.org.jetbrains.kotlin.config.JvmDefaultMode;
import ksp.org.jetbrains.kotlin.config.JvmTarget;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import ksp.org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.checkers.JvmDefaultCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J0\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001e\u001a\u00020\u0013*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lksp/org/jetbrains/kotlin/config/JvmTarget;", "project", "Lksp/com/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lcom/intellij/openapi/project/Project;)V", "ideService", "Lksp/org/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmCompatibilityAnnotations", "", "jvmDefaultMode", "Lksp/org/jetbrains/kotlin/config/JvmDefaultMode;", "checkSpecializationInCompatibilityMode", "inheritedFun", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "actualImplementation", "performSpecializationCheck", "checkPossibleClashMember", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "findPossibleClashMember", "isCompiledToJvmDefaultWithProperMode", "compilationDefaultMode", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmDefaultChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDefaultChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n535#2:211\n520#2,6:212\n216#3,2:218\n774#4:220\n865#4,2:221\n295#4,2:223\n1#5:225\n*S KotlinDebug\n*F\n+ 1 JvmDefaultChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker\n*L\n60#1:211\n60#1:212,6\n61#1:218,2\n186#1:220\n186#1:221,2\n188#1:223,2\n*E\n"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;
    @Nullable
    private final LanguageVersionSettingsProvider ideService;

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.jvmTarget = jvmTarget;
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        boolean performSpecializationCheck;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JvmDefaultMode jvmDefaultMode2 = context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        if (this.checkJvmCompatibilityAnnotations(descriptor, declaration2, context2, jvmDefaultMode2)) {
            return;
        }
        if (!jvmDefaultMode2.isEnabled() || !(descriptor instanceof ClassDescriptor) || DescriptorUtils.isInterface(descriptor) || DescriptorUtils.isAnnotationClass(descriptor)) {
            return;
        }
        boolean bl = performSpecializationCheck = jvmDefaultMode2 == JvmDefaultMode.ALL_COMPATIBILITY && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(descriptor) && (((ClassDescriptor)descriptor).getModality() == Modality.OPEN || ((ClassDescriptor)descriptor).getModality() == Modality.ABSTRACT) && !DescriptorUtilsKt.isEffectivelyPrivateApi((DeclarationDescriptorWithVisibility)descriptor);
        if (DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor) == null && !performSpecializationCheck) {
            return;
        }
        Map<CallableMemberDescriptor, CallableMemberDescriptor> map = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((ClassDescriptor)descriptor, true);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator3.next();
            boolean bl2 = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)entry.getValue();
            if (!this.isCompiledToJvmDefaultWithProperMode(actualImplementation, jvmDefaultMode2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            CallableMemberDescriptor inheritedMember = (CallableMemberDescriptor)entry.getKey();
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)entry.getValue();
            if (actualImplementation instanceof FunctionDescriptor && inheritedMember instanceof FunctionDescriptor) {
                if (!this.checkSpecializationInCompatibilityMode((FunctionDescriptor)inheritedMember, (FunctionDescriptor)actualImplementation, context2, declaration2, performSpecializationCheck)) continue;
                this.checkPossibleClashMember(inheritedMember, actualImplementation, jvmDefaultMode2, context2, declaration2);
                continue;
            }
            if (!(actualImplementation instanceof PropertyDescriptor) || !(inheritedMember instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getterImpl = ((PropertyDescriptor)actualImplementation).getGetter();
            PropertyGetterDescriptor getterInherited = ((PropertyDescriptor)inheritedMember).getGetter();
            if (getterImpl != null && getterInherited != null && jvmDefaultMode2 == JvmDefaultMode.ALL_COMPATIBILITY && !this.checkSpecializationInCompatibilityMode(getterInherited, getterImpl, context2, declaration2, performSpecializationCheck)) continue;
            if (((PropertyDescriptor)actualImplementation).isVar() && ((PropertyDescriptor)inheritedMember).isVar()) {
                PropertySetterDescriptor setterImpl = ((PropertyDescriptor)actualImplementation).getSetter();
                PropertySetterDescriptor setterInherited = ((PropertyDescriptor)inheritedMember).getSetter();
                if (setterImpl != null && setterInherited != null && !this.checkSpecializationInCompatibilityMode(setterInherited, setterImpl, context2, declaration2, performSpecializationCheck)) continue;
            }
            this.checkPossibleClashMember(inheritedMember, actualImplementation, jvmDefaultMode2, context2, declaration2);
        }
    }

    private final boolean checkJvmCompatibilityAnnotations(DeclarationDescriptor descriptor, KtDeclaration declaration2, DeclarationCheckerContext context2, JvmDefaultMode jvmDefaultMode2) {
        KtElement reportOn;
        AnnotationDescriptor annotationDescriptor;
        AnnotationDescriptor annotationDescriptor2 = descriptor.getAnnotations().findAnnotation(JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor2 != null) {
            annotationDescriptor = annotationDescriptor2;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
            if (!jvmDefaultMode2.isEnabled()) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)reportOn), "JvmDefaultWithoutCompatibility"));
                return true;
            }
        }
        AnnotationDescriptor annotationDescriptor3 = descriptor.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor3 != null) {
            annotationDescriptor = annotationDescriptor3;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration2;
            if (jvmDefaultMode2 != JvmDefaultMode.ALL) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_WITH_COMPATIBILITY_IN_DECLARATION.on((KtElement)((PsiElement)reportOn)));
                return true;
            }
            if (!DescriptorUtils.isInterface(descriptor)) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_WITH_COMPATIBILITY_NOT_ON_INTERFACE.on((KtElement)((PsiElement)reportOn)));
                return true;
            }
        }
        return false;
    }

    private final boolean checkSpecializationInCompatibilityMode(FunctionDescriptor inheritedFun, FunctionDescriptor actualImplementation, DeclarationCheckerContext context2, KtDeclaration declaration2, boolean performSpecializationCheck) {
        if (!performSpecializationCheck || actualImplementation instanceof JavaMethodDescriptor) {
            return true;
        }
        String inheritedSignature = MethodSignatureMappingKt.computeJvmDescriptor(inheritedFun, true, false);
        FunctionDescriptor functionDescriptor = actualImplementation.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getOriginal(...)");
        FunctionDescriptor originalImplementation = functionDescriptor;
        String actualSignature = MethodSignatureMappingKt.computeJvmDescriptor(originalImplementation, true, false);
        if (!Intrinsics.areEqual((Object)inheritedSignature, (Object)actualSignature)) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_COMPATIBILITY_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(originalImplementation)));
            return false;
        }
        return true;
    }

    private final void checkPossibleClashMember(CallableMemberDescriptor inheritedFun, CallableMemberDescriptor actualImplementation, JvmDefaultMode jvmDefaultMode2, DeclarationCheckerContext context2, KtDeclaration declaration2) {
        CallableMemberDescriptor clashMember = this.findPossibleClashMember(inheritedFun, jvmDefaultMode2);
        if (clashMember != null) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_MIXED_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(actualImplementation), DescriptorUtils.getDirectMember(clashMember), jvmDefaultMode2.getDescription()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final CallableMemberDescriptor findPossibleClashMember(CallableMemberDescriptor inheritedFun, JvmDefaultMode jvmDefaultMode) {
        block8: {
            block7: {
                v0 = inheritedFun.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getContainingDeclaration(...)");
                classDescriptor = v0;
                if (!(classDescriptor instanceof ClassDescriptor) || DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)classDescriptor) == null) {
                    return null;
                }
                v1 = inheritedFun.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"getOverriddenDescriptors(...)");
                $this$filter$iv = v1;
                $i$f$filter = false;
                var7_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CallableMemberDescriptor)element$iv$iv;
                    $i$a$-filter-JvmDefaultChecker$findPossibleClashMember$classMembers$1 = false;
                    if (!(DescriptorUtils.isInterface(it.getContainingDeclaration()) == false && DescriptorUtils.isAnnotationClass(it.getContainingDeclaration()) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                classMembers = (List)destination$iv$iv;
                $this$firstOrNull$iv = classMembers;
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    $i$a$-firstOrNull-JvmDefaultChecker$findPossibleClashMember$implicitDefaultImplsDelegate$1 = false;
                    if (it instanceof JavaCallableMemberDescriptor) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)it);
                    v2 = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation(it, true);
                    v3 = v2 != null ? !this.isCompiledToJvmDefaultWithProperMode(v2, jvmDefaultMode) : false;
                    if (v3) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (!v4) continue;
                    v5 = element$iv;
                    break block7;
                }
                v5 = null;
            }
            v6 = implicitDefaultImplsDelegate = (CallableMemberDescriptor)v5;
            if (v6 != null) {
                return v6;
            }
            for (CallableMemberDescriptor it : (Iterable)classMembers) {
                $i$a$-firstNotNullOfOrNull-JvmDefaultChecker$findPossibleClashMember$1 = false;
                Intrinsics.checkNotNull((Object)it);
                var8_10 = this.findPossibleClashMember(it, jvmDefaultMode);
                if (var8_10 == null) continue;
                v7 = var8_10;
                break block8;
            }
            v7 = null;
        }
        return v7;
    }

    private final boolean isCompiledToJvmDefaultWithProperMode(CallableMemberDescriptor $this$isCompiledToJvmDefaultWithProperMode, JvmDefaultMode compilationDefaultMode) {
        return JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode($this$isCompiledToJvmDefaultWithProperMode, this.ideService, compilationDefaultMode);
    }
}

