/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.resolve.OverridingUtil;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitution;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JavaOverrideWithWrongNullabilityOverrideChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "typePreparatorUnwrappingEnhancement", "Lksp/org/jetbrains/kotlin/types/checker/KotlinTypePreparator;", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JavaOverrideWithWrongNullabilityOverrideChecker
implements DeclarationChecker {
    @NotNull
    public static final JavaOverrideWithWrongNullabilityOverrideChecker INSTANCE = new JavaOverrideWithWrongNullabilityOverrideChecker();
    @NotNull
    private static final KotlinTypePreparator typePreparatorUnwrappingEnhancement = new KotlinTypePreparator(){

        public UnwrappedType prepareType(KotlinTypeMarker type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            UnwrappedType it = super.prepareType(type2);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    };

    private JavaOverrideWithWrongNullabilityOverrideChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        boolean hasOverrideNode;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor instanceof CallableMemberDescriptor)) {
            return;
        }
        if (((CallableMemberDescriptor)descriptor).getOverriddenDescriptors().isEmpty()) {
            return;
        }
        KtModifierList modifierList2 = declaration2.getModifierList();
        boolean bl = hasOverrideNode = modifierList2 != null && modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (!hasOverrideNode) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor).getOverriddenDescriptors()) {
            FunctionDescriptor unwrappedOverridden2;
            OverridingUtil overridingUtilWithEnhancementUnwrapped;
            if (!(callableMemberDescriptor instanceof JavaMethodDescriptor)) continue;
            Set relatedTypeParameters = new LinkedHashSet();
            Intrinsics.checkNotNullExpressionValue((Object)OverridingUtil.createWithTypePreparatorAndCustomSubtype(typePreparatorUnwrappingEnhancement, (Function2<KotlinType, KotlinType, Boolean>)((Function2)(arg_0, arg_1) -> JavaOverrideWithWrongNullabilityOverrideChecker.check$lambda$1(relatedTypeParameters, arg_0, arg_1))), (String)"createWithTypePreparatorAndCustomSubtype(...)");
            if (overridingUtilWithEnhancementUnwrapped.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor, containingClass, true).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor, containingClass, true).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
            FunctionDescriptor functionDescriptor = ((JavaMethodDescriptor)callableMemberDescriptor).substitute(TypeSubstitutor.create(new TypeSubstitution(){

                public TypeProjection get(KotlinType key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return null;
                }

                public KotlinType prepareTopLevelType(KotlinType topLevelType, Variance position) {
                    Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
                    Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
                    KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(topLevelType);
                    if (kotlinType == null) {
                        kotlinType = topLevelType;
                    }
                    return kotlinType;
                }
            }));
            if (functionDescriptor == null) {
                functionDescriptor = unwrappedOverridden2 = (FunctionDescriptor)callableMemberDescriptor;
            }
            if (!((Collection)relatedTypeParameters).isEmpty()) {
                context2.getTrace().report(ErrorsJvm.WRONG_TYPE_PARAMETER_NULLABILITY_FOR_JAVA_OVERRIDE.on((KtModifierListOwner)((PsiElement)declaration2), (TypeParameterDescriptor)CollectionsKt.first((Iterable)relatedTypeParameters)));
                break;
            }
            context2.getTrace().report(ErrorsJvm.WRONG_NULLABILITY_FOR_JAVA_OVERRIDE.on((KtModifierListOwner)((PsiElement)declaration2), (CallableMemberDescriptor)descriptor, unwrappedOverridden2));
            break;
        }
    }

    private static final Boolean check$lambda$1(Set $relatedTypeParameters, KotlinType subtype, KotlinType supertype) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$relatedTypeParameters, (String)"$relatedTypeParameters");
        Intrinsics.checkNotNull((Object)subtype);
        Intrinsics.checkNotNull((Object)supertype);
        boolean it = bl = JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter(subtype, supertype);
        boolean bl2 = false;
        if (it) {
            ClassifierDescriptor classifierDescriptor = subtype.getConstructor().getDeclarationDescriptor();
            ksp.org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull($relatedTypeParameters, classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
        }
        return !bl;
    }
}

