/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\b\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u00a8\u0006\u000f"}, d2={"shouldHideConstructorDueToValueClassTypeValueParameters", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "requiresFunctionNameManglingForParameterTypes", "requiresFunctionNameManglingForReturnType", "isValueClassThatRequiresMangling", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "requiresFunctionNameManglingInParameterTypes", "isDontMangleClass", "classDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "isTypeParameterWithUpperBoundThatRequiresMangling", "includeMfvc", "descriptors.jvm"})
@SourceDebugExtension(value={"SMAP\ninlineClassManglingRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineClassManglingRules.kt\norg/jetbrains/kotlin/resolve/jvm/InlineClassManglingRulesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1755#2,3:54\n1755#2,3:57\n1#3:60\n*S KotlinDebug\n*F\n+ 1 inlineClassManglingRules.kt\norg/jetbrains/kotlin/resolve/jvm/InlineClassManglingRulesKt\n*L\n21#1:54,3\n27#1:57,3\n*E\n"})
public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToValueClassTypeValueParameters(@NotNull CallableMemberDescriptor descriptor) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            ClassConstructorDescriptor classConstructorDescriptor = descriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor : null;
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
            if (DescriptorVisibilities.isPrivate(constructorDescriptor.getVisibility())) {
                return false;
            }
            ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
            if (InlineClassesUtilsKt.isValueClass(classDescriptor)) {
                return false;
            }
            if (DescriptorUtils.isSealedClass(constructorDescriptor.getConstructedClass())) {
                return false;
            }
            List<ValueParameterDescriptor> list = constructorDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    if (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean requiresFunctionNameManglingForParameterTypes(@NotNull CallableMemberDescriptor descriptor) {
        KotlinType kotlinType;
        KotlinType extensionReceiverType2;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
        KotlinType kotlinType2 = extensionReceiverType2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        if (extensionReceiverType2 != null) {
            if (InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(extensionReceiverType2)) return true;
        }
        List<ValueParameterDescriptor> list = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        } while (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType));
        return true;
    }

    public static final boolean requiresFunctionNameManglingForReturnType(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!(descriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
            return false;
        }
        KotlinType kotlinType = descriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType2 = kotlinType;
        return InlineClassesUtilsKt.isInlineClassType(returnType2) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(returnType2, false);
    }

    public static final boolean isValueClassThatRequiresMangling(@NotNull DeclarationDescriptor $this$isValueClassThatRequiresMangling) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassThatRequiresMangling, (String)"<this>");
        return InlineClassesUtilsKt.isValueClass($this$isValueClassThatRequiresMangling) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)$this$isValueClassThatRequiresMangling);
    }

    public static final boolean isValueClassThatRequiresMangling(@NotNull KotlinType $this$isValueClassThatRequiresMangling) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassThatRequiresMangling, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isValueClassThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor it = classifierDescriptor;
            boolean bl2 = false;
            bl = InlineClassesUtilsKt.isInlineClass(it) && InlineClassManglingRulesKt.isValueClassThatRequiresMangling(it) || InlineClassesUtilsKt.needsMfvcFlattening($this$isValueClassThatRequiresMangling);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType $this$requiresFunctionNameManglingInParameterTypes) {
        return InlineClassManglingRulesKt.isValueClassThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes, true);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)StandardNames.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType $this$isTypeParameterWithUpperBoundThatRequiresMangling, boolean includeMfvc) {
        ClassifierDescriptor classifierDescriptor = $this$isTypeParameterWithUpperBoundThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor descriptor = typeParameterDescriptor;
        return (includeMfvc || !InlineClassesUtilsKt.isMultiFieldValueClass(descriptor)) && InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound(descriptor));
    }
}

