/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import ksp.org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import ksp.org.jetbrains.kotlin.lexer.KtKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import ksp.org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import ksp.org.jetbrains.kotlin.resolve.AnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import ksp.org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import ksp.org.jetbrains.kotlin.resolve.OperatorModifierChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptionalExpectationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.PublishedApiUsageChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

public class ModifiersChecker {
    private final AnnotationChecker annotationChecker;
    private final Iterable<DeclarationChecker> declarationCheckers;
    private final LanguageVersionSettings languageVersionSettings;
    private final ExpectActualTracker expectActualTracker;
    private final DeprecationResolver deprecationResolver;
    private final ModuleDescriptor moduleDescriptor;
    private final MissingSupertypesResolver missingSupertypesResolver;

    @NotNull
    public static Modality resolveMemberModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            ModifiersChecker.$$$reportNull$$$0(1);
        }
        return ModifiersChecker.resolveModalityFromModifiers(modifierListOwner, defaultModality, bindingContext, containingDescriptor, false);
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor, boolean allowSealed) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(2);
        }
        if (bindingContext == null) {
            ModifiersChecker.$$$reportNull$$$0(3);
        }
        KtModifierList modifierList2 = modifierListOwner != null ? modifierListOwner.getModifierList() : null;
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(containingDescriptor, modifierList2, defaultModality, allowSealed);
        if (modifierListOwner != null) {
            List extensions = DeclarationAttributeAltererExtension.Companion.getInstances(modifierListOwner.getProject());
            DeclarationDescriptor descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, modifierListOwner);
            for (DeclarationAttributeAltererExtension extension : extensions) {
                Modality newModality = extension.refineDeclarationModality(modifierListOwner, descriptor, containingDescriptor, modality, false);
                if (newModality == null) continue;
                modality = newModality;
                break;
            }
        }
        Modality modality2 = modality;
        if (modality2 == null) {
            ModifiersChecker.$$$reportNull$$$0(4);
        }
        return modality2;
    }

    @NotNull
    private static Modality resolveModalityFromModifiers(@Nullable DeclarationDescriptor containingDescriptor, @Nullable KtModifierList modifierList2, @NotNull Modality defaultModality, boolean allowSealed) {
        if (defaultModality == null) {
            ModifiersChecker.$$$reportNull$$$0(5);
        }
        if (modifierList2 == null) {
            Modality modality = defaultModality;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(6);
            }
            return modality;
        }
        boolean hasAbstractModifier = modifierList2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (allowSealed && modifierList2.hasModifier(KtTokens.SEALED_KEYWORD)) {
            Modality modality = Modality.SEALED;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(7);
            }
            return modality;
        }
        if (modifierList2.hasModifier(KtTokens.OPEN_KEYWORD)) {
            ClassDescriptor classOrInterface;
            if (containingDescriptor instanceof ClassDescriptor && (classOrInterface = (ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE && classOrInterface.isExpect()) {
                Modality modality = Modality.OPEN;
                if (modality == null) {
                    ModifiersChecker.$$$reportNull$$$0(8);
                }
                return modality;
            }
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                Modality modality = Modality.ABSTRACT;
                if (modality == null) {
                    ModifiersChecker.$$$reportNull$$$0(9);
                }
                return modality;
            }
            Modality modality = Modality.OPEN;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(10);
            }
            return modality;
        }
        if (hasAbstractModifier) {
            Modality modality = Modality.ABSTRACT;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(11);
            }
            return modality;
        }
        boolean hasFinalModifier = modifierList2.hasModifier(KtTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(12);
            }
            return modality;
        }
        if (hasFinalModifier) {
            Modality modality = Modality.FINAL;
            if (modality == null) {
                ModifiersChecker.$$$reportNull$$$0(13);
            }
            return modality;
        }
        Modality modality = defaultModality;
        if (modality == null) {
            ModifiersChecker.$$$reportNull$$$0(14);
        }
        return modality;
    }

    @NotNull
    public static DescriptorVisibility resolveVisibilityFromModifiers(@NotNull KtModifierListOwner modifierListOwner, @NotNull DescriptorVisibility defaultVisibility) {
        if (modifierListOwner == null) {
            ModifiersChecker.$$$reportNull$$$0(15);
        }
        if (defaultVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(16);
        }
        DescriptorVisibility descriptorVisibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (descriptorVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(17);
        }
        return descriptorVisibility;
    }

    public static DescriptorVisibility resolveVisibilityFromModifiers(@Nullable KtModifierList modifierList2, @NotNull DescriptorVisibility defaultVisibility) {
        if (defaultVisibility == null) {
            ModifiersChecker.$$$reportNull$$$0(18);
        }
        if (modifierList2 == null) {
            return defaultVisibility;
        }
        if (modifierList2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return DescriptorVisibilities.PRIVATE;
        }
        if (modifierList2.hasModifier(KtTokens.PUBLIC_KEYWORD)) {
            return DescriptorVisibilities.PUBLIC;
        }
        if (modifierList2.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
            return DescriptorVisibilities.PROTECTED;
        }
        if (modifierList2.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            return DescriptorVisibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public ModifiersChecker(@NotNull AnnotationChecker annotationChecker, @NotNull Iterable<DeclarationChecker> declarationCheckers, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker, @NotNull DeprecationResolver deprecationResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        if (annotationChecker == null) {
            ModifiersChecker.$$$reportNull$$$0(19);
        }
        if (declarationCheckers == null) {
            ModifiersChecker.$$$reportNull$$$0(20);
        }
        if (languageVersionSettings == null) {
            ModifiersChecker.$$$reportNull$$$0(21);
        }
        if (expectActualTracker == null) {
            ModifiersChecker.$$$reportNull$$$0(22);
        }
        if (deprecationResolver == null) {
            ModifiersChecker.$$$reportNull$$$0(23);
        }
        if (moduleDescriptor == null) {
            ModifiersChecker.$$$reportNull$$$0(24);
        }
        if (missingSupertypesResolver == null) {
            ModifiersChecker.$$$reportNull$$$0(25);
        }
        this.annotationChecker = annotationChecker;
        this.declarationCheckers = declarationCheckers;
        this.languageVersionSettings = languageVersionSettings;
        this.expectActualTracker = expectActualTracker;
        this.deprecationResolver = deprecationResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.missingSupertypesResolver = missingSupertypesResolver;
    }

    @NotNull
    public ModifiersCheckingProcedure withTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            ModifiersChecker.$$$reportNull$$$0(26);
        }
        return new ModifiersCheckingProcedure(trace);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultModality";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/resolve/ModifiersChecker";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationCheckers";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectActualTracker";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingSupertypesResolver";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/ModifiersChecker";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModalityFromModifiers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVisibilityFromModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberModalityFromModifiers";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveModalityFromModifiers";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveVisibilityFromModifiers";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "withTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public class ModifiersCheckingProcedure {
        private final BindingTrace trace;

        private ModifiersCheckingProcedure(BindingTrace trace) {
            if (trace == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(0);
            }
            this.trace = trace;
        }

        public void checkParameterHasNoValOrVar(@NotNull KtValVarKeywordOwner parameter2, @NotNull DiagnosticFactory1<PsiElement, KtKeywordToken> diagnosticFactory) {
            PsiElement valOrVar;
            if (parameter2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(1);
            }
            if (diagnosticFactory == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(2);
            }
            if ((valOrVar = parameter2.getValOrVarKeyword()) != null) {
                this.trace.report(diagnosticFactory.on(valOrVar, (KtKeywordToken)valOrVar.getNode().getElementType()));
            }
        }

        public void checkModifiersForDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(4);
            }
            this.checkNestedClassAllowed(modifierListOwner, descriptor);
            this.checkTypeParametersModifiers(modifierListOwner);
            this.checkModifierListCommon(modifierListOwner, descriptor);
            this.checkIllegalHeader(modifierListOwner, descriptor);
        }

        private void checkNestedClassAllowed(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor) {
            if (declaration2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(6);
            }
            if (!(declaration2 instanceof KtClassOrObject)) {
                return;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)declaration2;
            if (!(descriptor instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
            DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
            DetailedClassKind kind = DetailedClassKind.getClassKind(classDescriptor);
            if (kind == DetailedClassKind.ANONYMOUS_OBJECT || kind == DetailedClassKind.ENUM_ENTRY) {
                return;
            }
            if ((kind == DetailedClassKind.ENUM_CLASS || kind == DetailedClassKind.OBJECT || kind == DetailedClassKind.COMPANION_OBJECT) && DescriptorUtils.isLocal(classDescriptor)) {
                return;
            }
            if (DescriptorUtils.isEnumEntry(containingClass) && !classDescriptor.isInner() && kind != DetailedClassKind.COMPANION_OBJECT) {
                DiagnosticFactory1<KtClassOrObject, String> diagnostic = ModifiersChecker.this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInEnumEntryShouldBeInner) ? Errors.NESTED_CLASS_NOT_ALLOWED : Errors.NESTED_CLASS_DEPRECATED;
                this.trace.report(diagnostic.on(ktClassOrObject, kind.withCapitalFirstLetter));
                return;
            }
            if (!classDescriptor.isInner() && (containingClass.isInner() || DescriptorUtils.isLocal(containingClass))) {
                this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(ktClassOrObject, kind.withCapitalFirstLetter));
            }
        }

        private void checkModifierListCommon(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(7);
            }
            if (descriptor == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(8);
            }
            AnnotationUseSiteTargetChecker.INSTANCE.check(modifierListOwner, descriptor, this.trace, ModifiersChecker.this.languageVersionSettings);
            this.runDeclarationCheckers(modifierListOwner, descriptor);
            ModifiersChecker.this.annotationChecker.check(modifierListOwner, this.trace, descriptor);
            ModifierCheckerCore.INSTANCE.check(modifierListOwner, this.trace, descriptor, ModifiersChecker.this.languageVersionSettings);
        }

        public void checkModifiersForLocalDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(9);
            }
            if (descriptor == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(10);
            }
            this.checkModifierListCommon(modifierListOwner, descriptor);
        }

        public void checkModifiersForDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration) {
            if (multiDeclaration == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(11);
            }
            ModifiersChecker.this.annotationChecker.check(multiDeclaration, this.trace, null);
            ModifierCheckerCore.INSTANCE.check(multiDeclaration, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            for (KtDestructuringDeclarationEntry multiEntry : multiDeclaration.getEntries()) {
                ModifiersChecker.this.annotationChecker.check(multiEntry, this.trace, null);
                ModifierCheckerCore.INSTANCE.check(multiEntry, this.trace, null, ModifiersChecker.this.languageVersionSettings);
                UnderscoreChecker.INSTANCE.checkNamed(multiEntry, this.trace, ModifiersChecker.this.languageVersionSettings, true);
            }
        }

        private void checkIllegalHeader(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
            KtModifierList modifierList2;
            PsiElement keyword;
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(12);
            }
            if (descriptor == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(13);
            }
            PsiElement psiElement = keyword = (modifierList2 = modifierListOwner.getModifierList()) != null ? modifierList2.getModifier(KtTokens.HEADER_KEYWORD) : null;
            if (keyword != null && descriptor instanceof ClassDescriptor && descriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.HEADER_KEYWORD, "nested class"));
            } else if (keyword == null && modifierList2 != null && (keyword = modifierList2.getModifier(KtTokens.EXPECT_KEYWORD)) != null && descriptor instanceof ClassDescriptor && descriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.EXPECT_KEYWORD, "nested class"));
            }
        }

        @NotNull
        public Map<KtModifierKeywordToken, PsiElement> getTokensCorrespondingToModifiers(@NotNull KtModifierList modifierList2, @NotNull Collection<KtModifierKeywordToken> possibleModifiers) {
            if (modifierList2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(14);
            }
            if (possibleModifiers == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(15);
            }
            HashMap<KtModifierKeywordToken, PsiElement> tokens = new HashMap<KtModifierKeywordToken, PsiElement>();
            for (KtModifierKeywordToken modifier : possibleModifiers) {
                if (!modifierList2.hasModifier(modifier)) continue;
                tokens.put(modifier, modifierList2.getModifier(modifier));
            }
            HashMap<KtModifierKeywordToken, PsiElement> hashMap = tokens;
            if (hashMap == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(16);
            }
            return hashMap;
        }

        public void runDeclarationCheckers(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor) {
            if (declaration2 == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(17);
            }
            if (descriptor == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(18);
            }
            DeclarationCheckerContext context2 = new DeclarationCheckerContext(this.trace, ModifiersChecker.this.languageVersionSettings, ModifiersChecker.this.deprecationResolver, ModifiersChecker.this.moduleDescriptor, ModifiersChecker.this.expectActualTracker, ModifiersChecker.this.missingSupertypesResolver);
            for (DeclarationChecker checker : ModifiersChecker.this.declarationCheckers) {
                ProgressManager.checkCanceled();
                checker.check(declaration2, descriptor, context2);
            }
            OperatorModifierChecker.INSTANCE.check(declaration2, descriptor, this.trace, ModifiersChecker.this.languageVersionSettings);
            PublishedApiUsageChecker.INSTANCE.check(declaration2, descriptor, this.trace);
            OptionalExpectationChecker.INSTANCE.check(declaration2, descriptor, this.trace);
        }

        public void checkTypeParametersModifiers(@NotNull KtModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                ModifiersCheckingProcedure.$$$reportNull$$$0(19);
            }
            if (!(modifierListOwner instanceof KtTypeParameterListOwner)) {
                return;
            }
            List<KtTypeParameter> typeParameters2 = ((KtTypeParameterListOwner)modifierListOwner).getTypeParameters();
            for (KtTypeParameter typeParameter : typeParameters2) {
                ModifierCheckerCore.INSTANCE.check(typeParameter, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 16: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnosticFactory";
                    break;
                }
                case 3: 
                case 7: 
                case 9: 
                case 12: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierListOwner";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "multiDeclaration";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierList";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "possibleModifiers";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokensCorrespondingToModifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkParameterHasNoValOrVar";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForDeclaration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "checkNestedClassAllowed";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifierListCommon";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForLocalDeclaration";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "checkModifiersForDestructuringDeclaration";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "checkIllegalHeader";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getTokensCorrespondingToModifiers";
                    break;
                }
                case 16: {
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "runDeclarationCheckers";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "checkTypeParametersModifiers";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 16: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum DetailedClassKind {
        ENUM_CLASS("Enum class"),
        ENUM_ENTRY("Enum entry"),
        ANNOTATION_CLASS("Annotation class"),
        INTERFACE("Interface"),
        COMPANION_OBJECT("Companion object"),
        ANONYMOUS_OBJECT("Anonymous object"),
        OBJECT("Object"),
        CLASS("Class");

        public final String withCapitalFirstLetter;

        private DetailedClassKind(String withCapitalFirstLetter) {
            this.withCapitalFirstLetter = withCapitalFirstLetter;
        }

        @NotNull
        public static DetailedClassKind getClassKind(@NotNull ClassDescriptor descriptor) {
            if (descriptor == null) {
                DetailedClassKind.$$$reportNull$$$0(0);
            }
            if (DescriptorUtils.isEnumEntry(descriptor)) {
                DetailedClassKind detailedClassKind = ENUM_ENTRY;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(1);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isEnumClass(descriptor)) {
                DetailedClassKind detailedClassKind = ENUM_CLASS;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(2);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isAnnotationClass(descriptor)) {
                DetailedClassKind detailedClassKind = ANNOTATION_CLASS;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(3);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isInterface(descriptor)) {
                DetailedClassKind detailedClassKind = INTERFACE;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(4);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isCompanionObject(descriptor)) {
                DetailedClassKind detailedClassKind = COMPANION_OBJECT;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(5);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isAnonymousObject(descriptor)) {
                DetailedClassKind detailedClassKind = ANONYMOUS_OBJECT;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(6);
                }
                return detailedClassKind;
            }
            if (DescriptorUtils.isObject(descriptor)) {
                DetailedClassKind detailedClassKind = OBJECT;
                if (detailedClassKind == null) {
                    DetailedClassKind.$$$reportNull$$$0(7);
                }
                return detailedClassKind;
            }
            DetailedClassKind detailedClassKind = CLASS;
            if (detailedClassKind == null) {
                DetailedClassKind.$$$reportNull$$$0(8);
            }
            return detailedClassKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/org/jetbrains/kotlin/resolve/ModifiersChecker$DetailedClassKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/ModifiersChecker$DetailedClassKind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassKind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

