/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi;

import java.util.List;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.NameUtils;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationContainer;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtScript
extends KtNamedDeclarationStub<KotlinScriptStub>
implements KtDeclarationContainer {
    public KtScript(@NotNull ASTNode node) {
        if (node == null) {
            KtScript.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtScript(@NotNull KotlinScriptStub stub) {
        if (stub == null) {
            KtScript.$$$reportNull$$$0(1);
        }
        super(stub, (IStubElementType)KtStubElementTypes.SCRIPT);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        KotlinScriptStub stub = (KotlinScriptStub)this.getStub();
        if (stub != null) {
            FqName fqName = stub.getFqName();
            if (fqName == null) {
                KtScript.$$$reportNull$$$0(2);
            }
            return fqName;
        }
        KtFile containingKtFile = this.getContainingKtFile();
        Name fileBasedName = NameUtils.getScriptNameForFile(containingKtFile.getName());
        FqName fqName = containingKtFile.getPackageFqName().child(fileBasedName);
        if (fqName == null) {
            KtScript.$$$reportNull$$$0(3);
        }
        return fqName;
    }

    @Override
    public String getName() {
        return this.getFqName().shortName().asString();
    }

    @NotNull
    public KtBlockExpression getBlockExpression() {
        KtBlockExpression ktBlockExpression = this.findNotNullChildByClass(KtBlockExpression.class);
        if (ktBlockExpression == null) {
            KtScript.$$$reportNull$$$0(4);
        }
        return ktBlockExpression;
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        List<KtDeclaration> list = PsiTreeUtil.getChildrenOfTypeAsList(this.getBlockExpression(), KtDeclaration.class);
        if (list == null) {
            KtScript.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtScript.$$$reportNull$$$0(6);
        }
        return visitor2.visitScript(this, data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/psi/KtScript";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/psi/KtScript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

