/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.js.PredefinedAnnotation;
import ksp.org.jetbrains.kotlin.js.resolve.AbstractNativeIndexerChecker;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/NativeSetterChecker;", "Lksp/org/jetbrains/kotlin/js/resolve/AbstractNativeIndexerChecker;", "<init>", "()V", "additionalCheck", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "js.frontend"})
public final class NativeSetterChecker
extends AbstractNativeIndexerChecker {
    public NativeSetterChecker() {
        super(PredefinedAnnotation.NATIVE_SETTER, "setter", 2);
    }

    @Override
    public void additionalCheck(@NotNull KtNamedFunction declaration2, @NotNull FunctionDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        super.additionalCheck(declaration2, descriptor, diagnosticHolder);
        KotlinType returnType2 = descriptor.getReturnType();
        if (returnType2 == null || KotlinBuiltIns.isUnit(returnType2)) {
            return;
        }
        List<ValueParameterDescriptor> list = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> parameters2 = list;
        if (parameters2.size() < 2) {
            return;
        }
        KotlinType kotlinType = parameters2.get(1).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType secondParameterType = kotlinType;
        if (TypeUtilsKt.isSubtypeOf(secondParameterType, returnType2)) {
            return;
        }
        diagnosticHolder.report(ErrorsJs.NATIVE_SETTER_WRONG_RETURN_TYPE.on((KtDeclaration)((PsiElement)declaration2)));
    }
}

