/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.inline.util.rewriters;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.js.backend.ast.HasName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsContext;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsFunction;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsLabel;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNode;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsParameter;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVars;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00112\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/js/inline/util/rewriters/NameReplacingVisitor;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "replaceMap", "", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsName;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "<init>", "(Ljava/util/Map;)V", "endVisit", "", "x", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsNameRef;", "ctx", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsContext;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsNode;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsLabel;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsParameter;", "visit", "", "applyToNamedNode", "Lksp/org/jetbrains/kotlin/js/backend/ast/HasName;", "js.translator"})
public final class NameReplacingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final Map<JsName, JsExpression> replaceMap;

    public NameReplacingVisitor(@NotNull Map<JsName, ? extends JsExpression> replaceMap) {
        Intrinsics.checkNotNullParameter(replaceMap, (String)"replaceMap");
        this.replaceMap = replaceMap;
    }

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (x.getQualifier() != null) {
            return;
        }
        JsExpression jsExpression = this.replaceMap.get(x.getName());
        if (jsExpression == null) {
            return;
        }
        JsExpression replacement = jsExpression;
        if (replacement instanceof JsNameRef) {
            this.applyToNamedNode(x);
        } else {
            JsExpression jsExpression2 = replacement.deepCopy();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"deepCopy(...)");
            JsExpression replacementCopy = jsExpression2;
            if (x.getSource() != null) {
                replacementCopy.setSource(x.getSource());
            }
            ctx.replaceMe(this.accept((JsNode)replacementCopy));
        }
    }

    public void endVisit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public void endVisit(@NotNull JsParameter x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(x);
            if (coroutineMetadata == null) break block0;
            CoroutineMetadata coroutineMetadata2 = coroutineMetadata;
            boolean bl = false;
            JsNode jsNode = this.accept((JsNode)coroutineMetadata2.getBaseClassRef().deepCopy());
            Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"accept(...)");
            JsExpression jsExpression = (JsExpression)jsNode;
            JsNode jsNode2 = this.accept((JsNode)coroutineMetadata2.getSuspendObjectRef().deepCopy());
            Intrinsics.checkNotNullExpressionValue((Object)jsNode2, (String)"accept(...)");
            MetadataProperties.setCoroutineMetadata(x, CoroutineMetadata.copy$default(coroutineMetadata2, null, null, null, null, null, null, jsExpression, (JsExpression)jsNode2, false, false, null, 1855, null));
        }
        return super.visit(x, ctx);
    }

    private final void applyToNamedNode(HasName x) {
        JsExpression replacement;
        while ((replacement = this.replaceMap.get(x.getName())) instanceof HasName) {
            x.setName(((HasName)((Object)replacement)).getName());
        }
    }
}

