/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.UnnecessaryAttributesRemover;
import ksp.org.jetbrains.kotlin.fir.types.ConeAttribute;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001aC\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\n\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\r"}, d2={"approximateDeclarationType", "T", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "containingCallableVisibility", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "isLocal", "", "isInlineFunction", "stripEnhancedNullability", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/descriptors/Visibility;ZZZ)Ljava/lang/Object;", "substituteAlternativesInPublicType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolve"})
@SourceDebugExtension(value={"SMAP\nDeclarationApproximationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationApproximationUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/DeclarationApproximationUtilsKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n271#2:60\n1755#3,3:61\n*S KotlinDebug\n*F\n+ 1 DeclarationApproximationUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/DeclarationApproximationUtilsKt\n*L\n38#1:60\n34#1:61,3\n*E\n"})
public final class DeclarationApproximationUtilsKt {
    public static final <T> T approximateDeclarationType(T $this$approximateDeclarationType, @NotNull FirSession session, @Nullable Visibility containingCallableVisibility, boolean isLocal, boolean isInlineFunction, boolean stripEnhancedNullability) {
        FirResolvedTypeRef firResolvedTypeRef;
        ConeKotlinType approximatedType;
        TypeApproximatorConfiguration.AllFlexibleSameValue allFlexibleSameValue;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!($this$approximateDeclarationType instanceof FirResolvedTypeRef)) {
            return $this$approximateDeclarationType;
        }
        ConeKotlinType baseType = ((FirResolvedTypeRef)$this$approximateDeclarationType).getType();
        boolean bl = isLocal;
        if (bl) {
            allFlexibleSameValue = TypeApproximatorConfiguration.LocalDeclaration.INSTANCE;
        } else if (!bl) {
            TypeApproximatorConfiguration.PublicDeclaration publicDeclaration;
            boolean bl2 = TypeUtilsKt.shouldApproximateAnonymousTypesOfNonLocalDeclaration(containingCallableVisibility, isInlineFunction);
            if (bl2) {
                publicDeclaration = TypeApproximatorConfiguration.PublicDeclaration.ApproximateAnonymousTypes.INSTANCE;
            } else if (!bl2) {
                publicDeclaration = TypeApproximatorConfiguration.PublicDeclaration.SaveAnonymousTypes.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            allFlexibleSameValue = publicDeclaration;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TypeApproximatorConfiguration.AllFlexibleSameValue configuration2 = allFlexibleSameValue;
        ConeKotlinType preparedType = isLocal ? baseType : DeclarationApproximationUtilsKt.substituteAlternativesInPublicType(baseType, session);
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(session).approximateToSuperType(preparedType, (TypeApproximatorConfiguration)configuration2);
        if (coneKotlinType == null) {
            coneKotlinType = preparedType;
        }
        if (ConeTypeUtilsKt.contains(approximatedType = coneKotlinType, (Function1<? super ConeKotlinType, Boolean>)((Function1)DeclarationApproximationUtilsKt::approximateDeclarationType$lambda$1))) {
            approximatedType = new UnnecessaryAttributesRemover(session).substituteOrSelf(approximatedType);
        }
        FirResolvedTypeRef $this$applyIf$iv = TypeUtilsKt.withReplacedConeType$default((FirTypeRef)$this$approximateDeclarationType, approximatedType, null, 2, null);
        boolean $i$f$applyIf = false;
        if (stripEnhancedNullability) {
            FirResolvedTypeRef $this$approximateDeclarationType_u24lambda_u242 = $this$applyIf$iv;
            boolean bl3 = false;
            firResolvedTypeRef = TypeUtilsKt.withoutEnhancedNullability($this$approximateDeclarationType_u24lambda_u242);
        } else {
            firResolvedTypeRef = $this$applyIf$iv;
        }
        return (T)firResolvedTypeRef;
    }

    public static /* synthetic */ Object approximateDeclarationType$default(Object object, FirSession firSession, Visibility visibility, boolean bl, boolean bl2, boolean bl3, int n, Object object2) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        return DeclarationApproximationUtilsKt.approximateDeclarationType(object, firSession, visibility, bl, bl2, bl3);
    }

    private static final ConeKotlinType substituteAlternativesInPublicType(ConeKotlinType $this$substituteAlternativesInPublicType, FirSession session) {
        ConeInferenceContext coneInferenceContext = TypeComponentsKt.getTypeContext(session);
        AbstractConeSubstitutor substitutor2 = new AbstractConeSubstitutor(coneInferenceContext){

            public ConeKotlinType substituteType(ConeKotlinType type2) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                if (!(type2 instanceof ConeIntersectionType)) {
                    return null;
                }
                ConeKotlinType coneKotlinType = ((ConeIntersectionType)type2).getAlternativeType();
                if (coneKotlinType == null) {
                    return null;
                }
                ConeKotlinType alternativeType = coneKotlinType;
                return this.substituteOrSelf(alternativeType);
            }
        };
        return substitutor2.substituteOrSelf($this$substituteAlternativesInPublicType);
    }

    private static final boolean approximateDeclarationType$lambda$1(ConeKotlinType type2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Iterable $this$any$iv = type2.getAttributes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeAttribute it = (ConeAttribute)element$iv;
                    boolean bl2 = false;
                    if (!(!it.getKeepInInferredDeclarationType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

