/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeAttribute;
import ksp.org.jetbrains.kotlin.fir.types.ConeCapturedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import ksp.org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeNullability;
import ksp.org.jetbrains.kotlin.fir.types.ConeStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeStubType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JA\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\u0019\b\u0002\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00150\u0019\u00a2\u0006\u0002\b\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u001e\u001a\u00020\u0015*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020!*\u00020\"H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\"H\u0014J\f\u0010$\u001a\u00020\u0015*\u00020\u0017H\u0014J\f\u0010%\u001a\u00020\u0015*\u00020\u0017H\u0004J\f\u0010\u001e\u001a\u00020\u0015*\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020&H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u00060\bj\u0002`\u0007X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "", "attributeRenderer", "Lksp/org/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;", "<init>", "(Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;)V", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "getBuilder", "()Ljava/lang/StringBuilder;", "setBuilder", "(Ljava/lang/StringBuilder;)V", "Ljava/lang/StringBuilder;", "idRenderer", "Lksp/org/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "getIdRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "setIdRenderer", "(Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;)V", "renderAsPossibleFunctionType", "", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "functionClassKindExtractor", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "renderType", "Lksp/org/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lkotlin/ExtensionFunctionType;", "render", "Lksp/org/jetbrains/kotlin/fir/types/ConeClassLikeType;", "renderForSameLookupTags", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeFlexibleType;", "flexibleType", "renderAttributes", "renderNonCompilerAttributes", "Lksp/org/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeRenderer.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,224:1\n774#2:225\n865#2,2:226\n188#3:228\n*S KotlinDebug\n*F\n+ 1 ConeTypeRenderer.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer\n*L\n181#1:225\n181#1:226,2\n182#1:228\n*E\n"})
public class ConeTypeRenderer {
    @NotNull
    private final ConeAttributeRenderer attributeRenderer;
    public StringBuilder builder;
    public ConeIdRenderer idRenderer;

    public ConeTypeRenderer(@NotNull ConeAttributeRenderer attributeRenderer) {
        Intrinsics.checkNotNullParameter((Object)attributeRenderer, (String)"attributeRenderer");
        this.attributeRenderer = attributeRenderer;
    }

    public /* synthetic */ ConeTypeRenderer(ConeAttributeRenderer coneAttributeRenderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coneAttributeRenderer = ConeAttributeRenderer.ToString.INSTANCE;
        }
        this(coneAttributeRenderer);
    }

    @NotNull
    public final StringBuilder getBuilder() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder != null) {
            return stringBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        return null;
    }

    public final void setBuilder(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
        this.builder = stringBuilder;
    }

    @NotNull
    public final ConeIdRenderer getIdRenderer() {
        ConeIdRenderer coneIdRenderer = this.idRenderer;
        if (coneIdRenderer != null) {
            return coneIdRenderer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"idRenderer");
        return null;
    }

    public final void setIdRenderer(@NotNull ConeIdRenderer coneIdRenderer) {
        Intrinsics.checkNotNullParameter((Object)coneIdRenderer, (String)"<set-?>");
        this.idRenderer = coneIdRenderer;
    }

    public void renderAsPossibleFunctionType(@NotNull ConeKotlinType type2, @NotNull Function1<? super ConeKotlinType, ? extends FunctionTypeKind> functionClassKindExtractor, @NotNull Function1<? super ConeTypeProjection, Unit> renderType) {
        FunctionTypeKind kind;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(functionClassKindExtractor, (String)"functionClassKindExtractor");
        Intrinsics.checkNotNullParameter(renderType, (String)"renderType");
        FunctionTypeKind functionTypeKind = kind = (FunctionTypeKind)functionClassKindExtractor.invoke((Object)type2);
        if (!(functionTypeKind != null ? !functionTypeKind.isReflectType() : false)) {
            renderType.invoke((Object)type2);
            return;
        }
        this.renderNonCompilerAttributes(type2);
        if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
            this.getBuilder().append("(");
        }
        String string2 = kind.getPrefixForTypeRender();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.getBuilder().append(it);
            this.getBuilder().append(" ");
        }
        Object[] typeArguments2 = type2.getTypeArguments();
        boolean isExtension = CompilerConeAttributesKt.isExtensionFunctionType(type2);
        Pair pair = isExtension && typeArguments2.length >= 2 && !Intrinsics.areEqual((Object)ArraysKt.first((Object[])typeArguments2), (Object)ConeStarProjection.INSTANCE) ? TuplesKt.to((Object)ArraysKt.first((Object[])typeArguments2), (Object)ArraysKt.drop((Object[])typeArguments2, (int)1)) : TuplesKt.to(null, (Object)ArraysKt.toList((Object[])typeArguments2));
        ConeTypeProjection receiver = (ConeTypeProjection)pair.component1();
        List otherTypeArguments = (List)pair.component2();
        List arguments2 = otherTypeArguments.subList(0, otherTypeArguments.size() - 1);
        ConeTypeProjection returnType2 = (ConeTypeProjection)CollectionsKt.last((List)otherTypeArguments);
        if (receiver != null) {
            this.render(receiver);
            this.getBuilder().append(".");
        }
        this.getBuilder().append("(");
        Iterator iterator2 = ((Iterable)arguments2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            ConeTypeProjection argument = (ConeTypeProjection)iterator2.next();
            if (index != 0) {
                this.getBuilder().append(", ");
            }
            this.render(argument);
        }
        this.getBuilder().append(") -> ");
        this.render(returnType2);
        if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
            this.getBuilder().append(")?");
        }
    }

    public static /* synthetic */ void renderAsPossibleFunctionType$default(ConeTypeRenderer coneTypeRenderer, ConeKotlinType coneKotlinType, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderAsPossibleFunctionType");
        }
        if ((n & 4) != 0) {
            function12 = arg_0 -> ConeTypeRenderer.renderAsPossibleFunctionType$lambda$0(coneTypeRenderer, arg_0);
        }
        coneTypeRenderer.renderAsPossibleFunctionType(coneKotlinType, (Function1<? super ConeKotlinType, ? extends FunctionTypeKind>)function1, (Function1<? super ConeTypeProjection, Unit>)function12);
    }

    public final void render(@NotNull ConeKotlinType type2) {
        StringBuilder stringBuilder;
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof ConeFlexibleType) && !(type2 instanceof ConeDefinitelyNotNullType)) {
            this.renderAttributes(type2);
        }
        if ((coneKotlinType = type2) instanceof ConeTypeVariableType) {
            this.getBuilder().append("TypeVariable(");
            this.getBuilder().append(((ConeTypeVariableType)type2).getTypeConstructor().getName());
            stringBuilder = this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.render(((ConeDefinitelyNotNullType)type2).getOriginal());
            stringBuilder = this.getBuilder().append(" & Any");
        } else if (coneKotlinType instanceof ConeErrorType) {
            stringBuilder = this.getBuilder().append("ERROR CLASS: " + ((ConeErrorType)type2).getDiagnostic().getReason());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            this.getBuilder().append("CapturedType(");
            this.render(((ConeCapturedType)type2).getConstructor().getProjection());
            stringBuilder = this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            this.render((ConeClassLikeType)type2);
            stringBuilder = Unit.INSTANCE;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            stringBuilder = this.getBuilder().append(((ConeLookupTagBasedType)type2).getLookupTag().getName().asString());
        } else if (coneKotlinType instanceof ConeDynamicType) {
            stringBuilder = this.getBuilder().append("dynamic");
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            this.render((ConeFlexibleType)type2);
            stringBuilder = Unit.INSTANCE;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.getBuilder().append("it(");
            Iterator iterator2 = ((Iterable)((ConeIntersectionType)type2).getIntersectedTypes()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                ConeKotlinType intersected = (ConeKotlinType)iterator2.next();
                if (index > 0) {
                    this.getBuilder().append(" & ");
                }
                this.render(intersected);
            }
            stringBuilder = this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeStubType) {
            stringBuilder = this.getBuilder().append("Stub (subtyping): " + ((ConeStubType)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            this.render((ConeIntegerLiteralType)type2);
            stringBuilder = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (!(type2 instanceof ConeFlexibleType) && !(type2 instanceof ConeErrorType)) {
            this.getBuilder().append(type2.getNullability().getSuffix());
        }
    }

    private final void render(ConeClassLikeType $this$render) {
        this.getIdRenderer().renderClassId($this$render.getLookupTag().getClassId());
        if ($this$render.getTypeArguments().length == 0) {
            return;
        }
        this.getBuilder().append("<");
        ConeTypeProjection[] coneTypeProjectionArray = $this$render.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (index > 0) {
                this.getBuilder().append(", ");
            }
            this.render(typeArgument);
        }
        this.getBuilder().append(">");
    }

    private final boolean renderForSameLookupTags(ConeFlexibleType $this$renderForSameLookupTags) {
        if ($this$renderForSameLookupTags.getLowerBound() instanceof ConeLookupTagBasedType && $this$renderForSameLookupTags.getUpperBound() instanceof ConeLookupTagBasedType && Intrinsics.areEqual((Object)((ConeLookupTagBasedType)$this$renderForSameLookupTags.getLowerBound()).getLookupTag(), (Object)((ConeLookupTagBasedType)$this$renderForSameLookupTags.getUpperBound()).getLookupTag()) && $this$renderForSameLookupTags.getLowerBound().getNullability() == ConeNullability.NOT_NULL && $this$renderForSameLookupTags.getUpperBound().getNullability() == ConeNullability.NULLABLE && (!($this$renderForSameLookupTags.getLowerBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getLowerBound().getTypeArguments().length == 0) && (!($this$renderForSameLookupTags.getUpperBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getUpperBound().getTypeArguments().length == 0)) {
            this.render($this$renderForSameLookupTags.getLowerBound());
            this.getBuilder().append("!");
            return true;
        }
        return false;
    }

    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        if (this.renderForSameLookupTags(flexibleType)) {
            return;
        }
        this.getBuilder().append("ft<");
        this.render(flexibleType.getLowerBound());
        this.getBuilder().append(", ");
        this.render(flexibleType.getUpperBound());
        this.getBuilder().append(">");
    }

    protected void renderAttributes(@NotNull ConeKotlinType $this$renderAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAttributes, (String)"<this>");
        if (!CollectionsKt.any((Iterable)$this$renderAttributes.getAttributes())) {
            return;
        }
        this.getBuilder().append(this.attributeRenderer.render($this$renderAttributes.getAttributes()));
    }

    /*
     * WARNING - void declaration
     */
    protected final void renderNonCompilerAttributes(@NotNull ConeKotlinType $this$renderNonCompilerAttributes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$renderNonCompilerAttributes, (String)"<this>");
        Map<KClass<ConeAttribute<?>>, ClassId> compilerAttributes = CompilerConeAttributes.INSTANCE.getClassIdByCompilerAttributeKey();
        Iterable $this$filter$iv = $this$renderNonCompilerAttributes.getAttributes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConeAttribute it = (ConeAttribute)element$iv$iv;
            boolean bl = false;
            if (!(!compilerAttributes.containsKey(it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$ifNotEmpty$iv = (List)destination$iv$iv;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$renderNonCompilerAttributes_u24lambda_u243 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            this.getBuilder().append(this.attributeRenderer.render($this$renderNonCompilerAttributes_u24lambda_u243));
        }
    }

    private final void render(ConeTypeProjection $this$render) {
        ConeTypeProjection coneTypeProjection = $this$render;
        if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            this.getBuilder().append("*");
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            this.getBuilder().append("CONFLICTING-PROJECTION ");
            this.render(((ConeKotlinTypeConflictingProjection)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            this.getBuilder().append("in ");
            this.render(((ConeKotlinTypeProjectionIn)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            this.getBuilder().append("out ");
            this.render(((ConeKotlinTypeProjectionOut)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            this.render((ConeKotlinType)$this$render);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    protected void render(@NotNull ConeIntegerLiteralType type2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeIntegerLiteralType coneIntegerLiteralType = type2;
        if (coneIntegerLiteralType instanceof ConeIntegerLiteralConstantType) {
            stringBuilder = this.getBuilder().append("ILT: " + ((ConeIntegerLiteralConstantType)type2).getValue());
        } else if (coneIntegerLiteralType instanceof ConeIntegerConstantOperatorType) {
            stringBuilder = this.getBuilder().append("IOT");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final Unit renderAsPossibleFunctionType$lambda$0(ConeTypeRenderer this$0, ConeTypeProjection coneTypeProjection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)coneTypeProjection, (String)"<this>");
        this$0.render(coneTypeProjection);
        return Unit.INSTANCE;
    }

    public ConeTypeRenderer() {
        this(null, 1, null);
    }
}

