/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantReturnUnitType;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class RedundantReturnUnitType
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final RedundantReturnUnitType INSTANCE = new RedundantReturnUnitType();

    private RedundantReturnUnitType() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2.getBody() instanceof FirSingleExpressionBlock) {
            return;
        }
        FirTypeRef returnType2 = declaration2.getReturnTypeRef();
        if (returnType2.getSource() == null) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!((Collection)returnType2.getAnnotations()).isEmpty()) {
            return;
        }
        if (ConeBuiltinTypeUtilsKt.isUnit(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(returnType2), context2.getSession()))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getREDUNDANT_RETURN_UNIT_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

