/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantExplicitTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isSame", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "other", "Lksp/org/jetbrains/kotlin/name/ClassId;", "hasSameNameWithoutModifiers", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "checkers"})
@SourceDebugExtension(value={"SMAP\nRedundantExplicitTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantExplicitTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantExplicitTypeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class RedundantExplicitTypeChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final RedundantExplicitTypeChecker INSTANCE = new RedundantExplicitTypeChecker();

    private RedundantExplicitTypeChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!declaration2.isLocal()) {
            return;
        }
        if (declaration2.getReturnTypeRef().getSource() == null) {
            return;
        }
        FirExpression firExpression = declaration2.getInitializer();
        if (firExpression == null) {
            return;
        }
        FirExpression initializer = firExpression;
        FirTypeRef it = firTypeRef = declaration2.getReturnTypeRef();
        boolean bl = false;
        if (it instanceof FirErrorTypeRef) return;
        FirTypeRef firTypeRef2 = firTypeRef;
        if (firTypeRef2 == null) {
            return;
        }
        FirTypeRef typeReference = firTypeRef2;
        KtSourceElement ktSourceElement = typeReference.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(typeReference);
        if (TypeUtilsKt.toSymbol(type2, context2.getSession()) instanceof FirTypeAliasSymbol) {
            return;
        }
        if (!((Collection)typeReference.getAnnotations()).isEmpty()) {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        FirExpression firExpression2 = initializer;
        if (firExpression2 instanceof FirLiteralExpression) {
            IElementType iElementType;
            KtSourceElement ktSourceElement2 = ((FirLiteralExpression)initializer).getSource();
            IElementType iElementType2 = iElementType = ktSourceElement2 != null ? ktSourceElement2.getElementType() : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getBoolean())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                if (Intrinsics.areEqual(((FirLiteralExpression)initializer).getKind(), (Object)ConstantValueKind.Long.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getLong()) : !this.isSame(type2, StandardClassIds.INSTANCE.getInt())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
                if (Intrinsics.areEqual(((FirLiteralExpression)initializer).getKind(), (Object)ConstantValueKind.Float.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getFloat()) : !this.isSame(type2, StandardClassIds.INSTANCE.getDouble())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getChar())) {
                    return;
                }
            } else {
                if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.STRING_TEMPLATE)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        } else if (firExpression2 instanceof FirFunctionCall) {
            if (!this.hasSameNameWithoutModifiers(type2, ((FirFunctionCall)initializer).getCalleeReference().getName())) {
                return;
            }
        } else {
            if (firExpression2 instanceof FirGetClassCall) {
                return;
            }
            if (firExpression2 instanceof FirResolvedQualifier) {
                if (!this.isSame(type2, ((FirResolvedQualifier)initializer).getClassId())) {
                    return;
                }
            } else {
                if (!(firExpression2 instanceof FirStringConcatenationCall)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean isSame(ConeKotlinType $this$isSame, ClassId other) {
        if ($this$isSame.getNullability().isNullable()) {
            return false;
        }
        return Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId($this$isSame.getType()), (Object)other);
    }

    private final boolean hasSameNameWithoutModifiers(ConeKotlinType $this$hasSameNameWithoutModifiers, Name name2) {
        return $this$hasSameNameWithoutModifiers instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)$this$hasSameNameWithoutModifiers).getLookupTag().getName(), (Object)name2) && $this$hasSameNameWithoutModifiers.getTypeArguments().length == 0 && !ConeTypeUtilsKt.isMarkedNullable($this$hasSameNameWithoutModifiers);
    }
}

