/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.lower.SingleAbstractMethodLowering;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import ksp.org.jetbrains.kotlin.utils.SmartList;

@PhaseDescription(name="SingleAbstractMethod", description="Replace SAM conversions with instances of interface-implementing classes", prerequisite={FunctionReferenceLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010 \u001a\u00020\u0007*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\u00020\u0007*\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmSingleAbstractMethodLowering;", "Lksp/org/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "isJavaSamConversionWithEqualsHashCode", "", "inInlineFunctionScope", "getInInlineFunctionScope", "()Z", "getWrapperVisibility", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "", "Lksp/org/jetbrains/kotlin/backend/common/ScopeWithIr;", "getSuperTypeForWrapper", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "typeOperand", "getWrappedFunctionType", "klass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "getSuspendFunctionWithoutContinuation", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "setConstructorSourceRange", "", "Lksp/org/jetbrains/kotlin/ir/builders/declarations/IrFunctionBuilder;", "createFor", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "isKotlinFunInterface", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "needEqualsHashCodeMethods", "getNeedEqualsHashCodeMethods", "postprocessCreatedObjectProxy", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmSingleAbstractMethodLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSingleAbstractMethodLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmSingleAbstractMethodLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1755#2,3:76\n32#3,2:79\n9#3,6:81\n1#4:87\n*S KotlinDebug\n*F\n+ 1 JvmSingleAbstractMethodLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmSingleAbstractMethodLowering\n*L\n39#1:76,3\n67#1:79,2\n67#1:81,6\n*E\n"})
public final class JvmSingleAbstractMethodLowering
extends SingleAbstractMethodLowering {
    private final boolean isJavaSamConversionWithEqualsHashCode;

    public JvmSingleAbstractMethodLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.isJavaSamConversionWithEqualsHashCode = context2.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
    }

    @Override
    public boolean getInInlineFunctionScope() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr it = (ScopeWithIr)element$iv;
                    boolean bl2 = false;
                    IrElement irElement = it.getIrElement();
                    IrDeclaration irDeclaration2 = irElement instanceof IrDeclaration ? (IrDeclaration)irElement : null;
                    boolean bl3 = irDeclaration2 != null ? JvmIrInlineUtilsKt.isInPublicInlineScope(irDeclaration2) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public DescriptorVisibility getWrapperVisibility(@NotNull IrTypeOperatorCall expression2, @NotNull List<? extends ScopeWithIr> scopes) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        DescriptorVisibility descriptorVisibility = this.getInInlineFunctionScope() ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNull((Object)descriptorVisibility);
        return descriptorVisibility;
    }

    @Override
    @NotNull
    public IrType getSuperTypeForWrapper(@NotNull IrType typeOperand) {
        Intrinsics.checkNotNullParameter((Object)typeOperand, (String)"typeOperand");
        IrClass irClass = JvmIrTypeUtilsKt.getErasedUpperBound(typeOperand);
        CommonBackendContext commonBackendContext = this.getContext();
        Intrinsics.checkNotNull((Object)commonBackendContext, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.JvmBackendContext");
        return JvmIrUtilsKt.rawType(irClass, (JvmBackendContext)commonBackendContext);
    }

    @Override
    @NotNull
    protected IrType getWrappedFunctionType(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        CommonBackendContext commonBackendContext = this.getContext();
        Intrinsics.checkNotNull((Object)commonBackendContext, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.JvmBackendContext");
        return JvmIrUtilsKt.rawType(klass, (JvmBackendContext)commonBackendContext);
    }

    @Override
    @NotNull
    protected IrSimpleFunction getSuspendFunctionWithoutContinuation(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return JvmIrUtilsKt.suspendFunctionOriginal(function2);
    }

    @Override
    protected void setConstructorSourceRange(@NotNull IrFunctionBuilder $this$setConstructorSourceRange, @NotNull IrElement createFor) {
        Intrinsics.checkNotNullParameter((Object)$this$setConstructorSourceRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)createFor, (String)"createFor");
        $this$setConstructorSourceRange.setStartOffset(-1);
        $this$setConstructorSourceRange.setEndOffset(-1);
    }

    private final boolean isKotlinFunInterface(IrType $this$isKotlinFunInterface) {
        IrClass irClass = IrTypesKt.getClass($this$isKotlinFunInterface);
        return !Intrinsics.areEqual((Object)(irClass != null ? irClass.getOrigin() : null), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB());
    }

    @Override
    public boolean getNeedEqualsHashCodeMethods(@NotNull IrType $this$needEqualsHashCodeMethods) {
        Intrinsics.checkNotNullParameter((Object)$this$needEqualsHashCodeMethods, (String)"<this>");
        return this.isKotlinFunInterface($this$needEqualsHashCodeMethods) || this.isJavaSamConversionWithEqualsHashCode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void postprocessCreatedObjectProxy(@NotNull IrClass klass) {
        List list;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Collection $this$filterIsInstanceAnd$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                IrProperty p0 = (IrProperty)element$iv$iv;
                boolean bl = false;
                if (!p0.isFakeOverride()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List fakeOverrideProperties = list;
        klass.getDeclarations().removeAll(fakeOverrideProperties);
        for (IrProperty property : fakeOverrideProperties) {
            IrDeclaration p0;
            IrSimpleFunction irSimpleFunction;
            if (property.getGetter() != null) {
                List<IrDeclaration> list2 = klass.getDeclarations();
                p0 = irSimpleFunction;
                boolean bl = false;
                list2.add(p0);
            }
            if (property.getSetter() == null) continue;
            List<IrDeclaration> list3 = klass.getDeclarations();
            p0 = irSimpleFunction;
            boolean bl = false;
            list3.add(p0);
        }
    }
}

