/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import ksp.org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstKind;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/intrinsics/IntIncr;", "Lksp/org/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "isPrefix", "", "<init>", "(Z)V", "invoke", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm.codegen"})
public final class IntIncr
extends IntrinsicMethod {
    private final boolean isPrefix;

    public IntIncr(boolean isPrefix) {
        this.isPrefix = isPrefix;
    }

    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression irExpression = expression2.getValueArgument(0);
        IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
        if (irGetValue == null) {
            throw new IllegalStateException(("IrGetValue expected as valueArgument #0: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)).toString());
        }
        IrGetValue irGetValue2 = irGetValue;
        IrExpression irExpression2 = expression2.getValueArgument(1);
        IrConst irConst = irExpression2 instanceof IrConst ? (IrConst)irExpression2 : null;
        if (irConst == null) {
            throw new IllegalStateException(("IrConst expected as valueArgument #1: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)).toString());
        }
        IrConst irDelta = irConst;
        if (!Intrinsics.areEqual(irDelta.getKind(), (Object)IrConstKind.Int.INSTANCE)) {
            throw new IllegalStateException(("Int const expected: " + DumpIrTreeKt.dump$default(irDelta, null, 1, null)).toString());
        }
        int delta = ((Number)IrConstKind.Int.INSTANCE.valueOf(irDelta)).intValue();
        if (delta > 127 || delta < -128) {
            throw new IllegalStateException(("Int const should be in (Byte.MIN_VALUE .. Byte.MAX_VALUE): " + DumpIrTreeKt.dump$default(irDelta, null, 1, null)).toString());
        }
        int varIndex = codegen2.getFrameMap().getIndex(irGetValue2.getSymbol());
        if (varIndex == -1) {
            throw new IllegalStateException(("Unmapped variable: " + RenderIrElementKt.render$default(irGetValue2, null, 1, null)).toString());
        }
        if (this.isPrefix) {
            codegen2.getMv().iinc(varIndex, delta);
            PromisedValueKt.materialize((PromisedValue)irGetValue2.accept(codegen2, data));
        } else {
            PromisedValueKt.materialize((PromisedValue)irGetValue2.accept(codegen2, data));
            codegen2.getMv().iinc(varIndex, delta);
        }
        Type type2 = Type.INT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"INT_TYPE");
        return new MaterialValue(codegen2, type2, irGetValue2.getType());
    }
}

