/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeys;
import ksp.org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import ksp.org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import ksp.org.jetbrains.kotlin.ir.util.IdSignature;
import ksp.org.jetbrains.kotlin.platform.JsPlatformKt;
import ksp.org.jetbrains.kotlin.platform.WasmPlatformKt;

@PhaseDescription(name="ConstEvaluationLowering", description="Evaluate functions that are marked as `IntrinsicConstEvaluation`")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/ConstEvaluationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "suppressErrors", "", "configuration", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;ZLorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "interpreter", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "evaluatedConstTracker", "Lksp/org/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lksp/org/jetbrains/kotlin/incremental/components/InlineConstTracker;", "mode", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyIntrinsicConst;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "ir.backend.common"})
public final class ConstEvaluationLowering
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    private final boolean suppressErrors;
    @NotNull
    private final IrInterpreter interpreter;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final EvaluationMode.OnlyIntrinsicConst mode;

    public ConstEvaluationLowering(@NotNull CommonBackendContext context2, boolean suppressErrors, @NotNull IrInterpreterConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.context = context2;
        this.suppressErrors = suppressErrors;
        this.interpreter = new IrInterpreter(new IrInterpreterEnvironment(this.context.getIrBuiltIns(), configuration2), (Map<IdSignature, ? extends IrBody>)MapsKt.emptyMap());
        this.evaluatedConstTracker = this.context.getConfiguration().get(CommonConfigurationKeys.EVALUATED_CONST_TRACKER);
        this.inlineConstTracker = this.context.getConfiguration().get(CommonConfigurationKeys.INLINE_CONST_TRACKER);
        this.mode = new EvaluationMode.OnlyIntrinsicConst(JsPlatformKt.isJs(configuration2.getPlatform()) || WasmPlatformKt.isWasm(configuration2.getPlatform()));
    }

    public /* synthetic */ ConstEvaluationLowering(CommonBackendContext commonBackendContext, boolean bl, IrInterpreterConfiguration irInterpreterConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = commonBackendContext.getConfiguration().getBoolean(CommonConfigurationKeys.IGNORE_CONST_OPTIMIZATION_ERRORS);
        }
        if ((n & 4) != 0) {
            irInterpreterConfiguration = new IrInterpreterConfiguration(null, 0, 0, false, true, false, 47, null);
        }
        this(commonBackendContext, bl, irInterpreterConfiguration);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrConstTransformerKt.runConstOptimizations(irFile, this.interpreter, this.mode, this.evaluatedConstTracker, this.inlineConstTracker, this.suppressErrors);
    }
}

