/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.BackendContext;
import ksp.org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import ksp.org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.MethodsFromAnyGeneratorForLowerings;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import ksp.org.jetbrains.kotlin.ir.builders.Scope;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000eH\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001d\u001a\u00020\u0015*\u00020\u000eH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eH\u0002J \u0010#\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0017H&J\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&*\u00020\u000eJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H&J\u001c\u0010,\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J&\u0010/\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001cJ8\u00106\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020<H\u0016J\u0016\u0010=\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0018\u0010>\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u00102\u001a\u000203X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006?"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lksp/org/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lksp/org/jetbrains/kotlin/backend/common/BackendContext;", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "implementations", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "getImplementations$ir_backend_common", "()Ljava/util/Map;", "visitClassNew", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "addConstructorBodyForCompatibility", "", "chooseConstructor", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitConstructorCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "platformSetup", "moveValueArgumentsUsingNames", "source", "destination", "createAnnotationImplementation", "annotationClass", "implementAnnotationPropertiesAndConstructor", "generatedConstructor", "getAnnotationProperties", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrProperty;", "getArrayContentEqualsSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "type", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "transformArrayEqualsArgument", "irBuilder", "Lksp/org/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "generatedEquals", "arg1", "arg2", "forbidDirectFieldAccessInMethods", "", "getForbidDirectFieldAccessInMethods", "()Z", "generateFunctionBodies", "eqFun", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hcFun", "toStringFun", "generator", "Lksp/org/jetbrains/kotlin/backend/common/lower/AnnotationImplementationMemberGenerator;", "implementGeneratedFunctions", "implementPlatformSpecificParts", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAnnotationImplementationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 9 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n*L\n1#1,308:1\n421#2,5:309\n72#3,2:314\n1#4:316\n1#4:392\n381#5,7:317\n1216#6,2:324\n1246#6,4:326\n1872#6,2:330\n1874#6:344\n808#6,11:363\n1611#6,9:382\n1863#6:391\n1864#6:393\n1620#6:394\n350#7,12:332\n50#8,4:345\n289#8:349\n283#8,13:350\n32#9,2:374\n9#9,6:376\n*S KotlinDebug\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer\n*L\n69#1:309,5\n69#1:314,2\n190#1:392\n87#1:317,7\n103#1:324,2\n103#1:326,4\n108#1:330,2\n108#1:344\n186#1:363,11\n190#1:382,9\n190#1:391\n190#1:393\n190#1:394\n122#1:332,12\n148#1:345,4\n166#1:349\n166#1:350,13\n189#1:374,2\n189#1:376,6\n*E\n"})
public abstract class AnnotationImplementationTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final BackendContext context;
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final Map<IrClass, IrClass> implementations;
    private final boolean forbidDirectFieldAccessInMethods;

    public AnnotationImplementationTransformer(@NotNull BackendContext context2, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.irFile = irFile;
        this.implementations = new LinkedHashMap();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final Map<IrClass, IrClass> getImplementations$ir_backend_common() {
        return this.implementations;
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.addConstructorBodyForCompatibility(declaration2);
        return super.visitClassNew(declaration2);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addConstructorBodyForCompatibility(@NotNull IrClass $this$addConstructorBodyForCompatibility) {
        void $this$addConstructorBodyForCompatibility_u24lambda_u240;
        void this_$iv$iv;
        void startOffset$iv;
        void $this$irBlockBody$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addConstructorBodyForCompatibility, (String)"<this>");
        if (!IrUtilsKt.isAnnotationClass($this$addConstructorBodyForCompatibility)) {
            return;
        }
        IrConstructor irConstructor = (IrConstructor)SequencesKt.singleOrNull(IrUtilsKt.getConstructors($this$addConstructorBodyForCompatibility));
        if (irConstructor == null) {
            return;
        }
        IrConstructor primaryConstructor2 = irConstructor;
        if (primaryConstructor2.getBody() != null) {
            return;
        }
        $this$addConstructorBodyForCompatibility.setModality(Modality.OPEN);
        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)$this$addConstructorBodyForCompatibility.getSymbol(), 0, 0, 6, null);
        int n = -2;
        int endOffset$iv = -2;
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_9 = this_$iv$iv;
        IrConstructor irConstructor2 = primaryConstructor2;
        boolean bl = false;
        $this$addConstructorBodyForCompatibility_u24lambda_u240.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addConstructorBodyForCompatibility_u24lambda_u240, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$addConstructorBodyForCompatibility_u24lambda_u240.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        $this$addConstructorBodyForCompatibility_u24lambda_u240.unaryPlus(BuildersKt.IrInstanceInitializerCallImpl($this$addConstructorBodyForCompatibility_u24lambda_u240.getStartOffset(), $this$addConstructorBodyForCompatibility_u24lambda_u240.getEndOffset(), $this$addConstructorBodyForCompatibility.getSymbol(), $this$addConstructorBodyForCompatibility_u24lambda_u240.getContext().getIrBuiltIns().getUnitType()));
        irConstructor2.setBody(this_$iv$iv.doBuild());
    }

    @NotNull
    public abstract IrConstructor chooseConstructor(@NotNull IrClass var1, @NotNull IrConstructorCall var2);

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Object object = IrTypesKt.getClassOrNull(expression2.getType());
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            return super.visitConstructorCall(expression2);
        }
        Object constructedClass = object;
        if (!IrUtilsKt.isAnnotationClass((IrClass)constructedClass)) {
            return super.visitConstructorCall(expression2);
        }
        if (!((IrConstructor)expression2.getSymbol().getOwner()).isPrimary()) {
            boolean $i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22 = false;
            String $i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22 = "Non-primary constructors of annotations are not supported";
            throw new IllegalArgumentException($i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22.toString());
        }
        Map<IrClass, IrClass> $this$getOrPut$iv = this.implementations;
        boolean $i$f$getOrPut = false;
        IrClass value$iv = $this$getOrPut$iv.get(constructedClass);
        if (value$iv == null) {
            boolean bl = false;
            IrClass answer$iv = this.createAnnotationImplementation((IrClass)constructedClass);
            $this$getOrPut$iv.put((IrClass)constructedClass, answer$iv);
            irClass = answer$iv;
        } else {
            irClass = value$iv;
        }
        IrClass implClass = irClass;
        IrConstructor ctor = this.chooseConstructor(implClass, expression2);
        IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(implClass), ctor.getSymbol(), null, 16, null);
        this.moveValueArgumentsUsingNames(expression2, newCall);
        this.transformChildrenVoid(newCall);
        return newCall;
    }

    public void platformSetup(@NotNull IrClass $this$platformSetup) {
        Intrinsics.checkNotNullParameter((Object)$this$platformSetup, (String)"<this>");
    }

    /*
     * WARNING - void declaration
     */
    private final void moveValueArgumentsUsingNames(IrConstructorCall source, IrConstructorCall destination) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = IrUtilsKt.getArgumentsWithIr(source);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IrExpression value2;
            Pair pair = (Pair)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            IrValueParameter param = (IrValueParameter)pair.component1();
            pair = (Pair)element$iv$iv;
            Name name2 = param.getName();
            boolean bl2 = false;
            IrExpression irExpression = value2 = (IrExpression)pair.component2();
            map.put(name2, irExpression);
        }
        Map argumentsByName = destination$iv$iv;
        Iterable $this$forEachIndexed$iv = ((IrConstructor)destination.getSymbol().getOwner()).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index = n;
            boolean bl = false;
            IrExpression valueArg = (IrExpression)argumentsByName.get(parameter2.getName());
            if (parameter2.getDefaultValue() == null && valueArg == null) {
                Object object;
                if (IrTypeUtilsKt.isBoxedArray(parameter2.getType()) || ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isPrimitiveArray(parameter2.getType()) || ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isUnsignedArray(parameter2.getType())) {
                    IrFunctionAccessExpression irFunctionAccessExpression;
                    IrType arrayType2 = parameter2.getType();
                    if (IrTypeUtilsKt.isBoxedArray(arrayType2)) {
                        IrSimpleFunctionSymbol arrayFunction = this.context.getIr().getSymbols().getArrayOfNulls();
                        irFunctionAccessExpression = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, source.getStartOffset(), source.getEndOffset(), arrayType2, arrayFunction, 0, 0, null, null, 240, null);
                    } else {
                        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(arrayType2);
                        Intrinsics.checkNotNull((Object)irClassSymbol);
                        Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(irClassSymbol);
                        boolean $i$f$single = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$single$iv) {
                            IrConstructorSymbol it = (IrConstructorSymbol)element$iv;
                            boolean bl3 = false;
                            if (!(((IrConstructor)it.getOwner()).getValueParameters().size() == 1 && Intrinsics.areEqual((Object)((IrValueParameter)CollectionsKt.single(((IrConstructor)it.getOwner()).getValueParameters())).getType(), (Object)this.context.getIrBuiltIns().getIntType()))) continue;
                            if (found$iv) {
                                throw new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        IrConstructorSymbol arrayConstructor = single$iv;
                        irFunctionAccessExpression = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, source.getStartOffset(), source.getEndOffset(), arrayType2, arrayConstructor, null, 16, null);
                    }
                    IrFunctionAccessExpression arrayConstructorCall = irFunctionAccessExpression;
                    arrayConstructorCall.putValueArgument(0, IrConstImpl.Companion.int(source.getStartOffset(), source.getEndOffset(), this.context.getIrBuiltIns().getIntType(), 0));
                    destination.putValueArgument(index, arrayConstructorCall);
                    return;
                }
                String string2 = "Usage of default value argument for this annotation is not yet possible.\nPlease specify value for '" + ((object = IrTypesKt.getClassOrNull(source.getType())) != null && (object = (IrClass)object.getOwner()) != null ? object.getName() : null) + '.' + parameter2.getName() + "' explicitly";
                throw new IllegalStateException(string2.toString());
            }
            destination.putValueArgument(index, valueArg);
        }
    }

    private final IrClass createAnnotationImplementation(IrClass annotationClass) {
        IrConstructor irConstructor;
        Object subclass;
        IrDeclarationParent irDeclarationParent;
        Object object = this.getCurrentClass();
        IrDeclarationParent irDeclarationParent2 = object != null && (object = ((ScopeWithIr)object).getScope()) != null ? ((Scope)object).getLocalDeclarationParent() : null;
        IrClass localDeclarationParent = irDeclarationParent2 instanceof IrClass ? (IrClass)irDeclarationParent2 : null;
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName);
        String string2 = fqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String parentFqName = StringsKt.replace$default((String)string2, (char)'.', (char)'_', (boolean)false, (int)4, null);
        Name name2 = Name.identifier("annotationImpl$" + parentFqName + "$0");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name wrapperName = name2;
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$createAnnotationImplementation_u24lambda_u247 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$createAnnotationImplementation_u24lambda_u247.setStartOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u247.setEndOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u247.setName(wrapperName);
        $this$createAnnotationImplementation_u24lambda_u247.setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        $this$createAnnotationImplementation_u24lambda_u247.setVisibility(DescriptorVisibilities.INTERNAL);
        Object $this$createAnnotationImplementation_u24lambda_u248 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrClass irClass = localDeclarationParent;
        if (irClass != null) {
            irDeclarationParent = irClass;
        } else {
            IrFile irFile = this.irFile;
            if (irFile != null) {
                irDeclarationParent = irFile;
            } else {
                throw new IllegalStateException("irFile in transformer should be specified when creating synthetic implementation".toString());
            }
        }
        ((IrDeclarationBase)$this$createAnnotationImplementation_u24lambda_u248).setParent(irDeclarationParent);
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$createAnnotationImplementation_u24lambda_u248);
        ((IrClass)$this$createAnnotationImplementation_u24lambda_u248).setSuperTypes(CollectionsKt.listOf((Object)IrUtilsKt.getDefaultType(annotationClass)));
        this.platformSetup((IrClass)$this$createAnnotationImplementation_u24lambda_u248);
        Object $this$addConstructor$iv = subclass = $this$buildClass$iv;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean bl4 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl5 = false;
        IrFunctionBuilder $this$createAnnotationImplementation_u24lambda_u249 = $this$addConstructor_u24lambda_u2425$iv;
        boolean bl6 = false;
        $this$createAnnotationImplementation_u24lambda_u249.setStartOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u249.setEndOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u249.setVisibility(DescriptorVisibilities.PUBLIC);
        $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrConstructor constructor$iv = irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl7 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrConstructor ctor = irConstructor;
        this.implementAnnotationPropertiesAndConstructor((IrClass)subclass, annotationClass, ctor);
        this.implementGeneratedFunctions(annotationClass, (IrClass)subclass);
        this.implementPlatformSpecificParts(annotationClass, (IrClass)subclass);
        return subclass;
    }

    public abstract void implementAnnotationPropertiesAndConstructor(@NotNull IrClass var1, @NotNull IrClass var2, @NotNull IrConstructor var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrProperty> getAnnotationProperties(@NotNull IrClass $this$getAnnotationProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceAndTo$iv$iv;
        List list;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationProperties, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$getAnnotationProperties.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List props = (List)destination$iv$iv;
        if (!((Collection)props).isEmpty()) {
            return props;
        }
        Collection $this$filterIsInstanceAnd$iv = $this$getAnnotationProperties.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstanceAnd$iv;
            destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceAndTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrProperty it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            IrPropertySymbol irPropertySymbol = it.getCorrespondingPropertySymbol();
            if ((irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public abstract IrFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType var1);

    @NotNull
    public IrExpression transformArrayEqualsArgument(@NotNull IrExpression $this$transformArrayEqualsArgument, @NotNull IrType type2, @NotNull IrBlockBodyBuilder irBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$transformArrayEqualsArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        return $this$transformArrayEqualsArgument;
    }

    @NotNull
    public final IrExpression generatedEquals(@NotNull IrBlockBodyBuilder irBuilder, @NotNull IrType type2, @NotNull IrExpression arg1, @NotNull IrExpression arg2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        if (IrTypePredicatesKt.isArray(type2) || ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isPrimitiveArray(type2) || ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isUnsignedArray(type2)) {
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunctionSymbol requiredSymbol = this.getArrayContentEqualsSymbol(type2);
            IrExpression lhs = this.transformArrayEqualsArgument(arg1, type2, irBuilder);
            IrExpression rhs = this.transformArrayEqualsArgument(arg2, type2, irBuilder);
            IrFunctionAccessExpression $this$generatedEquals_u24lambda_u2412 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)irBuilder, requiredSymbol);
            boolean bl = false;
            if (requiredSymbol.getOwner().getExtensionReceiverParameter() != null) {
                $this$generatedEquals_u24lambda_u2412.setExtensionReceiver(lhs);
                $this$generatedEquals_u24lambda_u2412.putValueArgument(0, rhs);
            } else {
                $this$generatedEquals_u24lambda_u2412.putValueArgument(0, lhs);
                $this$generatedEquals_u24lambda_u2412.putValueArgument(1, rhs);
            }
            irExpression = irFunctionAccessExpression;
        } else {
            irExpression = ExpressionHelpersKt.irEquals$default(irBuilder, arg1, arg2, null, 4, null);
        }
        return irExpression;
    }

    public boolean getForbidDirectFieldAccessInMethods() {
        return this.forbidDirectFieldAccessInMethods;
    }

    public void generateFunctionBodies(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull IrSimpleFunction eqFun, @NotNull IrSimpleFunction hcFun, @NotNull IrSimpleFunction toStringFun, @NotNull AnnotationImplementationMemberGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)eqFun, (String)"eqFun");
        Intrinsics.checkNotNullParameter((Object)hcFun, (String)"hcFun");
        Intrinsics.checkNotNullParameter((Object)toStringFun, (String)"toStringFun");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        List<IrProperty> properties = this.getAnnotationProperties(annotationClass);
        generator.generateEqualsUsingGetters(eqFun, IrUtilsKt.getDefaultType(annotationClass), properties);
        generator.generateHashCodeMethod(hcFun, properties);
        generator.generateToStringMethod(toStringFun, properties);
    }

    public final void implementGeneratedFunctions(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        MethodsFromAnyGeneratorForLowerings creator = new MethodsFromAnyGeneratorForLowerings(this.context, implClass, AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        IrSimpleFunction eqFun = creator.createEqualsMethodDeclaration();
        IrSimpleFunction hcFun = creator.createHashCodeMethodDeclaration();
        IrSimpleFunction toStringFun = creator.createToStringMethodDeclaration();
        if (!Intrinsics.areEqual((Object)annotationClass, (Object)implClass)) {
            IrUtilsKt.addFakeOverrides$default(implClass, this.context.getTypeSystem(), null, null, 6, null);
        }
        StringBuilder stringBuilder = new StringBuilder().append('@');
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName);
        AnnotationImplementationMemberGenerator generator = new AnnotationImplementationMemberGenerator(this.context, implClass, stringBuilder.append(fqName.asString()).toString(), this.getForbidDirectFieldAccessInMethods(), (Function4<? super IrBlockBodyBuilder, ? super IrType, ? super IrExpression, ? super IrExpression, ? extends IrExpression>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> AnnotationImplementationTransformer.implementGeneratedFunctions$lambda$13(this, arg_0, arg_1, arg_2, arg_3)));
        this.generateFunctionBodies(annotationClass, implClass, eqFun, hcFun, toStringFun, generator);
    }

    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
    }

    private static final IrExpression implementGeneratedFunctions$lambda$13(AnnotationImplementationTransformer this$0, IrBlockBodyBuilder $this$AnnotationImplementationMemberGenerator, IrType type2, IrExpression a, IrExpression b) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$AnnotationImplementationMemberGenerator, (String)"$this$AnnotationImplementationMemberGenerator");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this$0.generatedEquals($this$AnnotationImplementationMemberGenerator, type2, a, b);
    }
}

