/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import ksp.org.jetbrains.kotlin.analysis.api.components.KtCompileTimeConstantProvider;
import ksp.org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import ksp.org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import ksp.org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirCompileTimeConstantProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/components/KtCompileTimeConstantProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "evaluate", "Lksp/org/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "mode", "Lksp/org/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "evaluateAsAnnotationValue", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "evaluateFir", "fir", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "sourcePsi", "analysis-api-fir"})
public final class KtFirCompileTimeConstantProvider
extends KtCompileTimeConstantProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirCompileTimeConstantProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KtConstantValue evaluate(@NotNull KtExpression expression2, @NotNull KtConstantEvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir(expression2, this.getFirResolveSession()), expression2, mode);
    }

    @Override
    @Nullable
    public KtAnnotationValue evaluateAsAnnotationValue(@NotNull KtExpression expression2) {
        KtAnnotationValue ktAnnotationValue;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir(expression2, this.getFirResolveSession());
        FirExpression firExpression = firElement instanceof FirExpression ? (FirExpression)firElement : null;
        if (firExpression != null) {
            FirExpression it = firExpression;
            boolean bl = false;
            ktAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(it, this.getAnalysisSession().getFirSymbolBuilder$analysis_api_fir());
        } else {
            ktAnnotationValue = null;
        }
        return ktAnnotationValue;
    }

    private final KtConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi, KtConstantEvaluationMode mode) {
        KtConstantValue ktConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            KtConstantValue ktConstantValue2;
            try {
                ktConstantValue2 = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir, mode);
            }
            catch (ArithmeticException e) {
                String string2 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedMessage(...)");
                ktConstantValue2 = new KtConstantValue.KtErrorConstantValue(string2, sourcePsi);
            }
            ktConstantValue = ktConstantValue2;
        } else {
            ktConstantValue = null;
        }
        return ktConstantValue;
    }
}

