/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.BitSet;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import ksp.one.util.streamex.Internals;
import ksp.one.util.streamex.MergingCollector;

public interface DoubleCollector<A, R>
extends MergingCollector<Double, A, R> {
    public ObjDoubleConsumer<A> doubleAccumulator();

    @Override
    default public BiConsumer<A, Double> accumulator() {
        return this.doubleAccumulator()::accept;
    }

    default public <RR> DoubleCollector<A, RR> andThen(Function<R, RR> finisher) {
        return DoubleCollector.of(this.supplier(), this.doubleAccumulator(), this.merger(), this.finisher().andThen(finisher));
    }

    public static <R> DoubleCollector<R, R> of(Supplier<R> supplier, ObjDoubleConsumer<R> doubleAccumulator, BiConsumer<R, R> merger) {
        return new Internals.DoubleCollectorImpl(supplier, doubleAccumulator, merger, Function.identity(), Internals.ID_CHARACTERISTICS);
    }

    public static <A, R> DoubleCollector<?, R> of(Collector<Double, A, R> collector2) {
        if (collector2 instanceof DoubleCollector) {
            return (DoubleCollector)collector2;
        }
        return DoubleCollector.mappingToObj(Double::valueOf, collector2);
    }

    public static <A, R> DoubleCollector<A, R> of(Supplier<A> supplier, ObjDoubleConsumer<A> doubleAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher) {
        return new Internals.DoubleCollectorImpl<A, R>(supplier, doubleAccumulator, merger, finisher, Internals.NO_CHARACTERISTICS);
    }

    public static DoubleCollector<?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Internals.PartialCollector.joining(delimiter, prefix, suffix, true).asDouble(Internals.joinAccumulatorDouble(delimiter));
    }

    public static DoubleCollector<?, String> joining(CharSequence delimiter) {
        return Internals.PartialCollector.joining(delimiter, null, null, false).asDouble(Internals.joinAccumulatorDouble(delimiter));
    }

    public static DoubleCollector<?, Long> counting() {
        return Internals.PartialCollector.longSum().asDouble((box, i) -> {
            box[0] = box[0] + 1L;
        });
    }

    public static DoubleCollector<?, Integer> countingInt() {
        return Internals.PartialCollector.intSum().asDouble((box, i) -> {
            box[0] = box[0] + 1;
        });
    }

    public static DoubleCollector<?, Double> summing() {
        return DoubleCollector.summarizing().andThen(DoubleSummaryStatistics::getSum);
    }

    public static DoubleCollector<?, OptionalDouble> averaging() {
        return DoubleCollector.summarizing().andThen(dss -> dss.getCount() == 0L ? OptionalDouble.empty() : OptionalDouble.of(dss.getAverage()));
    }

    public static DoubleCollector<?, OptionalDouble> min() {
        return DoubleCollector.reducing(Double::min);
    }

    public static DoubleCollector<?, OptionalDouble> max() {
        return DoubleCollector.reducing(Double::max);
    }

    public static <A, R> DoubleCollector<?, R> mapping(DoubleUnaryOperator mapper, DoubleCollector<A, R> downstream) {
        ObjDoubleConsumer downstreamAccumulator = downstream.doubleAccumulator();
        return new Internals.DoubleCollectorImpl(downstream.supplier(), (r, t) -> downstreamAccumulator.accept(r, mapper.applyAsDouble(t)), downstream.merger(), downstream.finisher(), downstream.characteristics());
    }

    public static <U, A, R> DoubleCollector<?, R> mappingToObj(DoubleFunction<U> mapper, Collector<U, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        if (downstream instanceof MergingCollector) {
            return new Internals.DoubleCollectorImpl<Object, R>(downstream.supplier(), (acc, i) -> accumulator.accept(acc, mapper.apply(i)), ((MergingCollector)downstream).merger(), downstream.finisher(), downstream.characteristics());
        }
        return Internals.Box.partialCollector(downstream).asDouble((box, i) -> accumulator.accept(box.a, mapper.apply(i)));
    }

    public static DoubleCollector<?, OptionalDouble> reducing(DoubleBinaryOperator op) {
        return DoubleCollector.of(Internals.PrimitiveBox::new, (A box, double d) -> {
            if (!box.b) {
                box.b = true;
                box.d = d;
            } else {
                box.d = op.applyAsDouble(box.d, d);
            }
        }, (A box1, A box2) -> {
            if (box2.b) {
                if (!box1.b) {
                    box1.from((Internals.PrimitiveBox)box2);
                } else {
                    box1.d = op.applyAsDouble(box1.d, box2.d);
                }
            }
        }, Internals.PrimitiveBox::asDouble);
    }

    public static DoubleCollector<?, Double> reducing(double identity, DoubleBinaryOperator op) {
        return DoubleCollector.of(() -> new double[]{identity}, (A box, double i) -> {
            box[0] = op.applyAsDouble(box[0], i);
        }, (A box1, A box2) -> {
            box1[0] = op.applyAsDouble(box1[0], box2[0]);
        }, Internals.UNBOX_DOUBLE);
    }

    public static DoubleCollector<?, DoubleSummaryStatistics> summarizing() {
        return DoubleCollector.of(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    public static DoubleCollector<?, Map<Boolean, double[]>> partitioningBy(DoublePredicate predicate) {
        return DoubleCollector.partitioningBy(predicate, DoubleCollector.toArray());
    }

    public static <A, D> DoubleCollector<?, Map<Boolean, D>> partitioningBy(DoublePredicate predicate, DoubleCollector<A, D> downstream) {
        ObjDoubleConsumer downstreamAccumulator = downstream.doubleAccumulator();
        ObjDoubleConsumer<Internals.BooleanMap> accumulator = (result2, t) -> downstreamAccumulator.accept(predicate.test(t) ? result2.trueValue : result2.falseValue, t);
        return Internals.BooleanMap.partialCollector(downstream).asDouble(accumulator);
    }

    public static <K> DoubleCollector<?, Map<K, double[]>> groupingBy(DoubleFunction<? extends K> classifier) {
        return DoubleCollector.groupingBy(classifier, DoubleCollector.toArray());
    }

    public static <K, D, A> DoubleCollector<?, Map<K, D>> groupingBy(DoubleFunction<? extends K> classifier, DoubleCollector<A, D> downstream) {
        return DoubleCollector.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <K, D, A, M extends Map<K, D>> DoubleCollector<?, M> groupingBy(DoubleFunction<? extends K> classifier, Supplier<M> mapFactory, DoubleCollector<A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        Function<Object, Object> supplier = k -> downstreamSupplier.get();
        ObjDoubleConsumer downstreamAccumulator = downstream.doubleAccumulator();
        ObjDoubleConsumer<Map> accumulator = (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t));
            Object container = m.computeIfAbsent(key, supplier);
            downstreamAccumulator.accept(container, t);
        };
        return Internals.PartialCollector.grouping(mapFactory, downstream).asDouble(accumulator);
    }

    public static DoubleCollector<?, double[]> toArray() {
        return DoubleCollector.of(Internals.DoubleBuffer::new, Internals.DoubleBuffer::add, Internals.DoubleBuffer::addAll, Internals.DoubleBuffer::toArray);
    }

    public static DoubleCollector<?, float[]> toFloatArray() {
        return DoubleCollector.of(Internals.FloatBuffer::new, Internals.FloatBuffer::add, Internals.FloatBuffer::addAll, Internals.FloatBuffer::toArray);
    }

    public static DoubleCollector<?, boolean[]> toBooleanArray(DoublePredicate predicate) {
        return Internals.PartialCollector.booleanArray().asDouble((box, t) -> {
            if (predicate.test(t)) {
                ((BitSet)box.a).set(box.b);
            }
            box.b = StrictMath.addExact(box.b, 1);
        });
    }
}

