/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.ConcurrencyUtil;
import ksp.com.intellij.util.io.Accumulator;
import ksp.com.intellij.util.io.AppendablePersistentMap;
import ksp.com.intellij.util.io.CorruptionException;
import ksp.com.intellij.util.io.DataExternalizer;
import ksp.com.intellij.util.io.DataOutputStream;
import ksp.com.intellij.util.io.EnumeratorIntegerDescriptor;
import ksp.com.intellij.util.io.KeyDescriptor;
import ksp.com.intellij.util.io.PersistentEnumerator;
import ksp.com.intellij.util.io.PersistentHashMap;
import ksp.com.intellij.util.io.PersistentMap;
import ksp.com.intellij.util.io.PersistentMapWal;
import ksp.com.intellij.util.io.PersistentMapWalPlayer;
import ksp.com.intellij.util.io.UnsyncByteArrayOutputStream;
import ksp.com.intellij.util.io.WalEvent;
import ksp.com.intellij.util.io.WalRecord;
import ksp.com.intellij.util.io.WriteAheadLogKt;
import ksp.it.unimi.dsi.fastutil.Hash;
import ksp.it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import ksp.it.unimi.dsi.fastutil.ints.IntSet;
import ksp.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a)\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a]\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u0013\"\u0004\b\u0002\u0010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00172\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u001a0!H\u0002\u00a2\u0006\u0002\u0010\"\u001aB\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u00130$\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\u001a(\u0010%\u001a\b\u0012\u0004\u0012\u0002H'0&\"\u0004\b\u0000\u0010'2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\u001f\u001a0\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*\"\u0004\b\u0000\u0010'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\u001f\u001aJ\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u00130-\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\u001a:\u0010.\u001a\u0004\u0018\u00010\u001d\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u001a)\u0010/\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00132\u0006\u00100\u001a\u0002H\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u00a2\u0006\u0002\u00101\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"VERSION", "", "checksumGen", "Lkotlin/Function0;", "Ljava/util/zip/CRC32;", "debugWalRecords", "", "getDebugWalRecords", "()Z", "setDebugWalRecords", "(Z)V", "integerExternalizer", "Lksp/com/intellij/util/io/EnumeratorIntegerDescriptor;", "getIntegerExternalizer", "()Lcom/intellij/util/io/EnumeratorIntegerDescriptor;", "log", "Lksp/com/intellij/openapi/diagnostic/Logger;", "Lksp/org/jetbrains/annotations/NotNull;", "readData", "V", "array", "", "valueExternalizer", "Lksp/com/intellij/util/io/DataExternalizer;", "([BLcom/intellij/util/io/DataExternalizer;)Ljava/lang/Object;", "restoreFromWal", "R", "K", "walFile", "Ljava/nio/file/Path;", "keyDescriptor", "Lksp/com/intellij/util/io/KeyDescriptor;", "accumulator", "Lksp/com/intellij/util/io/Accumulator;", "(Ljava/nio/file/Path;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/Accumulator;)Ljava/lang/Object;", "restoreHashMapFromWal", "", "restoreMemoryEnumeratorFromWal", "", "Data", "dataDescriptor", "restorePersistentEnumeratorFromWal", "Lksp/com/intellij/util/io/PersistentEnumerator;", "outputMapFile", "restorePersistentMapFromWal", "Lksp/com/intellij/util/io/PersistentMap;", "tryCompact", "writeData", "value", "(Ljava/lang/Object;Lcom/intellij/util/io/DataExternalizer;)[B", "intellij.platform.util"})
public final class WriteAheadLogKt {
    private static final int VERSION = 0;
    private static final Function0<CRC32> checksumGen = checksumGen.1.INSTANCE;
    private static volatile boolean debugWalRecords;
    private static final Logger log;

    public static final boolean getDebugWalRecords() {
        return debugWalRecords;
    }

    public static final void setDebugWalRecords(boolean bl) {
        debugWalRecords = bl;
    }

    private static final EnumeratorIntegerDescriptor getIntegerExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorIntegerDescriptor, (String)"EnumeratorIntegerDescriptor.INSTANCE");
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public static final <Data> List<Data> restoreMemoryEnumeratorFromWal(@NotNull Path walFile, @NotNull KeyDescriptor<Data> dataDescriptor) throws IOException {
        Intrinsics.checkNotNullParameter((Object)walFile, (String)"walFile");
        Intrinsics.checkNotNullParameter(dataDescriptor, (String)"dataDescriptor");
        return CollectionsKt.toList((Iterable)((Iterable)WriteAheadLogKt.restoreFromWal(walFile, dataDescriptor, WriteAheadLogKt.getIntegerExternalizer(), new Accumulator<Data, Integer, List<? extends Data>>(){
            @NotNull
            private final ArrayList<Data> result;

            @NotNull
            public final ArrayList<Data> getResult() {
                return this.result;
            }

            @NotNull
            public Integer get(Data key) {
                String string2 = "get not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }

            @NotNull
            public Void remove(Data key) {
                String string2 = "remove not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }

            public void put(Data key, int value2) {
                boolean bl = this.result.size() == value2;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                this.result.add(key);
            }

            @NotNull
            public List<Data> result() {
                return this.result;
            }
            {
                boolean bl = false;
                this.result = new ArrayList<E>();
            }
        })));
    }

    @NotNull
    public static final <Data> PersistentEnumerator<Data> restorePersistentEnumeratorFromWal(@NotNull Path walFile, @NotNull Path outputMapFile, @NotNull KeyDescriptor<Data> dataDescriptor) throws IOException {
        Intrinsics.checkNotNullParameter((Object)walFile, (String)"walFile");
        Intrinsics.checkNotNullParameter((Object)outputMapFile, (String)"outputMapFile");
        Intrinsics.checkNotNullParameter(dataDescriptor, (String)"dataDescriptor");
        if (Files.exists(outputMapFile, new LinkOption[0])) {
            throw (Throwable)new FileAlreadyExistsException(((Object)outputMapFile).toString());
        }
        return (PersistentEnumerator)WriteAheadLogKt.restoreFromWal(walFile, dataDescriptor, WriteAheadLogKt.getIntegerExternalizer(), new Accumulator<Data, Integer, PersistentEnumerator<Data>>(outputMapFile, dataDescriptor){
            @NotNull
            private final PersistentEnumerator<Data> result;
            final /* synthetic */ Path $outputMapFile;
            final /* synthetic */ KeyDescriptor $dataDescriptor;

            @NotNull
            public final PersistentEnumerator<Data> getResult() {
                return this.result;
            }

            @NotNull
            public Integer get(Data key) {
                String string2 = "get not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }

            @NotNull
            public Void remove(Data key) {
                String string2 = "remove not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }

            public void put(Data key, int value2) {
                boolean bl = this.result.enumerate(key) == value2;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
            }

            @NotNull
            public PersistentEnumerator<Data> result() {
                return this.result;
            }
            {
                this.$outputMapFile = $captured_local_variable$0;
                this.$dataDescriptor = $captured_local_variable$1;
                this.result = new PersistentEnumerator<Data>($captured_local_variable$0, $captured_local_variable$1, 1024);
            }
        });
    }

    @NotNull
    public static final <K, V> PersistentMap<K, V> restorePersistentMapFromWal(@NotNull Path walFile, @NotNull Path outputMapFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)walFile, (String)"walFile");
        Intrinsics.checkNotNullParameter((Object)outputMapFile, (String)"outputMapFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        if (Files.exists(outputMapFile, new LinkOption[0])) {
            throw (Throwable)new FileAlreadyExistsException(((Object)outputMapFile).toString());
        }
        return (PersistentMap)WriteAheadLogKt.restoreFromWal(walFile, keyDescriptor, valueExternalizer, new Accumulator<K, V, PersistentMap<K, V>>(outputMapFile, keyDescriptor, valueExternalizer){
            @NotNull
            private final PersistentHashMap<K, V> result;
            final /* synthetic */ Path $outputMapFile;
            final /* synthetic */ KeyDescriptor $keyDescriptor;
            final /* synthetic */ DataExternalizer $valueExternalizer;

            @NotNull
            public final PersistentHashMap<K, V> getResult() {
                return this.result;
            }

            @Nullable
            public V get(K key) {
                return this.result.get(key);
            }

            public void remove(K key) {
                this.result.remove(key);
            }

            public void put(K key, V value2) {
                this.result.put(key, value2);
            }

            @NotNull
            public PersistentMap<K, V> result() {
                return this.result;
            }
            {
                this.$outputMapFile = $captured_local_variable$0;
                this.$keyDescriptor = $captured_local_variable$1;
                this.$valueExternalizer = $captured_local_variable$2;
                this.result = new PersistentHashMap<Key, Value>($captured_local_variable$0, $captured_local_variable$1, $captured_local_variable$2);
            }
        });
    }

    @NotNull
    public static final <K, V> Map<K, V> restoreHashMapFromWal(@NotNull Path walFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)walFile, (String)"walFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        return (Map)WriteAheadLogKt.restoreFromWal(walFile, keyDescriptor, valueExternalizer, new Accumulator<K, V, Map<K, ? extends V>>(){
            private final LinkedHashMap<K, V> map;

            @Nullable
            public V get(K key) {
                return this.map.get(key);
            }

            public void remove(K key) {
                this.map.remove(key);
            }

            public void put(K key, V value2) {
                this.map.put(key, value2);
            }

            @NotNull
            public Map<K, V> result() {
                return this.map;
            }
            {
                boolean bl = false;
                this.map = new LinkedHashMap<K, V>();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final <K, V> Path tryCompact(Path walFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) {
        boolean bl;
        int n;
        IntLinkedOpenHashSet intLinkedOpenHashSet;
        if (!Files.exists(walFile, new LinkOption[0])) {
            return null;
        }
        Object2ObjectOpenCustomHashMap keyToLastEvent2 = new Object2ObjectOpenCustomHashMap(new Hash.Strategy<K>(keyDescriptor){
            final /* synthetic */ KeyDescriptor $keyDescriptor;

            public boolean equals(@Nullable K a, @Nullable K b) {
                if (Intrinsics.areEqual(a, b)) {
                    return true;
                }
                if (a == null) {
                    return false;
                }
                if (b == null) {
                    return false;
                }
                return this.$keyDescriptor.isEqual(a, b);
            }

            public int hashCode(@Nullable K o) {
                return this.$keyDescriptor.getHashCode(o);
            }
            {
                this.$keyDescriptor = $captured_local_variable$0;
            }
        });
        Closeable closeable = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            PersistentMapWalPlayer it = (PersistentMapWalPlayer)closeable;
            boolean bl4 = false;
            int eventCount = 0;
            for (WalEvent walEvent : it.readWal()) {
                WalEvent walEvent2 = walEvent;
                if (walEvent2 instanceof WalEvent.AppendEvent) {
                    ((IntSet)keyToLastEvent2.computeIfAbsent(walEvent.getKey(), tryCompact.shouldCompact.1.1.INSTANCE)).add(eventCount);
                } else if (walEvent2 instanceof WalEvent.PutEvent) {
                    void set;
                    intLinkedOpenHashSet = new IntLinkedOpenHashSet();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    IntLinkedOpenHashSet intLinkedOpenHashSet2 = intLinkedOpenHashSet;
                    Object k = walEvent.getKey();
                    Object2ObjectOpenCustomHashMap object2ObjectOpenCustomHashMap = keyToLastEvent2;
                    boolean bl7 = false;
                    set.add(eventCount);
                    Unit unit = Unit.INSTANCE;
                    object2ObjectOpenCustomHashMap.put(k, intLinkedOpenHashSet);
                } else if (walEvent2 instanceof WalEvent.RemoveEvent) {
                    keyToLastEvent2.put(walEvent.getKey(), new IntLinkedOpenHashSet());
                } else if (walEvent2 instanceof WalEvent.CorruptionEvent) {
                    throw (Throwable)new CorruptionException("wal has been corrupted");
                }
                ((IntSet)keyToLastEvent2.computeIfAbsent(walEvent.getKey(), tryCompact.shouldCompact.1.3.INSTANCE)).add(eventCount);
                n = eventCount;
                eventCount = n + 1;
            }
            bl = keyToLastEvent2.size() * 2 < eventCount;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        boolean shouldCompact2 = bl;
        if (!shouldCompact2) {
            return null;
        }
        Path compactedWalFile = walFile.resolveSibling(walFile.getFileName() + "_compacted");
        Closeable closeable2 = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        boolean bl8 = false;
        bl = false;
        Throwable throwable3 = null;
        try {
            PersistentMapWalPlayer walPlayer = (PersistentMapWalPlayer)closeable2;
            boolean bl9 = false;
            boolean bl10 = walPlayer.getUseCompression$intellij_platform_util();
            Path path = compactedWalFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"compactedWalFile");
            ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"ConcurrencyUtil.newSameThreadExecutorService()");
            Closeable closeable3 = new PersistentMapWal(keyDescriptor, valueExternalizer, bl10, path, executorService, false, 32, null);
            boolean bl11 = false;
            n = 0;
            Throwable throwable4 = null;
            try {
                PersistentMapWal compactedWal = (PersistentMapWal)closeable3;
                boolean bl12 = false;
                Sequence $this$forEachIndexed$iv = walPlayer.readWal();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    IntSet events;
                    void walEvent;
                    int n2 = index$iv++;
                    boolean bl13 = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    WalEvent walEvent3 = (WalEvent)item$iv;
                    int index = n2;
                    boolean bl14 = false;
                    Object key = walEvent.getKey();
                    if ((IntSet)keyToLastEvent2.get(key) == null) {
                        throw (Throwable)new IOException("No events found for key =  " + key);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)events, (String)"keyToLastEvent.get(key) \u2026s found for key =  $key\")");
                    if (!events.contains(index)) continue;
                    void var28_48 = walEvent;
                    if (var28_48 instanceof WalEvent.AppendEvent) {
                        compactedWal.appendData(key, new AppendablePersistentMap.ValueDataAppender((WalEvent)walEvent){
                            final /* synthetic */ WalEvent $walEvent;

                            public final void append(@NotNull DataOutput out) {
                                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                                out.write(((WalEvent.AppendEvent)this.$walEvent).getData());
                            }
                            {
                                this.$walEvent = walEvent;
                            }
                        });
                        continue;
                    }
                    if (var28_48 instanceof WalEvent.PutEvent) {
                        compactedWal.put(key, ((WalEvent.PutEvent)walEvent).getValue());
                        continue;
                    }
                    if (var28_48 instanceof WalEvent.RemoveEvent || !(var28_48 instanceof WalEvent.CorruptionEvent)) continue;
                    throw (Throwable)new CorruptionException("wal has been corrupted");
                }
                intLinkedOpenHashSet = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable4 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable3 = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
        }
        return compactedWalFile;
    }

    private static final <V> V readData(byte[] array, DataExternalizer<V> valueExternalizer) {
        return valueExternalizer.read(new DataInputStream(new ByteArrayInputStream(array)));
    }

    private static final <V> byte[] writeData(V value2, DataExternalizer<V> valueExternalizer) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        valueExternalizer.save(new DataOutputStream(baos), value2);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <K, V, R> R restoreFromWal(Path walFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer, Accumulator<K, V, R> accumulator) {
        R r;
        Closeable closeable = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PersistentMapWalPlayer it = (PersistentMapWalPlayer)closeable;
            boolean bl3 = false;
            for (WalEvent walEvent : it.readWal()) {
                WalEvent walEvent2 = walEvent;
                if (walEvent2 instanceof WalEvent.AppendEvent) {
                    Object previous = accumulator.get(walEvent.getKey());
                    byte[] currentData = previous == null ? ((WalEvent.AppendEvent)walEvent).getData() : ArraysKt.plus((byte[])WriteAheadLogKt.writeData(previous, valueExternalizer), (byte[])((WalEvent.AppendEvent)walEvent).getData());
                    accumulator.put(walEvent.getKey(), WriteAheadLogKt.readData(currentData, valueExternalizer));
                    continue;
                }
                if (walEvent2 instanceof WalEvent.PutEvent) {
                    accumulator.put(walEvent.getKey(), ((WalEvent.PutEvent)walEvent).getValue());
                    continue;
                }
                if (walEvent2 instanceof WalEvent.RemoveEvent) {
                    accumulator.remove(walEvent.getKey());
                    continue;
                }
                if (!(walEvent2 instanceof WalEvent.CorruptionEvent)) continue;
                throw (Throwable)new CorruptionException("wal has been corrupted");
            }
            r = accumulator.result();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return r;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(WalRecord.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        log = logger2;
    }

    public static final /* synthetic */ EnumeratorIntegerDescriptor access$getIntegerExternalizer$p() {
        return WriteAheadLogKt.getIntegerExternalizer();
    }

    public static final /* synthetic */ byte[] access$writeData(Object value2, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.writeData(value2, valueExternalizer);
    }

    public static final /* synthetic */ Path access$tryCompact(Path walFile, KeyDescriptor keyDescriptor, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.tryCompact(walFile, keyDescriptor, valueExternalizer);
    }

    public static final /* synthetic */ Function0 access$getChecksumGen$p() {
        return checksumGen;
    }

    public static final /* synthetic */ Object access$readData(byte[] array, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.readData(array, valueExternalizer);
    }
}

