/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import ksp.org.jetbrains.annotations.NotNull;

public final class IntObjectHashMap<T> {
    private final ArrayProducer<T[]> arrayFactory;
    private int size;
    private int[] keys;
    private T[] values;
    private T specialZeroValue;
    private boolean hasZeroValue;

    public IntObjectHashMap(ArrayProducer<T[]> arrayFactory) {
        this.arrayFactory = arrayFactory;
        this.keys = new int[16];
        this.values = arrayFactory.produce(this.keys.length);
    }

    public IntObjectHashMap(IntObjectHashMap<T> original) {
        this.arrayFactory = original.arrayFactory;
        this.keys = (int[])original.keys.clone();
        this.values = (Object[])original.values.clone();
        this.size = original.size;
        this.specialZeroValue = original.specialZeroValue;
        this.hasZeroValue = original.hasZeroValue;
    }

    public int size() {
        return this.size + (this.hasZeroValue ? 1 : 0);
    }

    public void replaceByIndex(int index, int key, @NotNull T value2) {
        if (value2 == null) {
            IntObjectHashMap.$$$reportNull$$$0(0);
        }
        if (key == 0) {
            this.specialZeroValue = value2;
            this.hasZeroValue = true;
        } else {
            this.values[index] = value2;
        }
    }

    public void addByIndex(int index, int key, @NotNull T value2) {
        if (value2 == null) {
            IntObjectHashMap.$$$reportNull$$$0(1);
        }
        if (key == 0) {
            this.specialZeroValue = value2;
            this.hasZeroValue = true;
            return;
        }
        if (this.size >= 2 * this.values.length / 3) {
            this.rehash();
            index = IntObjectHashMap.hashIndex(this.keys, key);
        }
        ++this.size;
        this.values[index] = value2;
        this.keys[index] = key;
    }

    public void put(int key, @NotNull T value2) {
        int index;
        if (value2 == null) {
            IntObjectHashMap.$$$reportNull$$$0(2);
        }
        if (key == 0) {
            this.specialZeroValue = value2;
            this.hasZeroValue = true;
            return;
        }
        if (this.size >= 2 * this.values.length / 3) {
            this.rehash();
        }
        if (this.values[index = IntObjectHashMap.hashIndex(this.keys, key)] == null) {
            ++this.size;
        }
        this.values[index] = value2;
        if (this.keys[index] == 0) {
            this.keys[index] = key;
        }
    }

    public int index(int key) {
        return key == 0 ? Integer.MIN_VALUE : IntObjectHashMap.hashIndex(this.keys, key);
    }

    private static int hashIndex(int[] keys2, int key) {
        int candidate;
        int hash = (int)((long)key * 2654435769L & Integer.MAX_VALUE);
        int index = hash & keys2.length - 1;
        while ((candidate = keys2[index]) != 0) {
            if (candidate == key) {
                return index;
            }
            if (index == 0) {
                index = keys2.length;
            }
            --index;
        }
        return index;
    }

    private void rehash() {
        int[] newKeys = new int[this.keys.length << 1];
        T[] newValues = this.arrayFactory.produce(newKeys.length);
        for (int i = this.keys.length - 1; i >= 0; --i) {
            int key = this.keys[i];
            if (key == 0) continue;
            int index = IntObjectHashMap.hashIndex(newKeys, key);
            newValues[index] = this.values[i];
            if (newKeys[index] != 0) continue;
            newKeys[index] = key;
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public T get(int key) {
        return key == 0 ? this.specialZeroValue : this.values[IntObjectHashMap.hashIndex(this.keys, key)];
    }

    public T getByIndex(int index, int key) {
        return key == 0 ? this.specialZeroValue : this.values[index];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "value";
        objectArray2[1] = "ksp/com/intellij/util/containers/IntObjectHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceByIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addByIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ArrayProducer<T> {
        public T produce(int var1);
    }
}

