/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiDeclarationStatement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.CharTable;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiDeclarationStatementImpl
extends CompositePsiElement
implements PsiDeclarationStatement {
    private static final TokenSet DECLARED_ELEMENT_BIT_SET = TokenSet.create(JavaElementType.LOCAL_VARIABLE, JavaElementType.CLASS);

    public PsiDeclarationStatementImpl() {
        super(JavaElementType.DECLARATION_STATEMENT);
    }

    @Override
    public PsiElement @NotNull [] getDeclaredElements() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(DECLARED_ELEMENT_BIT_SET, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(1);
        }
        if (child.getElementType() == JavaTokenType.COMMA) {
            return 23;
        }
        return super.getChildRole(child);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement next;
        if (child == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(2);
        }
        if (DECLARED_ELEMENT_BIT_SET.contains(child.getElementType())) {
            PsiElement[] declaredElements = this.getDeclaredElements();
            int length = declaredElements.length;
            if (length == 1) {
                this.getTreeParent().deleteChildInternal(this);
                return;
            }
            if (length > 0) {
                if (SourceTreeToPsiMap.psiElementToTree(declaredElements[length - 1]) == child) {
                    this.removeCommaBefore(child);
                    CharTable charTable = SharedImplUtil.findCharTableByTree(this);
                    LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", charTable, this.getManager());
                    SourceTreeToPsiMap.psiToTreeNotNull(declaredElements[length - 2]).addChild(semicolon, null);
                } else if (SourceTreeToPsiMap.psiElementToTree(declaredElements[0]) == child) {
                    next = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(declaredElements[1]);
                    ASTNode copyChild = child.copyElement();
                    ASTNode nameChild = ((CompositeElement)copyChild).findChildByRole(9);
                    assert (nameChild != null);
                    this.removeCommaBefore(next);
                    ((CompositeElement)next).addInternal((TreeElement)copyChild.getFirstChildNode(), nameChild.getTreePrev(), null, Boolean.FALSE);
                } else {
                    this.removeCommaBefore(child);
                }
            }
        }
        super.deleteChildInternal(child);
        TreeElement first = this.getFirstChildNode();
        if (first != null && !DECLARED_ELEMENT_BIT_SET.contains(first.getElementType())) {
            TreeElement last = first;
            while ((next = last.getTreeNext()) != null && !DECLARED_ELEMENT_BIT_SET.contains(next.getElementType())) {
                last = next;
            }
            this.getTreeParent().addInternal(first, last, this, Boolean.TRUE);
        }
    }

    private void removeCommaBefore(ASTNode child) {
        ASTNode prev = child;
        while ((prev = prev.getTreePrev()) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(prev.getElementType())) {
        }
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            this.deleteChildInternal(prev);
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDeclarationStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(6);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        for (PsiElement element2 : this.getDeclaredElements()) {
            if (element2 != lastParent) {
                if (processor.execute(element2, state)) continue;
                return false;
            }
            ElementClassHint hint = processor.getHint(ElementClassHint.KEY);
            if (!(lastParent instanceof PsiClass) || hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || processor.execute(lastParent, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiDeclarationStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

