/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.file;

import java.util.Collection;
import java.util.Map;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.ui.Queryable;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiDirectoryContainer;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.DebugUtil;
import ksp.com.intellij.psi.impl.PsiElementBase;
import ksp.com.intellij.psi.search.EverythingGlobalScope;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.ui.IconManager;
import ksp.com.intellij.ui.icons.RowIcon;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.PlatformIcons;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class PsiPackageBase
extends PsiElementBase
implements PsiDirectoryContainer,
Queryable {
    private static final Logger LOG = Logger.getInstance(PsiPackageBase.class);
    private final PsiManager myManager;
    private final String myQualifiedName;

    protected abstract Collection<PsiDirectory> getAllDirectories(GlobalSearchScope var1);

    protected abstract PsiPackageBase findPackage(String var1);

    public PsiPackageBase(PsiManager manager, String qualifiedName2) {
        this.myManager = manager;
        this.myQualifiedName = qualifiedName2;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.myManager == ((PsiPackageBase)o).myManager && this.myQualifiedName.equals(((PsiPackageBase)o).myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    public String getQualifiedName() {
        String string2 = this.myQualifiedName;
        if (string2 == null) {
            PsiPackageBase.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public PsiDirectory @NotNull [] getDirectories() {
        PsiDirectory[] psiDirectoryArray = this.getDirectories(new EverythingGlobalScope());
        if (psiDirectoryArray == null) {
            PsiPackageBase.$$$reportNull$$$0(1);
        }
        return psiDirectoryArray;
    }

    @Override
    public PsiDirectory @NotNull [] getDirectories(@NotNull GlobalSearchScope scope) {
        Collection<PsiDirectory> directories2;
        if (scope == null) {
            PsiPackageBase.$$$reportNull$$$0(2);
        }
        PsiDirectory[] psiDirectoryArray = (directories2 = this.getAllDirectories(scope)).isEmpty() ? PsiDirectory.EMPTY_ARRAY : directories2.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PsiPackageBase.$$$reportNull$$$0(3);
        }
        return psiDirectoryArray;
    }

    @Override
    public RowIcon getElementIcon(int elementFlags) {
        return IconManager.getInstance().createLayeredIcon(this, PlatformIcons.PACKAGE_ICON, elementFlags);
    }

    @Override
    public String getName() {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        int index = this.myQualifiedName.lastIndexOf(46);
        if (index <= 0) {
            return this.myQualifiedName;
        }
        return this.myQualifiedName.substring(index + 1);
    }

    @Override
    @Nullable
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name2 == null) {
            PsiPackageBase.$$$reportNull$$$0(4);
        }
        this.checkSetName(name2);
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.setName(name2);
        }
        String nameAfterRename = PsiUtilCore.getQualifiedNameAfterRename(this.getQualifiedName(), name2);
        return this.findPackage(nameAfterRename);
    }

    public void checkSetName(@NotNull String name2) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name2 == null) {
            PsiPackageBase.$$$reportNull$$$0(5);
        }
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.checkSetName(name2);
        }
    }

    public PsiPackageBase getParentPackage() {
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        return this.findPackage(StringUtil.getPackageName(this.myQualifiedName));
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        LOG.error("method not implemented in " + this.getClass());
        if (PsiElement.EMPTY_ARRAY == null) {
            PsiPackageBase.$$$reportNull$$$0(6);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getParent() {
        return this.getParentPackage();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    @Nullable
    public String getText() {
        return null;
    }

    @Override
    public char @NotNull [] textToCharArray() {
        if (ArrayUtilRt.EMPTY_CHAR_ARRAY == null) {
            PsiPackageBase.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            PsiPackageBase.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiPackageBase.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Override
    public PsiElement copy() {
        LOG.error("method not implemented in " + this.getClass());
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiPackageBase.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        if (element2 == null) {
            PsiPackageBase.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        if (element2 == null) {
            PsiPackageBase.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiPackageBase.$$$reportNull$$$0(13);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiDirectory[] dirs;
        this.checkDelete();
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.delete();
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        for (PsiDirectory dir : this.getDirectories()) {
            dir.checkDelete();
        }
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiPackageBase.$$$reportNull$$$0(14);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isWritable() {
        PsiDirectory[] dirs;
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            if (dir.isWritable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiPackageBase:" + this.getQualifiedName();
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiPackageBase.$$$reportNull$$$0(15);
        }
        info.put("packageName", this.getName());
        info.put("packageQualifiedName", this.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/file/PsiPackageBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/file/PsiPackageBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkSetName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

