/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.FileASTNode;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiFileSystemItem;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.ObjectUtils;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface PsiFile
extends PsiFileSystemItem {
    public static final PsiFile[] EMPTY_ARRAY = new PsiFile[0];

    @Override
    public VirtualFile getVirtualFile();

    public PsiDirectory getContainingDirectory();

    @Override
    public PsiDirectory getParent();

    public long getModificationStamp();

    @NotNull
    public PsiFile getOriginalFile();

    @NotNull
    public FileType getFileType();

    @Deprecated
    public PsiFile @NotNull [] getPsiRoots();

    @NotNull
    public FileViewProvider getViewProvider();

    @Override
    public FileASTNode getNode();

    public void subtreeChanged();

    default public void clearCaches() {
    }

    @Nullable
    default public IFileElementType getFileElementType() {
        return ObjectUtils.tryCast(PsiUtilCore.getElementType(this.getNode()), IFileElementType.class);
    }
}

