/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Supplier;
import ksp.com.intellij.core.CoreBundle;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.FileTypeRegistry;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.ModificationTracker;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.UserDataHolderBase;
import ksp.com.intellij.openapi.util.io.FileUtilRt;
import ksp.com.intellij.openapi.vfs.CharsetToolkit;
import ksp.com.intellij.openapi.vfs.VFileProperty;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFileManager;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.com.intellij.openapi.vfs.encoding.EncodingRegistry;
import ksp.com.intellij.util.text.CharArrayUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class VirtualFile
extends UserDataHolderBase
implements ModificationTracker {
    public static final VirtualFile[] EMPTY_ARRAY = new VirtualFile[0];
    @NonNls
    public static final String PROP_NAME = "name";
    @NonNls
    public static final String PROP_ENCODING = "encoding";
    @NonNls
    public static final String PROP_WRITABLE = "writable";
    @NonNls
    public static final String PROP_HIDDEN = "HIDDEN";
    @NonNls
    public static final String PROP_SYMLINK_TARGET = "symlink";
    @NonNls
    public static final String PROP_CHILDREN_CASE_SENSITIVITY = "CHILDREN_CASE_SENSITIVITY";
    private static final Logger LOG = Logger.getInstance(VirtualFile.class);
    private static final Key<byte[]> BOM_KEY = Key.create("BOM");
    private static final Key<Charset> CHARSET_KEY = Key.create("CHARSET");
    private static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create("DETECTED_LINE_SEPARATOR_KEY");

    protected VirtualFile() {
        if (this instanceof Disposable) {
            throw new IllegalStateException("VirtualFile must not implement Disposable because of life-cycle requirements. E.g. VirtualFile should exist throughout the application and may not be disposed half-way.");
        }
    }

    @NotNull
    @NlsSafe
    public abstract String getName();

    @NotNull
    @NlsSafe
    public CharSequence getNameSequence() {
        String string2 = this.getName();
        if (string2 == null) {
            VirtualFile.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    public abstract VirtualFileSystem getFileSystem();

    @NonNls
    @NotNull
    public abstract String getPath();

    @NotNull
    public Path toNioPath() {
        Path path = this.getFileSystem().getNioPath(this);
        if (path == null) {
            throw new UnsupportedOperationException("Failed to map " + this + " (filesystem " + this.getFileSystem() + ") into nio Path");
        }
        Path path2 = path;
        if (path2 == null) {
            VirtualFile.$$$reportNull$$$0(1);
        }
        return path2;
    }

    @NotNull
    public String getUrl() {
        String string2 = VirtualFileManager.constructUrl(this.getFileSystem().getProtocol(), this.getPath());
        if (string2 == null) {
            VirtualFile.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public final String getPresentableUrl() {
        String string2 = this.getFileSystem().extractPresentableUrl(this.getPath());
        if (string2 == null) {
            VirtualFile.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Nullable
    @NlsSafe
    public String getExtension() {
        CharSequence extension = FileUtilRt.getExtension(this.getNameSequence(), null);
        return extension == null ? null : extension.toString();
    }

    @NlsSafe
    @NotNull
    public String getNameWithoutExtension() {
        String string2 = FileUtilRt.getNameWithoutExtension(this.getNameSequence()).toString();
        if (string2 == null) {
            VirtualFile.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            VirtualFile.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getName().equals(newName)) {
            return;
        }
        if (!this.getFileSystem().isValidName(newName)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", newName));
        }
        this.getFileSystem().renameFile(requestor, this, newName);
    }

    public abstract boolean isWritable();

    public void setWritable(boolean writable) throws IOException {
        throw new IOException("Not supported");
    }

    public abstract boolean isDirectory();

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            VirtualFile.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Nullable
    public String getCanonicalPath() {
        return this.getPath();
    }

    @Nullable
    public VirtualFile getCanonicalFile() {
        return this;
    }

    public abstract boolean isValid();

    public abstract VirtualFile getParent();

    public abstract VirtualFile[] getChildren();

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name2) {
        VirtualFile[] children2;
        if (name2 == null) {
            VirtualFile.$$$reportNull$$$0(7);
        }
        if ((children2 = this.getChildren()) == null) {
            return null;
        }
        for (VirtualFile child : children2) {
            if (!child.nameEquals(name2)) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public VirtualFile findOrCreateChildData(Object requestor, @NotNull @NonNls String name2) throws IOException {
        VirtualFile child;
        if (name2 == null) {
            VirtualFile.$$$reportNull$$$0(8);
        }
        if ((child = this.findChild(name2)) != null) {
            VirtualFile virtualFile = child;
            if (virtualFile == null) {
                VirtualFile.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = this.createChildData(requestor, name2);
        if (virtualFile == null) {
            VirtualFile.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(this);
        if (fileType == null) {
            VirtualFile.$$$reportNull$$$0(11);
        }
        return fileType;
    }

    @Nullable
    public VirtualFile findFileByRelativePath(@NotNull @NonNls String relPath) {
        if (relPath == null) {
            VirtualFile.$$$reportNull$$$0(12);
        }
        VirtualFile child = this;
        int off = CharArrayUtil.shiftForward(relPath, 0, "/");
        while (child != null && off < relPath.length()) {
            String name2;
            int nextOff = relPath.indexOf(47, off);
            if (nextOff < 0) {
                nextOff = relPath.length();
            }
            if ((name2 = relPath.substring(off, nextOff)).equals("..")) {
                VirtualFile canonicalFile;
                child = child.is(VFileProperty.SYMLINK) ? ((canonicalFile = child.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : child.getParent();
            } else if (!name2.equals(".")) {
                child = child.findChild(name2);
            }
            off = CharArrayUtil.shiftForward(relPath, nextOff, "/");
        }
        return child;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull @NonNls String name2) throws IOException {
        if (name2 == null) {
            VirtualFile.$$$reportNull$$$0(13);
        }
        if (!this.isDirectory()) {
            throw new IOException(CoreBundle.message("directory.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(CoreBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!this.getFileSystem().isValidName(name2)) {
            throw new IOException(CoreBundle.message("directory.invalid.name.error", name2));
        }
        if (this.findChild(name2) != null) {
            throw new IOException(CoreBundle.message("file.create.already.exists.error", this.getUrl(), name2));
        }
        VirtualFile virtualFile = this.getFileSystem().createChildDirectory(requestor, this, name2);
        if (virtualFile == null) {
            VirtualFile.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull @NonNls String name2) throws IOException {
        if (name2 == null) {
            VirtualFile.$$$reportNull$$$0(15);
        }
        if (!this.isDirectory()) {
            throw new IOException(CoreBundle.message("file.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(CoreBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!this.getFileSystem().isValidName(name2)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", name2));
        }
        if (this.findChild(name2) != null) {
            throw new IOException(CoreBundle.message("file.create.already.exists.error", this.getUrl(), name2));
        }
        VirtualFile virtualFile = this.getFileSystem().createChildFile(requestor, this, name2);
        if (virtualFile == null) {
            VirtualFile.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    public void delete(Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(this.isValid(), "Deleting invalid file");
        this.getFileSystem().deleteFile(requestor, this);
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            VirtualFile.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message("file.move.error", newParent.getPresentableUrl()));
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, () -> {
            this.getFileSystem().moveFile(requestor, this, newParent);
            return this;
        });
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull @NonNls String copyName) throws IOException {
        if (newParent == null) {
            VirtualFile.$$$reportNull$$$0(18);
        }
        if (copyName == null) {
            VirtualFile.$$$reportNull$$$0(19);
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message("file.copy.error", newParent.getPresentableUrl()));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(CoreBundle.message("file.copy.target.must.be.directory", new Object[0]));
        }
        VirtualFile virtualFile = EncodingRegistry.doActionAndRestoreEncoding(this, () -> this.getFileSystem().copyFile(requestor, this, newParent, copyName));
        if (virtualFile == null) {
            VirtualFile.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getStoredCharset();
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
            this.setCharset(charset);
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            VirtualFile.$$$reportNull$$$0(21);
        }
        return charset2;
    }

    @Nullable
    private Charset getStoredCharset() {
        return this.getUserData(CHARSET_KEY);
    }

    protected void storeCharset(Charset charset) {
        this.putUserData(CHARSET_KEY, charset);
    }

    public void setCharset(Charset charset) {
        this.setCharset(charset, null);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged) {
        this.setCharset(charset, whenChanged, true);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged, boolean fireEventsWhenChanged) {
        Charset old = this.getStoredCharset();
        this.storeCharset(charset);
        if (Comparing.equal(charset, old)) {
            return;
        }
        byte[] bom = charset == null ? null : CharsetToolkit.getMandatoryBom(charset);
        byte[] existingBOM = this.getBOM();
        if (bom == null && charset != null && existingBOM != null) {
            bom = (byte[])(CharsetToolkit.canHaveBom(charset, existingBOM) ? existingBOM : null);
        }
        this.setBOM(bom);
        if (old != null) {
            if (whenChanged != null) {
                whenChanged.run();
            }
            if (fireEventsWhenChanged) {
                VirtualFileManager.getInstance().notifyPropertyChanged(this, PROP_ENCODING, old, charset);
            }
        }
    }

    public boolean isCharsetSet() {
        return this.getStoredCharset() != null;
    }

    public final void setBinaryContent(byte @NotNull [] content) throws IOException {
        if (content == null) {
            VirtualFile.$$$reportNull$$$0(22);
        }
        this.setBinaryContent(content, -1L, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            VirtualFile.$$$reportNull$$$0(23);
        }
        this.setBinaryContent(content, newModificationStamp, (long)newTimeStamp, this);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            VirtualFile.$$$reportNull$$$0(24);
        }
        try (OutputStream outputStream = this.getOutputStream(requestor, newModificationStamp, newTimeStamp);){
            outputStream.write(content);
        }
    }

    @NotNull
    public final OutputStream getOutputStream(Object requestor) throws IOException {
        OutputStream outputStream = this.getOutputStream(requestor, -1L, -1L);
        if (outputStream == null) {
            VirtualFile.$$$reportNull$$$0(25);
        }
        return outputStream;
    }

    @NotNull
    public abstract OutputStream getOutputStream(Object var1, long var2, long var4) throws IOException;

    public abstract byte @NotNull [] contentsToByteArray() throws IOException;

    public byte @NotNull [] contentsToByteArray(boolean cacheContent) throws IOException {
        byte[] byArray = this.contentsToByteArray();
        if (byArray == null) {
            VirtualFile.$$$reportNull$$$0(26);
        }
        return byArray;
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract long getTimeStamp();

    public abstract long getLength();

    public void refresh(boolean asynchronous, boolean recursive) {
        this.refresh(asynchronous, recursive, null);
    }

    public abstract void refresh(boolean var1, boolean var2, @Nullable Runnable var3);

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string2 = this.getName();
        if (string2 == null) {
            VirtualFile.$$$reportNull$$$0(27);
        }
        return string2;
    }

    @Override
    public long getModificationCount() {
        return this.isValid() ? this.getTimeStamp() : -1L;
    }

    protected boolean nameEquals(@NotNull @NonNls String name2) {
        if (name2 == null) {
            VirtualFile.$$$reportNull$$$0(28);
        }
        return Comparing.equal(this.getNameSequence(), (CharSequence)name2);
    }

    @NotNull
    public abstract InputStream getInputStream() throws IOException;

    public byte @Nullable [] getBOM() {
        return this.getUserData(BOM_KEY);
    }

    public void setBOM(byte @Nullable [] BOM) {
        this.putUserData(BOM_KEY, BOM);
    }

    @Override
    public String toString() {
        return "VirtualFile: " + this.getPresentableUrl();
    }

    public boolean exists() {
        return this.isValid();
    }

    public boolean isInLocalFileSystem() {
        return false;
    }

    @Nullable
    @NlsSafe
    public String getDetectedLineSeparator() {
        return this.getUserData(DETECTED_LINE_SEPARATOR_KEY);
    }

    public void setDetectedLineSeparator(@Nullable String separator) {
        this.putUserData(DETECTED_LINE_SEPARATOR_KEY, separator);
    }

    public <T> T computeWithPreloadedContentHint(byte @NotNull [] preloadedContentHint, @NotNull Supplier<? extends T> computable) {
        if (computable == null) {
            VirtualFile.$$$reportNull$$$0(29);
        }
        if (preloadedContentHint == null) {
            VirtualFile.$$$reportNull$$$0(30);
        }
        return computable.get();
    }

    public boolean isRecursiveOrCircularSymlink() {
        if (!this.is(VFileProperty.SYMLINK)) {
            return false;
        }
        VirtualFile resolved = this.getCanonicalFile();
        if (resolved == null) {
            return false;
        }
        if (VfsUtilCore.isAncestor(resolved, this, false)) {
            return true;
        }
        for (VirtualFile p = this.getParent(); p != null; p = p.getParent()) {
            VirtualFile parentResolved;
            if (!p.is(VFileProperty.SYMLINK) || !resolved.equals(parentResolved = p.getCanonicalFile())) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    public boolean isCaseSensitive() {
        return this.getFileSystem().isCaseSensitive();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/VirtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_NAME;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadedContentHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toNioPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/VirtualFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChildData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateChildData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByRelativePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "nameEquals";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeWithPreloadedContentHint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface PropName {
    }
}

