/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.impl;

import ksp.com.intellij.openapi.editor.event.DocumentEvent;
import ksp.com.intellij.openapi.editor.impl.FrozenDocument;
import ksp.com.intellij.openapi.editor.impl.PersistentRangeMarker;
import ksp.com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import ksp.com.intellij.openapi.editor.impl.RangeMarkerImpl;
import ksp.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.Segment;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.util.DocumentEventUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class ManualRangeMarker
implements Segment {
    private final int myStart;
    private final int myEnd;
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private final boolean mySurviveOnExternalChange;
    private final PersistentRangeMarker.LinesCols myLinesCols;

    public ManualRangeMarker(int start, int end, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange, @Nullable PersistentRangeMarker.LinesCols linesCols) {
        this.myStart = start;
        this.myEnd = end;
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.mySurviveOnExternalChange = surviveOnExternalChange;
        this.myLinesCols = linesCols;
    }

    @Nullable
    public ManualRangeMarker getUpdatedRange(@NotNull DocumentEvent event, @NotNull FrozenDocument documentBefore) {
        int srcOffset;
        TextRange range;
        if (event == null) {
            ManualRangeMarker.$$$reportNull$$$0(0);
        }
        if (documentBefore == null) {
            ManualRangeMarker.$$$reportNull$$$0(1);
        }
        if (this.mySurviveOnExternalChange && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.myStart, this.myEnd)) {
            Pair.NonNull<TextRange, PersistentRangeMarker.LinesCols> pair;
            PersistentRangeMarker.LinesCols linesCols = this.myLinesCols != null ? this.myLinesCols : PersistentRangeMarker.storeLinesAndCols(documentBefore, this.myStart, this.myEnd);
            Pair.NonNull<TextRange, PersistentRangeMarker.LinesCols> nonNull = pair = linesCols == null ? null : PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
            if (pair != null) {
                return new ManualRangeMarker(((TextRange)pair.first).getStartOffset(), ((TextRange)pair.first).getEndOffset(), this.myGreedyLeft, this.myGreedyRight, true, (PersistentRangeMarker.LinesCols)pair.second);
            }
        }
        if ((range = RangeMarkerImpl.applyChange(event, this.myStart, this.myEnd, this.myGreedyLeft, this.myGreedyRight, false)) == null) {
            return null;
        }
        int delta = 0;
        if (DocumentEventUtil.isMoveInsertion(event) && (srcOffset = event.getMoveOffset()) <= range.getStartOffset() && range.getEndOffset() <= srcOffset + event.getNewLength()) {
            delta = event.getOffset() - srcOffset;
        }
        return new ManualRangeMarker(range.getStartOffset() + delta, range.getEndOffset() + delta, this.myGreedyLeft, this.myGreedyRight, this.mySurviveOnExternalChange, null);
    }

    @Override
    public int getStartOffset() {
        return this.myStart;
    }

    @Override
    public int getEndOffset() {
        return this.myEnd;
    }

    public String toString() {
        return "ManualRangeMarker" + TextRange.create(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "documentBefore";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/openapi/editor/impl/ManualRangeMarker";
        objectArray[2] = "getUpdatedRange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

