/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import ksp.com.google.common.annotations.Beta;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.collect.ForwardingCollection;
import ksp.com.google.common.collect.Lists;
import ksp.com.google.errorprone.annotations.CanIgnoreReturnValue;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class ForwardingList<E>
extends ForwardingCollection<E>
implements List<E> {
    protected ForwardingList() {
    }

    @Override
    protected abstract List<E> delegate();

    @Override
    public void add(int index, E element2) {
        this.delegate().add(index, element2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addAll(int index, Collection<? extends E> elements) {
        return this.delegate().addAll(index, elements);
    }

    @Override
    public E get(int index) {
        return this.delegate().get(index);
    }

    @Override
    public int indexOf(Object element2) {
        return this.delegate().indexOf(element2);
    }

    @Override
    public int lastIndexOf(Object element2) {
        return this.delegate().lastIndexOf(element2);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.delegate().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.delegate().listIterator(index);
    }

    @Override
    @CanIgnoreReturnValue
    public E remove(int index) {
        return this.delegate().remove(index);
    }

    @Override
    @CanIgnoreReturnValue
    public E set(int index, E element2) {
        return this.delegate().set(index, element2);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.delegate().subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected boolean standardAdd(E element2) {
        this.add(this.size(), element2);
        return true;
    }

    protected boolean standardAddAll(int index, Iterable<? extends E> elements) {
        return Lists.addAllImpl(this, index, elements);
    }

    protected int standardIndexOf(@Nullable Object element2) {
        return Lists.indexOfImpl(this, element2);
    }

    protected int standardLastIndexOf(@Nullable Object element2) {
        return Lists.lastIndexOfImpl(this, element2);
    }

    protected Iterator<E> standardIterator() {
        return this.listIterator();
    }

    protected ListIterator<E> standardListIterator() {
        return this.listIterator(0);
    }

    @Beta
    protected ListIterator<E> standardListIterator(int start) {
        return Lists.listIteratorImpl(this, start);
    }

    @Beta
    protected List<E> standardSubList(int fromIndex, int toIndex) {
        return Lists.subListImpl(this, fromIndex, toIndex);
    }

    @Beta
    protected boolean standardEquals(@Nullable Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Beta
    protected int standardHashCode() {
        return Lists.hashCodeImpl(this);
    }
}

