/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations;
import ksp.org.jetbrains.kotlin.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtTypeConstraint;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import ksp.org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import ksp.org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import ksp.org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;

public class LazyTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor
implements LazyEntity {
    private final LazyClassContext c;
    private final KtTypeParameter typeParameter;

    public LazyTypeParameterDescriptor(@NotNull LazyClassContext c, @NotNull LazyClassDescriptor containingDeclaration2, @NotNull KtTypeParameter typeParameter, @NotNull Annotations annotations2, int index2) {
        if (c == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(0);
        }
        if (containingDeclaration2 == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(1);
        }
        if (typeParameter == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(2);
        }
        if (annotations2 == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(3);
        }
        super(c.getStorageManager(), containingDeclaration2, annotations2, typeParameter.getNameAsSafeName(), typeParameter.getVariance(), typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), index2, KotlinSourceElementKt.toSourceElement(typeParameter), c.getSupertypeLoopChecker());
        this.c = c;
        this.typeParameter = typeParameter;
        this.c.getTrace().record(BindingContext.TYPE_PARAMETER, typeParameter, this);
    }

    @Override
    protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
        if (type2 == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(4);
        }
        for (KtTypeReference typeReference : this.getAllUpperBounds()) {
            if (!this.resolveBoundType(typeReference).getConstructor().equals(type2.getConstructor())) continue;
            this.c.getTrace().report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeReference));
            return;
        }
    }

    @Override
    @NotNull
    protected List<KotlinType> resolveUpperBounds() {
        ArrayList<KotlinType> upperBounds2 = new ArrayList<KotlinType>(1);
        for (KtTypeReference typeReference : this.getAllUpperBounds()) {
            KotlinType resolvedType = this.resolveBoundType(typeReference);
            if (KotlinTypeKt.isError(resolvedType)) continue;
            upperBounds2.add(resolvedType);
        }
        if (upperBounds2.isEmpty()) {
            upperBounds2.add(this.c.getModuleDescriptor().getBuiltIns().getDefaultBound());
        }
        ArrayList<KotlinType> arrayList = upperBounds2;
        if (arrayList == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private Collection<KtTypeReference> getAllUpperBounds() {
        return CollectionsKt.plus(this.typeParameter.getExtendsBound() != null ? Collections.singletonList(this.typeParameter.getExtendsBound()) : Collections.emptyList(), this.getUpperBoundsFromWhereClause());
    }

    private Collection<KtTypeReference> getUpperBoundsFromWhereClause() {
        ArrayList<KtTypeReference> result2 = new ArrayList<KtTypeReference>();
        KtClassOrObject classOrObject = KtStubbedPsiUtil.getPsiOrStubParent(this.typeParameter, KtClassOrObject.class, true);
        if (classOrObject instanceof KtClass) {
            for (KtTypeConstraint typeConstraint : classOrObject.getTypeConstraints()) {
                KtSimpleNameExpression constrainedParameterName = typeConstraint.getSubjectTypeParameterName();
                if (constrainedParameterName == null || !this.getName().equals(constrainedParameterName.getReferencedNameAsName())) continue;
                this.c.getTrace().record(BindingContext.REFERENCE_TARGET, constrainedParameterName, this);
                KtTypeReference boundTypeReference = typeConstraint.getBoundTypeReference();
                if (boundTypeReference == null) continue;
                result2.add(boundTypeReference);
            }
        }
        return result2;
    }

    @NotNull
    private KotlinType resolveBoundType(@NotNull KtTypeReference boundTypeReference) {
        if (boundTypeReference == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(6);
        }
        KotlinType kotlinType = this.c.getTypeResolver().resolveType(this.getContainingDeclaration().getScopeForClassHeaderResolution(), boundTypeReference, this.c.getTrace(), false);
        if (kotlinType == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(7);
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public LazyClassDescriptor getContainingDeclaration() {
        LazyClassDescriptor lazyClassDescriptor = (LazyClassDescriptor)super.getContainingDeclaration();
        if (lazyClassDescriptor == null) {
            LazyTypeParameterDescriptor.$$$reportNull$$$0(8);
        }
        return lazyClassDescriptor;
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        this.getOriginal();
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        ForceResolveUtil.forceResolveAllContents(this.getUpperBounds());
        this.getVariance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundTypeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveUpperBounds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBoundType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportSupertypeLoopError";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveBoundType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

