/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtCallExpression;
import ksp.org.jetbrains.kotlin.psi.KtLambdaExpression;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J$\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/SuspensionPointInsideMutexLockChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCall", "", "parent", "Lksp/org/jetbrains/kotlin/psi/KtCallExpression;", "child", "insideLambda", "reportProblem", "frontend.java"})
public final class SuspensionPointInsideMutexLockChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
            return;
        }
        Object object = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context2);
        if (object == null || (object = object.getSource()) == null || (object = PsiSourceElementKt.getPsi((SourceElement)object)) == null) {
            return;
        }
        Object enclosingSuspendFunctionSource = object;
        PsiElement parent2 = reportOn;
        PsiElement child = reportOn;
        boolean insideLambda = false;
        while (!(Intrinsics.areEqual((Object)parent2, (Object)enclosingSuspendFunctionSource) || parent2 instanceof KtCallExpression && this.checkCall(context2, (KtCallExpression)parent2, child, insideLambda, reportOn, resolvedCall2))) {
            if (parent2 instanceof KtLambdaExpression) {
                insideLambda = true;
            }
            if (!(parent2 instanceof KtValueArgumentList)) {
                child = parent2;
            }
            if (parent2.getParent() != null) continue;
            return;
        }
    }

    private final boolean checkCall(CallCheckerContext context2, KtCallExpression parent2, PsiElement child, boolean insideLambda, PsiElement reportOn, ResolvedCall<?> resolvedCall2) {
        Call call2 = (Call)context2.getTrace().get(BindingContext.CALL, parent2.getCalleeExpression());
        if (call2 == null) {
            return false;
        }
        Call call3 = call2;
        ResolvedCall resolvedCall3 = (ResolvedCall)context2.getTrace().get(BindingContext.RESOLVED_CALL, call3);
        if (resolvedCall3 == null) {
            return false;
        }
        ResolvedCall resolved = resolvedCall3;
        Object d = resolved.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, (String)"getResultingDescriptor(...)");
        boolean isSynchronized = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)d, "synchronized", "kotlin");
        if (isSynchronized) {
            List<ResolvedValueArgument> list2 = resolved.getValueArgumentsByIndex();
            ResolvedValueArgument resolvedValueArgument = list2 != null ? list2.get(1) : null;
            ExpressionValueArgument expressionValueArgument = resolvedValueArgument instanceof ExpressionValueArgument ? (ExpressionValueArgument)resolvedValueArgument : null;
            boolean isSecondArgument = Intrinsics.areEqual((Object)(expressionValueArgument != null ? expressionValueArgument.getValueArgument() : null), (Object)child);
            if (insideLambda && isSecondArgument) {
                this.reportProblem(context2, reportOn, resolvedCall2);
            }
            return true;
        }
        Object d2 = resolved.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(d2, (String)"getResultingDescriptor(...)");
        boolean isWithLock = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)d2, "withLock", "kotlin.concurrent");
        if (isWithLock) {
            this.reportProblem(context2, reportOn, resolvedCall2);
            return true;
        }
        return false;
    }

    private final void reportProblem(CallCheckerContext context2, PsiElement reportOn, ResolvedCall<?> resolvedCall2) {
        context2.getTrace().report(ErrorsJvm.SUSPENSION_POINT_INSIDE_CRITICAL_SECTION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
    }
}

