/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import ksp.org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import ksp.org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsKt;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker;", "", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingTrace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "checkFunction", "Lksp/org/jetbrains/kotlin/psi/KtFunction;", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkLocalVariable", "Lksp/org/jetbrains/kotlin/psi/KtProperty;", "Lksp/org/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkNullabilityAssertion", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "declarationType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "checkProperty", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkPropertyAccessor", "Lksp/org/jetbrains/kotlin/psi/KtPropertyAccessor;", "Lksp/org/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "canContainNull", "", "Lksp/org/jetbrains/kotlin/types/UnwrappedType;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nRuntimeAssertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeAssertions.kt\norg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1724#2,3:249\n*S KotlinDebug\n*F\n+ 1 RuntimeAssertions.kt\norg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker\n*L\n244#1:249,3\n*E\n"})
public final class RuntimeAssertionsOnDeclarationBodyChecker {
    @NotNull
    public static final RuntimeAssertionsOnDeclarationBodyChecker INSTANCE = new RuntimeAssertionsOnDeclarationBodyChecker();

    private RuntimeAssertionsOnDeclarationBodyChecker() {
    }

    @JvmStatic
    public static final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace bindingTrace, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        if (!languageVersionSettings2.supportsFeature(LanguageFeature.StrictJavaNullabilityAssertions)) {
            return;
        }
        if (declaration2 instanceof KtProperty && descriptor2 instanceof VariableDescriptor) {
            INSTANCE.checkLocalVariable((KtProperty)declaration2, (VariableDescriptor)descriptor2, bindingTrace);
        } else if (declaration2 instanceof KtFunction && descriptor2 instanceof FunctionDescriptor) {
            INSTANCE.checkFunction((KtFunction)declaration2, (FunctionDescriptor)descriptor2, bindingTrace);
        } else if (declaration2 instanceof KtProperty && descriptor2 instanceof PropertyDescriptor) {
            INSTANCE.checkProperty((KtProperty)declaration2, (PropertyDescriptor)descriptor2, bindingTrace);
        } else if (declaration2 instanceof KtPropertyAccessor && descriptor2 instanceof PropertyAccessorDescriptor) {
            INSTANCE.checkPropertyAccessor((KtPropertyAccessor)declaration2, (PropertyAccessorDescriptor)descriptor2, bindingTrace);
        }
    }

    private final void checkLocalVariable(KtProperty declaration2, VariableDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getTypeReference() != null) {
            return;
        }
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkFunction(KtFunction declaration2, FunctionDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getTypeReference() != null || declaration2.hasBlockBody()) {
            return;
        }
        KtExpression ktExpression = declaration2.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return;
        }
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkProperty(KtProperty declaration2, PropertyDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getTypeReference() != null) {
            return;
        }
        if (declaration2.hasDelegateExpression()) {
            return;
        }
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkPropertyAccessor(KtPropertyAccessor declaration2, PropertyAccessorDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getProperty().getTypeReference() != null || declaration2.hasBlockBody()) {
            return;
        }
        KtExpression ktExpression = declaration2.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getCorrespondingProperty().getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkNullabilityAssertion(KtExpression expression2, KotlinType declarationType, BindingTrace bindingTrace) {
        if (this.canContainNull(declarationType.unwrap())) {
            return;
        }
        KotlinType kotlinType = bindingTrace.getType(expression2);
        if (kotlinType == null) {
            return;
        }
        KotlinType expressionType2 = kotlinType;
        if (KotlinTypeKt.isError(expressionType2)) {
            return;
        }
        if (!TypeEnhancementKt.hasEnhancedNullability(expressionType2)) {
            return;
        }
        bindingTrace.record(JvmBindingContextSlices.BODY_RUNTIME_ASSERTION_INFO, expression2, new RuntimeAssertionInfo(true, RuntimeAssertionsKt.access$getTextForRuntimeAssertionInfo(expression2)));
    }

    private final boolean canContainNull(UnwrappedType $this$canContainNull) {
        boolean bl;
        block7: {
            SimpleType upper = FlexibleTypesKt.upperIfFlexible($this$canContainNull);
            if (upper.isMarkedNullable()) {
                bl = true;
            } else if (NewKotlinTypeCheckerKt.isClassType(upper)) {
                bl = false;
            } else {
                Iterable $this$all$iv = TypeUtilsKt.immediateSupertypes(upper);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (INSTANCE.canContainNull(it.unwrap())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }
}

