/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

public class ArrayAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final KtArrayAccessExpression expression;

    static ArrayAccessTranslator newInstance(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(1);
        }
        return new ArrayAccessTranslator(expression2, context2);
    }

    private ArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(3);
        }
        super(context2);
        this.expression = expression2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.translateAsGet(this.getArrayExpression());
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(4);
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression translateAsGet(@NotNull JsExpression arrayExpression) {
        if (arrayExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(5);
        }
        return this.translateAsMethodCall(arrayExpression, null);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(6);
        }
        return this.translateAsMethodCall(this.getArrayExpression(), setTo);
    }

    @NotNull
    private JsExpression translateAsMethodCall(@NotNull JsExpression arrayExpression, @Nullable JsExpression toSetTo) {
        if (arrayExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(7);
        }
        boolean isGetter = toSetTo == null;
        TranslationContext context2 = this.context();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, isGetter);
        if (!isGetter) {
            context2 = this.contextWithValueParameterAliasInArrayGetAccess(toSetTo);
        }
        JsExpression jsExpression = CallTranslator.translate(context2, resolvedCall2, arrayExpression);
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(8);
        }
        return jsExpression;
    }

    @NotNull
    protected JsExpression getArrayExpression() {
        KtExpression arrayExpression = this.expression.getArrayExpression();
        assert (arrayExpression != null) : "Code with parsing errors shouldn't be translated";
        JsExpression jsExpression = Translation.translateAsExpression(arrayExpression, this.context());
        if (jsExpression == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(9);
        }
        return jsExpression;
    }

    @NotNull
    private TranslationContext contextWithValueParameterAliasInArrayGetAccess(@NotNull JsExpression toSetTo) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        List<ResolvedValueArgument> arguments2;
        if (toSetTo == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(10);
        }
        if ((arguments2 = (resolvedCall2 = BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, false)).getValueArgumentsByIndex()) == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor());
        }
        ResolvedValueArgument lastArgument = arguments2.get(arguments2.size() - 1);
        assert (lastArgument instanceof ExpressionValueArgument) : "Last argument of array-like setter must be ExpressionValueArgument: " + lastArgument;
        ValueArgument valueArgument = ((ExpressionValueArgument)lastArgument).getValueArgument();
        assert (valueArgument != null);
        KtExpression element2 = valueArgument.getArgumentExpression();
        TranslationContext translationContext = this.context().innerContextWithAliasesForExpressions(Collections.singletonMap(element2, toSetTo));
        if (translationContext == null) {
            ArrayAccessTranslator.$$$reportNull$$$0(11);
        }
        return translationContext;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        HashMap<KtExpression, JsExpression> aliases = new HashMap<KtExpression, JsExpression>();
        JsExpression arrayExpression = this.context().cacheExpressionIfNeeded(this.getArrayExpression());
        aliases.put(this.expression.getArrayExpression(), arrayExpression);
        for (KtExpression ktExpression : this.expression.getIndexExpressions()) {
            JsExpression jsExpression = this.context().cacheExpressionIfNeeded(Translation.translateAsExpression(ktExpression, this.context()));
            aliases.put(ktExpression, jsExpression);
        }
        return new CachedArrayAccessTranslator(this.expression, this.context().innerContextWithAliasesForExpressions(aliases), arrayExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSetTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsMethodCall";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "contextWithValueParameterAliasInArrayGetAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateAsGet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translateAsMethodCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contextWithValueParameterAliasInArrayGetAccess";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedArrayAccessTranslator
    extends ArrayAccessTranslator {
        @NotNull
        private final JsExpression arrayExpression;

        protected CachedArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context2, @NotNull JsExpression arrayExpression) {
            if (expression2 == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(1);
            }
            if (arrayExpression == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(2);
            }
            super(expression2, context2);
            this.arrayExpression = arrayExpression;
        }

        @Override
        @NotNull
        protected JsExpression getArrayExpression() {
            JsExpression jsExpression = this.arrayExpression;
            if (jsExpression == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(3);
            }
            return jsExpression;
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            CachedArrayAccessTranslator cachedArrayAccessTranslator = this;
            if (cachedArrayAccessTranslator == null) {
                CachedArrayAccessTranslator.$$$reportNull$$$0(4);
            }
            return cachedArrayAccessTranslator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/ArrayAccessTranslator$CachedArrayAccessTranslator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrayExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

