/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBlock;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsCatch;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsIf;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsThrow;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.psi.KtCatchClause;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingContextUtils;
import ksp.org.jetbrains.kotlin.types.DynamicTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/expression/CatchTranslator;", "Lksp/org/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "catches", "", "Lksp/org/jetbrains/kotlin/psi/KtCatchClause;", "psi", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Ljava/util/List;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCatches", "()Ljava/util/List;", "getPsi", "()Lcom/intellij/psi/PsiElement;", "isDynamic", "", "Lksp/org/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "translate", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsCatch;", "translateCatchBody", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsBlock;", "catchClause", "translateCatches", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsStatement;", "initialCatchParameterRef", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsNameRef;", "", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCatchTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatchTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/CatchTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class CatchTranslator
extends AbstractTranslator {
    @NotNull
    private final List<KtCatchClause> catches;
    @NotNull
    private final PsiElement psi;

    public CatchTranslator(@NotNull List<? extends KtCatchClause> catches, @NotNull PsiElement psi2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(catches, (String)"catches");
        Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.catches = catches;
        this.psi = psi2;
    }

    @NotNull
    public final List<KtCatchClause> getCatches() {
        return this.catches;
    }

    @NotNull
    public final PsiElement getPsi() {
        return this.psi;
    }

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        KtCatchClause firstCatch = (KtCatchClause)CollectionsKt.first(this.catches);
        KtParameter catchParameter = firstCatch.getCatchParameter();
        BindingContext bindingContext = this.bindingContext();
        KtParameter ktParameter = catchParameter;
        Intrinsics.checkNotNull((Object)ktParameter);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, ktParameter);
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getDescriptorForElement(...)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        String string2 = this.context().getNameForDescriptor(parameterDescriptor).getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
        String parameterName = string2;
        JsCatch jsCatch = new JsCatch(this.context().scope(), parameterName);
        JsNameRef jsNameRef = jsCatch.getParameter().getName().makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
        JsNameRef parameterRef = jsNameRef;
        TranslationContext translationContext = this.context().innerContextWithAliased(parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerContextWithAliased(...)");
        TranslationContext catchContext = translationContext;
        jsCatch.setBody(new JsBlock(this.translateCatches(catchContext, parameterRef, this.catches.iterator())));
        return jsCatch;
    }

    private final JsStatement translateCatches(TranslationContext context2, JsNameRef initialCatchParameterRef, Iterator<? extends KtCatchClause> catches) {
        JsIf jsIf;
        JsNameRef jsNameRef;
        if (!catches.hasNext()) {
            JsThrow jsThrow;
            JsThrow $this$translateCatches_u24lambda_u240 = jsThrow = new JsThrow(initialCatchParameterRef);
            boolean bl = false;
            $this$translateCatches_u24lambda_u240.setSource(this.psi);
            return jsThrow;
        }
        TranslationContext nextContext = context2;
        KtCatchClause ktCatchClause = catches.next();
        KtParameter ktParameter = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull((Object)ktParameter);
        KtParameter param = ktParameter;
        BindingContext bindingContext = this.bindingContext();
        KtParameter ktParameter2 = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull((Object)ktParameter2);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, ktParameter2);
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getDescriptorForElement(...)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        JsName jsName = this.context().getNameForDescriptor(parameterDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        JsName parameterName = jsName;
        KtTypeReference ktTypeReference = param.getTypeReference();
        Intrinsics.checkNotNull((Object)ktTypeReference);
        KtTypeReference paramType = ktTypeReference;
        List additionalStatements = new ArrayList();
        if (!Intrinsics.areEqual((Object)parameterName.getIdent(), (Object)initialCatchParameterRef.getIdent())) {
            JsNameRef ref;
            JsName jsName2 = JsScope.declareTemporaryName(parameterName.getIdent());
            Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"declareTemporaryName(...)");
            JsName parameterAlias = jsName2;
            ((Collection)additionalStatements).add(JsAstUtils.newVar(parameterAlias, initialCatchParameterRef));
            JsNameRef jsNameRef2 = JsAstUtils.pureFqn(parameterAlias, null);
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"pureFqn(...)");
            jsNameRef = ref = jsNameRef2;
        } else {
            jsNameRef = initialCatchParameterRef;
        }
        JsNameRef parameterRef = jsNameRef;
        TranslationContext translationContext = nextContext.innerContextWithAliased(parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerContextWithAliased(...)");
        nextContext = translationContext;
        JsBlock thenBlock = this.translateCatchBody(nextContext, ktCatchClause);
        thenBlock.getStatements().addAll(0, additionalStatements);
        if (this.isDynamic(paramType)) {
            return thenBlock;
        }
        PatternTranslator $this$translateCatches_u24lambda_u241 = Translation.patternTranslator(nextContext);
        boolean bl = false;
        JsExpression jsExpression = $this$translateCatches_u24lambda_u241.translateIsCheck(initialCatchParameterRef, paramType);
        Intrinsics.checkNotNull((Object)jsExpression);
        JsExpression typeCheck = jsExpression;
        JsStatement elseBlock = this.translateCatches(context2, initialCatchParameterRef, catches);
        JsIf $this$translateCatches_u24lambda_u242 = jsIf = new JsIf(typeCheck.source(ktCatchClause), thenBlock, elseBlock);
        boolean bl2 = false;
        $this$translateCatches_u24lambda_u242.setSource(ktCatchClause);
        return jsIf;
    }

    private final JsBlock translateCatchBody(TranslationContext context2, KtCatchClause catchClause) {
        KtExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context2) : JsAstUtils.asSyntheticStatement(new JsNullLiteral());
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"convertToBlock(...)");
        return jsBlock;
    }

    private final boolean isDynamic(KtTypeReference $this$isDynamic) {
        Object v = BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $this$isDynamic);
        Intrinsics.checkNotNullExpressionValue(v, (String)"getNotNull(...)");
        return DynamicTypesKt.isDynamic((KotlinType)v);
    }
}

