/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import ksp.org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.expressions.ClassLiteralChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsModuleClassLiteralChecker;", "Lksp/org/jetbrains/kotlin/types/expressions/ClassLiteralChecker;", "()V", "check", "", "expression", "Lksp/org/jetbrains/kotlin/psi/KtClassLiteralExpression;", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "js.frontend"})
public final class JsModuleClassLiteralChecker
implements ClassLiteralChecker {
    @NotNull
    public static final JsModuleClassLiteralChecker INSTANCE = new JsModuleClassLiteralChecker();

    private JsModuleClassLiteralChecker() {
    }

    @Override
    public void check(@NotNull KtClassLiteralExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext<?> context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        BindingContext bindingContext = context2.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, bindingTrace, context2.scope.getOwnerDescriptor(), descriptor2, expression2);
    }
}

