/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.js.naming.NameSuggestion;
import ksp.org.jetbrains.kotlin.js.naming.SuggestedName;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "suggestion", "Lksp/org/jetbrains/kotlin/js/naming/NameSuggestion;", "(Lorg/jetbrains/kotlin/js/naming/NameSuggestion;)V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsNameCharsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsNameCharsChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1745#2,3:47\n*S KotlinDebug\n*F\n+ 1 JsNameCharsChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker\n*L\n41#1:47,3\n*E\n"})
public abstract class AbstractNameCharsChecker
implements DeclarationChecker {
    @NotNull
    private final NameSuggestion suggestion;

    public AbstractNameCharsChecker(@NotNull NameSuggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        this.suggestion = suggestion;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (descriptor2 instanceof PropertyAccessorDescriptor && AnnotationsUtils.getJsName(descriptor2) == null) {
            return;
        }
        if (descriptor2 instanceof ConstructorDescriptor && AnnotationsUtils.getJsName(descriptor2) == null && AnnotationsUtils.isExportedObject(descriptor2, bindingContext2)) {
            return;
        }
        SuggestedName suggestedName = this.suggestion.suggest(descriptor2, bindingContext2);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        if (suggestedName2.getStable()) {
            boolean bl;
            block9: {
                Iterable $this$any$iv = suggestedName2.getNames();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(it), (Object)it))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context2.getTrace().report(ErrorsJs.NAME_CONTAINS_ILLEGAL_CHARS.on(declaration2));
            }
        }
    }
}

