/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.ir.AbstractIrFileEntry;
import ksp.org.jetbrains.kotlin.ir.IrElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ-\u0010\u0018\u001a\u0004\u0018\u0001H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\tJ\b\u0010!\u001a\u00020\u0011H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\f0\u0011\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lksp/org/jetbrains/kotlin/ir/PsiIrFileEntry;", "Lksp/org/jetbrains/kotlin/ir/AbstractIrFileEntry;", "psiFile", "Lksp/com/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "fileViewProvider", "Lksp/com/intellij/psi/FileViewProvider;", "Lksp/org/jetbrains/annotations/NotNull;", "lineStartOffsets", "", "getLineStartOffsets", "()[I", "maxOffset", "", "getMaxOffset", "()I", "name", "", "getName", "()Ljava/lang/String;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "psiFileName", "Lksp/org/jetbrains/annotations/NonNls;", "findPsiElement", "Lksp/com/intellij/psi/PsiElement;", "irElement", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "E", "psiElementClass", "Lkotlin/reflect/KClass;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "getLineOffsets", "getRecognizableName", "toString", "ir.tree"})
public final class PsiIrFileEntry
extends AbstractIrFileEntry {
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final String psiFileName;
    private final int maxOffset;
    @NotNull
    private final int[] lineStartOffsets;
    @NotNull
    private final FileViewProvider fileViewProvider;

    public PsiIrFileEntry(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
        Object object = this.psiFile.getVirtualFile();
        if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
            object = this.psiFile.getName();
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        this.psiFileName = object2;
        FileViewProvider fileViewProvider = this.psiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        this.fileViewProvider = fileViewProvider;
        Document document2 = this.fileViewProvider.getDocument();
        if (document2 == null) {
            throw new AssertionError((Object)("No document for " + this.psiFile));
        }
        Document document3 = document2;
        this.maxOffset = document3.getTextLength();
        int n = 0;
        int n2 = document3.getLineCount();
        int[] nArray = new int[n2];
        PsiIrFileEntry psiIrFileEntry = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = document3.getLineStartOffset(n3);
        }
        psiIrFileEntry.lineStartOffsets = nArray;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    @NotNull
    protected int[] getLineStartOffsets() {
        return this.lineStartOffsets;
    }

    private final String getRecognizableName() {
        return this.psiFileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getRecognizableName();
    }

    @NotNull
    public String toString() {
        return this.getRecognizableName();
    }

    @NotNull
    public final int[] getLineOffsets() {
        int[] nArray = this.getLineStartOffsets();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return nArray2;
    }

    @Nullable
    public final PsiElement findPsiElement(@NotNull IrElement irElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        for (psiElement = this.fileViewProvider.findElementAt(irElement.getStartOffset()); psiElement != null; psiElement = psiElement.getParent()) {
            TextRange textRange = psiElement.getTextRange();
            if (textRange != null ? irElement.getEndOffset() == textRange.getEndOffset() : false) break;
        }
        return psiElement;
    }

    @Nullable
    public final <E extends PsiElement> E findPsiElement(@NotNull IrElement irElement, @NotNull KClass<E> psiElementClass) {
        E e;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
        PsiElement psiElement = this.findPsiElement(irElement);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            e = (E)PsiTreeUtil.getParentOfType(it, JvmClassMappingKt.getJavaClass(psiElementClass), false);
        } else {
            e = null;
        }
        return e;
    }
}

