/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.KtSourceFile;
import ksp.org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponent;
import ksp.org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponentKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import ksp.org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenOnBooleanExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNothingExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenOnSealedClassExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer;
import ksp.org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J)\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lksp/org/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lksp/org/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "computeStatusForNonIntersectionType", "Lksp/org/jetbrains/kotlin/fir/expressions/ExhaustivenessStatus;", "unwrappedSubjectType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "processExhaustivenessCheck", "", "transformElement", "E", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformWhenExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,427:1\n1745#2,3:428\n48#3:431\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n*L\n117#1:428,3\n137#1:431\n*E\n"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents2) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents2, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents2;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        throw new IllegalArgumentException("Should not be there");
    }

    @Override
    @NotNull
    public FirStatement transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Object data2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            this.processExhaustivenessCheck(whenExpression);
            FirEnumWhenTrackerComponent firEnumWhenTrackerComponent = FirEnumWhenTrackerComponentKt.getEnumWhenTracker(this.bodyResolveComponents.getSession());
            if (firEnumWhenTrackerComponent == null) break block0;
            KtSourceFile ktSourceFile = this.bodyResolveComponents.getFile().getSourceFile();
            FirEnumWhenTrackerComponentKt.reportEnumUsageInWhen(firEnumWhenTrackerComponent, ktSourceFile != null ? ktSourceFile.getPath() : null, FirWhenExhaustivenessTransformer.Companion.getSubjectType(this.bodyResolveComponents.getSession(), whenExpression));
        }
        return whenExpression;
    }

    private final void processExhaustivenessCheck(FirWhenExpression whenExpression) {
        boolean bl;
        ConeKotlinType coneKotlinType;
        FirSession session2;
        block17: {
            block16: {
                boolean bl2;
                block15: {
                    Iterable $this$any$iv = whenExpression.getBranches();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirWhenBranch it = (FirWhenBranch)element$iv;
                            boolean bl3 = false;
                            if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.ProperlyExhaustive.INSTANCE);
                    return;
                }
                session2 = this.bodyResolveComponents.getSession();
                coneKotlinType = FirWhenExhaustivenessTransformer.Companion.getSubjectType(session2, whenExpression);
                if (coneKotlinType == null) break block16;
                ConeKotlinType it = coneKotlinType;
                boolean bl4 = false;
                ConeKotlinType coneKotlinType2 = TypeComponentsKt.getTypeApproximator(session2).approximateToSuperType(it, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
                if (coneKotlinType2 == null) {
                    coneKotlinType2 = it;
                }
                coneKotlinType = coneKotlinType2;
                if (coneKotlinType2 != null) break block17;
            }
            FirWhenExhaustivenessTransformer $this$processExhaustivenessCheck_u24lambda_u242 = this;
            boolean bl5 = false;
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH());
            return;
        }
        ConeKotlinType subjectType = coneKotlinType;
        if (whenExpression.getBranches().isEmpty() && ConeBuiltinTypeUtilsKt.isNothing(subjectType)) {
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.ExhaustiveAsNothing.INSTANCE);
            return;
        }
        ExhaustivenessStatus status2 = ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH();
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(subjectType, session2);
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = false;
        }
        if (!bl) {
            Collection unwrappedIntersectionTypes = FirWhenExhaustivenessTransformer.Companion.unwrapIntersectionType(subjectType);
            for (ConeKotlinType unwrappedSubjectType : unwrappedIntersectionTypes) {
                ExhaustivenessStatus localStatus = this.computeStatusForNonIntersectionType(unwrappedSubjectType, session2, whenExpression);
                if (localStatus == ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) {
                    status2 = localStatus;
                    break;
                }
                if (localStatus == ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH() || status2 != ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH()) continue;
                status2 = localStatus;
            }
        }
        whenExpression.replaceExhaustivenessStatus(status2);
    }

    private final ExhaustivenessStatus computeStatusForNonIntersectionType(ConeKotlinType unwrappedSubjectType, FirSession session2, FirWhenExpression whenExpression) {
        List checkers = FirWhenExhaustivenessTransformer.Companion.getCheckers(unwrappedSubjectType, session2);
        if (checkers.isEmpty()) {
            return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH();
        }
        List whenMissingCases = new ArrayList();
        FirWhenExhaustivenessTransformer.Companion.collectMissingCases(whenMissingCases, checkers, whenExpression, unwrappedSubjectType, session2);
        return whenMissingCases.isEmpty() ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)new ExhaustivenessStatus.NotExhaustive(whenMissingCases);
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedClassExhaustivenessChecker.INSTANCE, WhenOnNothingExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J8\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015*\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion;", "", "()V", "exhaustivenessCheckers", "", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "computeAllMissingCases", "Lksp/org/jetbrains/kotlin/diagnostics/WhenMissingCase;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "getCheckers", "subjectType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSubjectType", "collectMissingCases", "", "", "checkers", "unwrapIntersectionType", "", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n855#2,2:428\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n*L\n76#1:428,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<WhenMissingCase> computeAllMissingCases(@NotNull FirSession session2, @NotNull FirWhenExpression whenExpression) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            ConeKotlinType coneKotlinType = this.getSubjectType(session2, whenExpression);
            if (coneKotlinType == null) {
                return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH().getReasons();
            }
            ConeKotlinType subjectType = coneKotlinType;
            List $this$computeAllMissingCases_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (ConeKotlinType type2 : Companion.unwrapIntersectionType(subjectType)) {
                List<WhenExhaustivenessChecker> checkers = Companion.getCheckers(type2, session2);
                Companion.collectMissingCases($this$computeAllMissingCases_u24lambda_u240, checkers, whenExpression, type2, session2);
            }
            return CollectionsKt.build((List)list2);
        }

        private final ConeKotlinType getSubjectType(FirSession session2, FirWhenExpression whenExpression) {
            Object object = whenExpression.getSubjectVariable();
            if (object == null || (object = ((FirVariable)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                FirExpression firExpression2 = whenExpression.getSubject();
                if (firExpression2 != null) {
                    object = FirTypeUtilsKt.getResolvedType(firExpression2);
                } else {
                    return null;
                }
            }
            Object subjectType = object;
            return ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)subjectType, session2));
        }

        private final Collection<ConeKotlinType> unwrapIntersectionType(ConeKotlinType $this$unwrapIntersectionType) {
            Object object = $this$unwrapIntersectionType instanceof ConeIntersectionType ? (ConeIntersectionType)$this$unwrapIntersectionType : null;
            if (object == null || (object = ((ConeIntersectionType)object).getIntersectedTypes()) == null) {
                object = CollectionsKt.listOf((Object)$this$unwrapIntersectionType);
            }
            return object;
        }

        private final List<WhenExhaustivenessChecker> getCheckers(ConeKotlinType subjectType, FirSession session2) {
            List list2;
            List $this$getCheckers_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable $this$filterTo$iv = exhaustivenessCheckers;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                WhenExhaustivenessChecker it = (WhenExhaustivenessChecker)element$iv;
                boolean bl2 = false;
                if (!it.isApplicable(subjectType, session2)) continue;
                ((Collection)$this$getCheckers_u24lambda_u242).add(element$iv);
            }
            if (!((Collection)$this$getCheckers_u24lambda_u242).isEmpty() && ConeTypeUtilsKt.isMarkedNullable(subjectType)) {
                $this$getCheckers_u24lambda_u242.add(WhenOnNullableExhaustivenessChecker.INSTANCE);
            }
            return CollectionsKt.build((List)list2);
        }

        private final void collectMissingCases(List<WhenMissingCase> $this$collectMissingCases, List<? extends WhenExhaustivenessChecker> checkers, FirWhenExpression whenExpression, ConeKotlinType subjectType, FirSession session2) {
            for (WhenExhaustivenessChecker whenExhaustivenessChecker : checkers) {
                whenExhaustivenessChecker.computeMissingCases(whenExpression, subjectType, session2, (Collection<WhenMissingCase>)$this$collectMissingCases);
            }
            if ($this$collectMissingCases.isEmpty() && whenExpression.getBranches().isEmpty()) {
                $this$collectMissingCases.add(WhenMissingCase.Unknown.INSTANCE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

