/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0014J\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0018H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer;", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "designation", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/DesignationState;", "statusComputationSession", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "scopeForLocalClass", "Lksp/org/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "transformClassContent", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "data", "Lksp/org/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "needResolveMembers", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "needResolveNestedClassifiers", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n*L\n1#1,537:1\n152#2,4:538\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer\n*L\n132#1:538,4\n*E\n"})
public class FirDesignatedStatusResolveTransformer
extends AbstractFirStatusResolveTransformer {
    @NotNull
    private final DesignationState designation;

    public FirDesignatedStatusResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull DesignationState designation2, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)designation2, (String)"designation");
        Intrinsics.checkNotNullParameter((Object)statusComputationSession, (String)"statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, (String)"designationMapForLocalClasses");
        super(session2, scopeSession, statusComputationSession, designationMapForLocalClasses, scopeForLocalClass);
        this.designation = designation2;
    }

    @Override
    protected boolean needResolveMembers(@NotNull FirDeclaration $this$needResolveMembers) {
        Intrinsics.checkNotNullParameter((Object)$this$needResolveMembers, (String)"<this>");
        return this.designation.getClassLocated();
    }

    @Override
    protected boolean needResolveNestedClassifiers(@NotNull FirDeclaration $this$needResolveNestedClassifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$needResolveNestedClassifiers, (String)"<this>");
        return !this.designation.getClassLocated();
    }

    @Override
    @NotNull
    public FirStatement transformClassContent(@NotNull FirClass firClass, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        FirSession session$iv = this.getSession();
        boolean $i$f$whileAnalysing = false;
        try {
            FirStatement firStatement;
            boolean bl = false;
            if (this.designation.shouldSkipClass(firClass)) {
                return firClass;
            }
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)firClass.getSymbol(), FirResolvePhase.TYPES);
            boolean classLocated = this.designation.getClassLocated();
            if (classLocated) {
                boolean bl2 = Intrinsics.areEqual((Object)firClass, (Object)this.designation.getTargetClass());
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                StatusComputationSession.StatusComputationStatus computationStatus = this.getStatusComputationSession().startComputing(firClass);
                this.forceResolveStatusesOfSupertypes(firClass);
                if (computationStatus != StatusComputationSession.StatusComputationStatus.Computed) {
                    firClass.transformStatus(this, this.getStatusResolver().resolveStatus(firClass, this.getContainingClass(), false));
                }
            } else if (!(firClass.getStatus() instanceof FirResolvedDeclarationStatus)) {
                firClass.transformStatus(this, this.getStatusResolver().resolveStatus(firClass, this.getContainingClass(), false));
                this.getStatusComputationSession().computeOnlyClassStatus(firClass);
            }
            FirStatement it = firStatement = this.transformClass(firClass, data2);
            boolean bl3 = false;
            if (classLocated) {
                this.getStatusComputationSession().endComputing(firClass);
            }
            return firStatement;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(firClass, throwable$iv);
            throw null;
        }
    }
}

