/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0007\u00a8\u0006\f"}, d2={"fqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isInvoke", "", "Lksp/org/jetbrains/kotlin/name/CallableId;", "isIterator", "isIteratorHasNext", "isIteratorNext", "isKFunctionInvoke", "semantics"})
@SourceDebugExtension(value={"SMAP\nCallableIdUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableIdUtils.kt\norg/jetbrains/kotlin/fir/resolve/CallableIdUtilsKt\n+ 2 FirSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProviderKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,43:1\n83#2:44\n84#2,2:49\n22#3,4:45\n*S KotlinDebug\n*F\n+ 1 CallableIdUtils.kt\norg/jetbrains/kotlin/fir/resolve/CallableIdUtilsKt\n*L\n40#1:44\n40#1:49,2\n40#1:45,4\n*E\n"})
public final class CallableIdUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvoke(@NotNull CallableId $this$isInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvoke, (String)"<this>");
        if (CallableIdUtilsKt.isKFunctionInvoke($this$isInvoke)) return true;
        if (!Intrinsics.areEqual((Object)$this$isInvoke.getCallableName().asString(), (Object)"invoke")) return false;
        FqName fqName2 = $this$isInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, (String)"Function", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isInvoke.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKFunctionInvoke(@NotNull CallableId $this$isKFunctionInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunctionInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isKFunctionInvoke.getCallableName().asString(), (Object)"invoke")) return false;
        FqName fqName2 = $this$isKFunctionInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, (String)"KFunction", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isKFunctionInvoke.getPackageName().asString(), (Object)"kotlin.reflect")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorNext(@NotNull CallableId $this$isIteratorNext) {
        Intrinsics.checkNotNullParameter((Object)$this$isIteratorNext, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isIteratorNext.getCallableName().asString(), (Object)"next")) return false;
        FqName fqName2 = $this$isIteratorNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, (String)"Iterator", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isIteratorNext.getPackageName().asString(), (Object)"kotlin.collections")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorHasNext(@NotNull CallableId $this$isIteratorHasNext) {
        Intrinsics.checkNotNullParameter((Object)$this$isIteratorHasNext, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isIteratorHasNext.getCallableName().asString(), (Object)"hasNext")) return false;
        FqName fqName2 = $this$isIteratorHasNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, (String)"Iterator", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isIteratorHasNext.getPackageName().asString(), (Object)"kotlin.collections")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIterator(@NotNull CallableId $this$isIterator) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterator, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isIterator.getCallableName().asString(), (Object)"iterator")) return false;
        Object[] objectArray = new String[]{"kotlin", "kotlin.collections", "kotlin.ranges"};
        String string2 = $this$isIterator.getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        if (!ArraysKt.contains((Object[])objectArray, (Object)string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName fqName(@NotNull FirAnnotation $this$fqName, @NotNull FirSession session2) {
        FirBasedSymbol firBasedSymbol;
        void $this$getSymbolByTypeRef$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fqName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirSymbolProvider firSymbolProvider = FirSymbolProviderKt.getSymbolProvider(session2);
        FirTypeRef typeRef$iv = $this$fqName.getAnnotationTypeRef();
        boolean $i$f$getSymbolByTypeRef = false;
        FirTypeRef $this$coneTypeSafe$iv$iv = typeRef$iv;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeSimpleKotlinType)) {
            coneKotlinType = null;
        }
        ConeSimpleKotlinType coneSimpleKotlinType = (ConeSimpleKotlinType)((ConeKotlinType)((ConeSimpleKotlinType)coneKotlinType));
        ConeSimpleKotlinType coneSimpleKotlinType2 = coneSimpleKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, $this$getSymbolByTypeRef$iv.getSession()) : null;
        Object object = coneSimpleKotlinType2 instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)coneSimpleKotlinType2 : null;
        if (object == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            firBasedSymbol = null;
        } else {
            Object lookupTag$iv = object;
            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag((FirSymbolProvider)$this$getSymbolByTypeRef$iv, (ConeClassifierLookupTag)lookupTag$iv);
            if (!(firClassifierSymbol instanceof FirRegularClassSymbol)) {
                firClassifierSymbol = null;
            }
            firBasedSymbol = (FirRegularClassSymbol)firClassifierSymbol;
        }
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)firBasedSymbol;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol symbol2 = firRegularClassSymbol;
        return symbol2.getClassId().asSingleFqName();
    }
}

