/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirArrayLiteralChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInsideAnnotationCall", "", "isInsideAnnotationClass", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedArrayLiteralChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,66:1\n1745#2,3:67\n67#3:70\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n*L\n38#1:67,3\n49#1:70\n*E\n"})
public final class FirUnsupportedArrayLiteralChecker
extends FirExpressionChecker<FirArrayLiteral> {
    @NotNull
    public static final FirUnsupportedArrayLiteralChecker INSTANCE = new FirUnsupportedArrayLiteralChecker();

    private FirUnsupportedArrayLiteralChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirArrayLiteral expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(this.isInsideAnnotationCall(context2) || !(!((Collection)context2.getCallsOrAssignments()).isEmpty()) && this.isInsideAnnotationClass(context2))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Collection literals outside of annotations", (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isInsideAnnotationCall(CheckerContext context2) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = CollectionsKt.asReversed(context2.getCallsOrAssignments());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    FirStatement it = (FirStatement)element$iv;
                    boolean bl3 = false;
                    FirStatement firStatement = it;
                    if (firStatement instanceof FirFunctionCall) {
                        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType((FirExpression)it), context2.getSession());
                        bl2 = (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
                    } else {
                        bl2 = firStatement instanceof FirAnnotationCall;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isInsideAnnotationClass(CheckerContext context2) {
        for (FirDeclaration declaration2 : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (declaration2 instanceof FirRegularClass) {
                FirRegularClass $this$isCompanion$iv = (FirRegularClass)declaration2;
                boolean $i$f$isCompanion = false;
                if ($this$isCompanion$iv.getStatus().isCompanion()) continue;
                if (((FirRegularClass)declaration2).getClassKind() != ClassKind.ANNOTATION_CLASS) break;
                return true;
            }
            if (declaration2 instanceof FirValueParameter || declaration2 instanceof FirPrimaryConstructor) continue;
        }
        return false;
    }
}

