/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.BackendContext;
import ksp.org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\u00020\n*\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lksp/org/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lksp/org/jetbrains/kotlin/backend/common/BackendContext;", "innerClassesSupport", "Lksp/org/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "lowerConstructor", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "transformFlat", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "shouldInitializeOuterThis", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nInnerClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InnerClassesLowering.kt\norg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n1745#2,3:304\n*S KotlinDebug\n*F\n+ 1 InnerClassesLowering.kt\norg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering\n*L\n104#1:304,3\n*E\n"})
public final class InnerClassesLowering
implements DeclarationTransformer {
    @NotNull
    private final BackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassesLowering(@NotNull BackendContext context2, @NotNull InnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)innerClassesSupport, (String)"innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof IrClass && ((IrClass)declaration2).isInner()) {
            ((Collection)((IrClass)declaration2).getDeclarations()).add(this.innerClassesSupport.getOuterThisField((IrClass)declaration2));
        } else if (declaration2 instanceof IrConstructor) {
            IrClass irClass = IrUtilsKt.getParentAsClass(declaration2);
            if (!irClass.isInner()) {
                return null;
            }
            IrConstructor newConstructor = this.lowerConstructor((IrConstructor)declaration2);
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.innerClassesSupport, (IrConstructor)declaration2);
            VariableRemapper variableRemapper = new VariableRemapper(oldConstructorParameterToNew);
            for (Map.Entry entry : oldConstructorParameterToNew.entrySet()) {
                IrExpressionBody irExpressionBody;
                IrValueParameter newParam;
                IrValueParameter oldParam = (IrValueParameter)entry.getKey();
                IrValueParameter irValueParameter = newParam = (IrValueParameter)entry.getValue();
                if (oldParam.getDefaultValue() != null) {
                    void oldDefault;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    boolean bl = false;
                    irExpressionBody = this.context.getIrFactory().createExpressionBody(oldDefault.getStartOffset(), oldDefault.getEndOffset(), (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents(oldDefault.getExpression().transform((IrElementTransformer)variableRemapper, (Object)null), newConstructor));
                    irValueParameter = irValueParameter2;
                } else {
                    irExpressionBody = null;
                }
                irValueParameter.setDefaultValue(irExpressionBody);
            }
            return CollectionsKt.listOf((Object)newConstructor);
        }
        return null;
    }

    private final IrConstructor lowerConstructor(IrConstructor irConstructor2) {
        IrConstructor loweredConstructor;
        block1: {
            loweredConstructor = this.innerClassesSupport.getInnerClassConstructorWithOuterThisParameter(irConstructor2);
            IrValueParameter outerThisParameter = loweredConstructor.getValueParameters().get(0);
            IrClass irClass = IrUtilsKt.getParentAsClass(irConstructor2);
            IrField parentThisField = this.innerClassesSupport.getOuterThisField(irClass);
            IrBody irBody = irConstructor2.getBody();
            if (irBody == null) break block1;
            IrBody blockBody = irBody;
            boolean bl = false;
            if (!(blockBody instanceof IrBlockBody)) {
                throw new AssertionError((Object)("Unexpected constructor body: " + irConstructor2.getBody()));
            }
            loweredConstructor.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), blockBody.getStartOffset(), blockBody.getEndOffset(), (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(this, irConstructor2, blockBody, loweredConstructor, irClass, parentThisField, outerThisParameter){
                final /* synthetic */ InnerClassesLowering this$0;
                final /* synthetic */ IrConstructor $irConstructor;
                final /* synthetic */ IrBody $blockBody;
                final /* synthetic */ IrConstructor $loweredConstructor;
                final /* synthetic */ IrClass $irClass;
                final /* synthetic */ IrField $parentThisField;
                final /* synthetic */ IrValueParameter $outerThisParameter;
                {
                    this.this$0 = $receiver;
                    this.$irConstructor = $irConstructor;
                    this.$blockBody = $blockBody;
                    this.$loweredConstructor = $loweredConstructor;
                    this.$irClass = $irClass;
                    this.$parentThisField = $parentThisField;
                    this.$outerThisParameter = $outerThisParameter;
                    super(1);
                }

                public final void invoke(IrBlockBody $this$createBlockBody) {
                    Object object;
                    Object it;
                    Object object2;
                    Object object3;
                    Object object4;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                        if (InnerClassesLowering.access$shouldInitializeOuterThis(this.this$0, this.$irConstructor)) {
                            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), (IrSymbol)this.$irConstructor.getSymbol(), this.$irConstructor.getStartOffset(), this.$irConstructor.getEndOffset());
                            object4 = this.$irClass;
                            object3 = this.$parentThisField;
                            object2 = this.$outerThisParameter;
                            DeclarationIrBuilder $this$invoke_u24lambda_u240 = declarationIrBuilder;
                            boolean bl = false;
                            List<IrStatement> list2 = $this$createBlockBody.getStatements();
                            IrBuilderWithScope irBuilderWithScope = $this$invoke_u24lambda_u240;
                            IrBuilderWithScope irBuilderWithScope2 = $this$invoke_u24lambda_u240;
                            IrValueParameter irValueParameter = ((IrClass)object4).getThisReceiver();
                            Intrinsics.checkNotNull((Object)irValueParameter);
                            list2.add(0, ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), (IrField)object3, ExpressionHelpersKt.irGet($this$invoke_u24lambda_u240, (IrValueDeclaration)object2), null, 8, null));
                        }
                        $this$createBlockBody.getStatements().addAll((Collection<IrStatement>)((IrBlockBody)this.$blockBody).getStatements());
                        object4 = $this$createBlockBody.getStatements();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            object2 = object3.next();
                            it = (IrStatement)object2;
                            boolean bl = false;
                            if (!(it instanceof IrInstanceInitializerCall)) continue;
                            object = object2;
                            break block5;
                        }
                        object = null;
                    }
                    if (object == null) {
                        Object v5;
                        block6: {
                            object2 = $this$createBlockBody.getStatements();
                            it = object2.iterator();
                            while (it.hasNext()) {
                                E e = it.next();
                                IrStatement it2 = (IrStatement)e;
                                boolean bl = false;
                                if (!(it2 instanceof IrDelegatingConstructorCall)) continue;
                                v5 = e;
                                break block6;
                            }
                            v5 = null;
                        }
                        IrDelegatingConstructorCall irDelegatingConstructorCall2 = v5;
                        if (irDelegatingConstructorCall2 == null) {
                            throw new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump$default(this.$irConstructor, null, 1, null)));
                        }
                        IrDelegatingConstructorCall delegatingConstructorCall = irDelegatingConstructorCall2;
                        object4 = delegatingConstructorCall;
                        object3 = this.$outerThisParameter;
                        Object $this$invoke_u24lambda_u243 = object4;
                        boolean bl = false;
                        ((IrMemberAccessExpression)$this$invoke_u24lambda_u243).setDispatchReceiver(new IrGetValueImpl($this$invoke_u24lambda_u243.getStartOffset(), $this$invoke_u24lambda_u243.getEndOffset(), ((IrValueParameter)object3).getSymbol(), null, 8, null));
                    }
                    PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$createBlockBody, this.$loweredConstructor);
                    Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(InnerClassesLowering.access$getInnerClassesSupport$p(this.this$0), this.$irConstructor);
                    IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new VariableRemapper(oldConstructorParameterToNew));
                }
            })));
        }
        return loweredConstructor;
    }

    private final boolean shouldInitializeOuterThis(IrConstructor $this$shouldInitializeOuterThis) {
        boolean bl;
        block4: {
            IrBody irBody = $this$shouldInitializeOuterThis.getBody();
            IrBlockBody irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
            if (irBlockBody == null) {
                return false;
            }
            IrBlockBody irBlockBody2 = irBlockBody;
            Iterable $this$any$iv = irBlockBody2.getStatements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrInstanceInitializerCall)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$shouldInitializeOuterThis(InnerClassesLowering $this, IrConstructor $receiver) {
        return $this.shouldInitializeOuterThis($receiver);
    }

    public static final /* synthetic */ InnerClassesSupport access$getInnerClassesSupport$p(InnerClassesLowering $this) {
        return $this.innerClassesSupport;
    }
}

